<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Foundation.RulesOverview.Request StructType
 * @subpackage Structs
 */
class BizAction_Foundation_RulesOverview_Request extends AnyEntity
{
    /**
     * The ContextEntityId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContextEntityId;
    /**
     * The ContextEntityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContextEntityName;
    /**
     * The EditHigherLevelImageUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EditHigherLevelImageUrl;
    /**
     * The EditImageUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EditImageUrl;
    /**
     * The IsBringInactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsBringInactive;
    /**
     * The Items
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfBizAction_Foundation_RulesOverview_RuleSystem
     */
    public $Items;
    /**
     * The JsonData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $JsonData;
    /**
     * The MasterCompanyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MasterCompanyName;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The RetrieveOverridenRules
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $RetrieveOverridenRules;
    /**
     * Constructor method for BizAction.Foundation.RulesOverview.Request
     * @uses BizAction_Foundation_RulesOverview_Request::setContextEntityId()
     * @uses BizAction_Foundation_RulesOverview_Request::setContextEntityName()
     * @uses BizAction_Foundation_RulesOverview_Request::setEditHigherLevelImageUrl()
     * @uses BizAction_Foundation_RulesOverview_Request::setEditImageUrl()
     * @uses BizAction_Foundation_RulesOverview_Request::setIsBringInactive()
     * @uses BizAction_Foundation_RulesOverview_Request::setItems()
     * @uses BizAction_Foundation_RulesOverview_Request::setJsonData()
     * @uses BizAction_Foundation_RulesOverview_Request::setMasterCompanyName()
     * @uses BizAction_Foundation_RulesOverview_Request::setOrganizationUnitId()
     * @uses BizAction_Foundation_RulesOverview_Request::setRetrieveOverridenRules()
     * @param string $contextEntityId
     * @param string $contextEntityName
     * @param string $editHigherLevelImageUrl
     * @param string $editImageUrl
     * @param bool $isBringInactive
     * @param \patest\StructType\RecordSetOfBizAction_Foundation_RulesOverview_RuleSystem $items
     * @param string $jsonData
     * @param string $masterCompanyName
     * @param string $organizationUnitId
     * @param bool $retrieveOverridenRules
     */
    public function __construct($contextEntityId = null, $contextEntityName = null, $editHigherLevelImageUrl = null, $editImageUrl = null, $isBringInactive = null, \patest\StructType\RecordSetOfBizAction_Foundation_RulesOverview_RuleSystem $items = null, $jsonData = null, $masterCompanyName = null, $organizationUnitId = null, $retrieveOverridenRules = null)
    {
        $this
            ->setContextEntityId($contextEntityId)
            ->setContextEntityName($contextEntityName)
            ->setEditHigherLevelImageUrl($editHigherLevelImageUrl)
            ->setEditImageUrl($editImageUrl)
            ->setIsBringInactive($isBringInactive)
            ->setItems($items)
            ->setJsonData($jsonData)
            ->setMasterCompanyName($masterCompanyName)
            ->setOrganizationUnitId($organizationUnitId)
            ->setRetrieveOverridenRules($retrieveOverridenRules);
    }
    /**
     * Get ContextEntityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContextEntityId()
    {
        return isset($this->ContextEntityId) ? $this->ContextEntityId : null;
    }
    /**
     * Set ContextEntityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contextEntityId
     * @return \patest\StructType\BizAction_Foundation_RulesOverview_Request
     */
    public function setContextEntityId($contextEntityId = null)
    {
        // validation for constraint: string
        if (!is_null($contextEntityId) && !is_string($contextEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contextEntityId, true), gettype($contextEntityId)), __LINE__);
        }
        if (is_null($contextEntityId) || (is_array($contextEntityId) && empty($contextEntityId))) {
            unset($this->ContextEntityId);
        } else {
            $this->ContextEntityId = $contextEntityId;
        }
        return $this;
    }
    /**
     * Get ContextEntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContextEntityName()
    {
        return isset($this->ContextEntityName) ? $this->ContextEntityName : null;
    }
    /**
     * Set ContextEntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contextEntityName
     * @return \patest\StructType\BizAction_Foundation_RulesOverview_Request
     */
    public function setContextEntityName($contextEntityName = null)
    {
        // validation for constraint: string
        if (!is_null($contextEntityName) && !is_string($contextEntityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contextEntityName, true), gettype($contextEntityName)), __LINE__);
        }
        if (is_null($contextEntityName) || (is_array($contextEntityName) && empty($contextEntityName))) {
            unset($this->ContextEntityName);
        } else {
            $this->ContextEntityName = $contextEntityName;
        }
        return $this;
    }
    /**
     * Get EditHigherLevelImageUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEditHigherLevelImageUrl()
    {
        return isset($this->EditHigherLevelImageUrl) ? $this->EditHigherLevelImageUrl : null;
    }
    /**
     * Set EditHigherLevelImageUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $editHigherLevelImageUrl
     * @return \patest\StructType\BizAction_Foundation_RulesOverview_Request
     */
    public function setEditHigherLevelImageUrl($editHigherLevelImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($editHigherLevelImageUrl) && !is_string($editHigherLevelImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($editHigherLevelImageUrl, true), gettype($editHigherLevelImageUrl)), __LINE__);
        }
        if (is_null($editHigherLevelImageUrl) || (is_array($editHigherLevelImageUrl) && empty($editHigherLevelImageUrl))) {
            unset($this->EditHigherLevelImageUrl);
        } else {
            $this->EditHigherLevelImageUrl = $editHigherLevelImageUrl;
        }
        return $this;
    }
    /**
     * Get EditImageUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEditImageUrl()
    {
        return isset($this->EditImageUrl) ? $this->EditImageUrl : null;
    }
    /**
     * Set EditImageUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $editImageUrl
     * @return \patest\StructType\BizAction_Foundation_RulesOverview_Request
     */
    public function setEditImageUrl($editImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($editImageUrl) && !is_string($editImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($editImageUrl, true), gettype($editImageUrl)), __LINE__);
        }
        if (is_null($editImageUrl) || (is_array($editImageUrl) && empty($editImageUrl))) {
            unset($this->EditImageUrl);
        } else {
            $this->EditImageUrl = $editImageUrl;
        }
        return $this;
    }
    /**
     * Get IsBringInactive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsBringInactive()
    {
        return isset($this->IsBringInactive) ? $this->IsBringInactive : null;
    }
    /**
     * Set IsBringInactive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isBringInactive
     * @return \patest\StructType\BizAction_Foundation_RulesOverview_Request
     */
    public function setIsBringInactive($isBringInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBringInactive) && !is_bool($isBringInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isBringInactive, true), gettype($isBringInactive)), __LINE__);
        }
        if (is_null($isBringInactive) || (is_array($isBringInactive) && empty($isBringInactive))) {
            unset($this->IsBringInactive);
        } else {
            $this->IsBringInactive = $isBringInactive;
        }
        return $this;
    }
    /**
     * Get Items value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfBizAction_Foundation_RulesOverview_RuleSystem|null
     */
    public function getItems()
    {
        return isset($this->Items) ? $this->Items : null;
    }
    /**
     * Set Items value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfBizAction_Foundation_RulesOverview_RuleSystem $items
     * @return \patest\StructType\BizAction_Foundation_RulesOverview_Request
     */
    public function setItems(\patest\StructType\RecordSetOfBizAction_Foundation_RulesOverview_RuleSystem $items = null)
    {
        if (is_null($items) || (is_array($items) && empty($items))) {
            unset($this->Items);
        } else {
            $this->Items = $items;
        }
        return $this;
    }
    /**
     * Get JsonData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getJsonData()
    {
        return isset($this->JsonData) ? $this->JsonData : null;
    }
    /**
     * Set JsonData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $jsonData
     * @return \patest\StructType\BizAction_Foundation_RulesOverview_Request
     */
    public function setJsonData($jsonData = null)
    {
        // validation for constraint: string
        if (!is_null($jsonData) && !is_string($jsonData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jsonData, true), gettype($jsonData)), __LINE__);
        }
        if (is_null($jsonData) || (is_array($jsonData) && empty($jsonData))) {
            unset($this->JsonData);
        } else {
            $this->JsonData = $jsonData;
        }
        return $this;
    }
    /**
     * Get MasterCompanyName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMasterCompanyName()
    {
        return isset($this->MasterCompanyName) ? $this->MasterCompanyName : null;
    }
    /**
     * Set MasterCompanyName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $masterCompanyName
     * @return \patest\StructType\BizAction_Foundation_RulesOverview_Request
     */
    public function setMasterCompanyName($masterCompanyName = null)
    {
        // validation for constraint: string
        if (!is_null($masterCompanyName) && !is_string($masterCompanyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($masterCompanyName, true), gettype($masterCompanyName)), __LINE__);
        }
        if (is_null($masterCompanyName) || (is_array($masterCompanyName) && empty($masterCompanyName))) {
            unset($this->MasterCompanyName);
        } else {
            $this->MasterCompanyName = $masterCompanyName;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\BizAction_Foundation_RulesOverview_Request
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get RetrieveOverridenRules value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getRetrieveOverridenRules()
    {
        return isset($this->RetrieveOverridenRules) ? $this->RetrieveOverridenRules : null;
    }
    /**
     * Set RetrieveOverridenRules value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $retrieveOverridenRules
     * @return \patest\StructType\BizAction_Foundation_RulesOverview_Request
     */
    public function setRetrieveOverridenRules($retrieveOverridenRules = null)
    {
        // validation for constraint: boolean
        if (!is_null($retrieveOverridenRules) && !is_bool($retrieveOverridenRules)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($retrieveOverridenRules, true), gettype($retrieveOverridenRules)), __LINE__);
        }
        if (is_null($retrieveOverridenRules) || (is_array($retrieveOverridenRules) && empty($retrieveOverridenRules))) {
            unset($this->RetrieveOverridenRules);
        } else {
            $this->RetrieveOverridenRules = $retrieveOverridenRules;
        }
        return $this;
    }
}
