<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Foundation.BuildUrlForAttachmentDownload.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Foundation_BuildUrlForAttachmentDownload_Request extends AnyEntity
{
    /**
     * The ActualEntityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActualEntityName;
    /**
     * The AttachmentId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AttachmentId;
    /**
     * The ServiceName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServiceName;
    /**
     * Constructor method for
     * BizAction.Foundation.BuildUrlForAttachmentDownload.Request
     * @uses BizAction_Foundation_BuildUrlForAttachmentDownload_Request::setActualEntityName()
     * @uses BizAction_Foundation_BuildUrlForAttachmentDownload_Request::setAttachmentId()
     * @uses BizAction_Foundation_BuildUrlForAttachmentDownload_Request::setServiceName()
     * @param string $actualEntityName
     * @param string $attachmentId
     * @param string $serviceName
     */
    public function __construct($actualEntityName = null, $attachmentId = null, $serviceName = null)
    {
        $this
            ->setActualEntityName($actualEntityName)
            ->setAttachmentId($attachmentId)
            ->setServiceName($serviceName);
    }
    /**
     * Get ActualEntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActualEntityName()
    {
        return isset($this->ActualEntityName) ? $this->ActualEntityName : null;
    }
    /**
     * Set ActualEntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $actualEntityName
     * @return \patest\StructType\BizAction_Foundation_BuildUrlForAttachmentDownload_Request
     */
    public function setActualEntityName($actualEntityName = null)
    {
        // validation for constraint: string
        if (!is_null($actualEntityName) && !is_string($actualEntityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actualEntityName, true), gettype($actualEntityName)), __LINE__);
        }
        if (is_null($actualEntityName) || (is_array($actualEntityName) && empty($actualEntityName))) {
            unset($this->ActualEntityName);
        } else {
            $this->ActualEntityName = $actualEntityName;
        }
        return $this;
    }
    /**
     * Get AttachmentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAttachmentId()
    {
        return isset($this->AttachmentId) ? $this->AttachmentId : null;
    }
    /**
     * Set AttachmentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $attachmentId
     * @return \patest\StructType\BizAction_Foundation_BuildUrlForAttachmentDownload_Request
     */
    public function setAttachmentId($attachmentId = null)
    {
        // validation for constraint: string
        if (!is_null($attachmentId) && !is_string($attachmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attachmentId, true), gettype($attachmentId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($attachmentId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $attachmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($attachmentId, true)), __LINE__);
        }
        if (is_null($attachmentId) || (is_array($attachmentId) && empty($attachmentId))) {
            unset($this->AttachmentId);
        } else {
            $this->AttachmentId = $attachmentId;
        }
        return $this;
    }
    /**
     * Get ServiceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceName()
    {
        return isset($this->ServiceName) ? $this->ServiceName : null;
    }
    /**
     * Set ServiceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceName
     * @return \patest\StructType\BizAction_Foundation_BuildUrlForAttachmentDownload_Request
     */
    public function setServiceName($serviceName = null)
    {
        // validation for constraint: string
        if (!is_null($serviceName) && !is_string($serviceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceName, true), gettype($serviceName)), __LINE__);
        }
        if (is_null($serviceName) || (is_array($serviceName) && empty($serviceName))) {
            unset($this->ServiceName);
        } else {
            $this->ServiceName = $serviceName;
        }
        return $this;
    }
}
