<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Donation.AddMatchingGiftManually.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Donation_AddMatchingGiftManually_Request extends AnyEntity
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Amount;
    /**
     * The DefaultPercentage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DefaultPercentage;
    /**
     * The MatcherId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MatcherId;
    /**
     * The MaximumByClient
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaximumByClient;
    /**
     * The MinimumByClient
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MinimumByClient;
    /**
     * The OriginalDonationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OriginalDonationId;
    /**
     * Constructor method for BizAction.Donation.AddMatchingGiftManually.Request
     * @uses BizAction_Donation_AddMatchingGiftManually_Request::setAmount()
     * @uses BizAction_Donation_AddMatchingGiftManually_Request::setDefaultPercentage()
     * @uses BizAction_Donation_AddMatchingGiftManually_Request::setMatcherId()
     * @uses BizAction_Donation_AddMatchingGiftManually_Request::setMaximumByClient()
     * @uses BizAction_Donation_AddMatchingGiftManually_Request::setMinimumByClient()
     * @uses BizAction_Donation_AddMatchingGiftManually_Request::setOriginalDonationId()
     * @param float $amount
     * @param int $defaultPercentage
     * @param string $matcherId
     * @param int $maximumByClient
     * @param int $minimumByClient
     * @param string $originalDonationId
     */
    public function __construct($amount = null, $defaultPercentage = null, $matcherId = null, $maximumByClient = null, $minimumByClient = null, $originalDonationId = null)
    {
        $this
            ->setAmount($amount)
            ->setDefaultPercentage($defaultPercentage)
            ->setMatcherId($matcherId)
            ->setMaximumByClient($maximumByClient)
            ->setMinimumByClient($minimumByClient)
            ->setOriginalDonationId($originalDonationId);
    }
    /**
     * Get Amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAmount()
    {
        return isset($this->Amount) ? $this->Amount : null;
    }
    /**
     * Set Amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $amount
     * @return \patest\StructType\BizAction_Donation_AddMatchingGiftManually_Request
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        if (is_null($amount) || (is_array($amount) && empty($amount))) {
            unset($this->Amount);
        } else {
            $this->Amount = $amount;
        }
        return $this;
    }
    /**
     * Get DefaultPercentage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDefaultPercentage()
    {
        return isset($this->DefaultPercentage) ? $this->DefaultPercentage : null;
    }
    /**
     * Set DefaultPercentage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $defaultPercentage
     * @return \patest\StructType\BizAction_Donation_AddMatchingGiftManually_Request
     */
    public function setDefaultPercentage($defaultPercentage = null)
    {
        // validation for constraint: int
        if (!is_null($defaultPercentage) && !(is_int($defaultPercentage) || ctype_digit($defaultPercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($defaultPercentage, true), gettype($defaultPercentage)), __LINE__);
        }
        if (is_null($defaultPercentage) || (is_array($defaultPercentage) && empty($defaultPercentage))) {
            unset($this->DefaultPercentage);
        } else {
            $this->DefaultPercentage = $defaultPercentage;
        }
        return $this;
    }
    /**
     * Get MatcherId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMatcherId()
    {
        return isset($this->MatcherId) ? $this->MatcherId : null;
    }
    /**
     * Set MatcherId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $matcherId
     * @return \patest\StructType\BizAction_Donation_AddMatchingGiftManually_Request
     */
    public function setMatcherId($matcherId = null)
    {
        // validation for constraint: string
        if (!is_null($matcherId) && !is_string($matcherId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($matcherId, true), gettype($matcherId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($matcherId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $matcherId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($matcherId, true)), __LINE__);
        }
        if (is_null($matcherId) || (is_array($matcherId) && empty($matcherId))) {
            unset($this->MatcherId);
        } else {
            $this->MatcherId = $matcherId;
        }
        return $this;
    }
    /**
     * Get MaximumByClient value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaximumByClient()
    {
        return isset($this->MaximumByClient) ? $this->MaximumByClient : null;
    }
    /**
     * Set MaximumByClient value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maximumByClient
     * @return \patest\StructType\BizAction_Donation_AddMatchingGiftManually_Request
     */
    public function setMaximumByClient($maximumByClient = null)
    {
        // validation for constraint: int
        if (!is_null($maximumByClient) && !(is_int($maximumByClient) || ctype_digit($maximumByClient))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maximumByClient, true), gettype($maximumByClient)), __LINE__);
        }
        if (is_null($maximumByClient) || (is_array($maximumByClient) && empty($maximumByClient))) {
            unset($this->MaximumByClient);
        } else {
            $this->MaximumByClient = $maximumByClient;
        }
        return $this;
    }
    /**
     * Get MinimumByClient value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMinimumByClient()
    {
        return isset($this->MinimumByClient) ? $this->MinimumByClient : null;
    }
    /**
     * Set MinimumByClient value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $minimumByClient
     * @return \patest\StructType\BizAction_Donation_AddMatchingGiftManually_Request
     */
    public function setMinimumByClient($minimumByClient = null)
    {
        // validation for constraint: int
        if (!is_null($minimumByClient) && !(is_int($minimumByClient) || ctype_digit($minimumByClient))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minimumByClient, true), gettype($minimumByClient)), __LINE__);
        }
        if (is_null($minimumByClient) || (is_array($minimumByClient) && empty($minimumByClient))) {
            unset($this->MinimumByClient);
        } else {
            $this->MinimumByClient = $minimumByClient;
        }
        return $this;
    }
    /**
     * Get OriginalDonationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginalDonationId()
    {
        return isset($this->OriginalDonationId) ? $this->OriginalDonationId : null;
    }
    /**
     * Set OriginalDonationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originalDonationId
     * @return \patest\StructType\BizAction_Donation_AddMatchingGiftManually_Request
     */
    public function setOriginalDonationId($originalDonationId = null)
    {
        // validation for constraint: string
        if (!is_null($originalDonationId) && !is_string($originalDonationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalDonationId, true), gettype($originalDonationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($originalDonationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $originalDonationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($originalDonationId, true)), __LINE__);
        }
        if (is_null($originalDonationId) || (is_array($originalDonationId) && empty($originalDonationId))) {
            unset($this->OriginalDonationId);
        } else {
            $this->OriginalDonationId = $originalDonationId;
        }
        return $this;
    }
}
