<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Crm.ValidateMultipleContactDetails.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Crm_ValidateMultipleContactDetails_Request extends AnyEntity
{
    /**
     * The ContactDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContactDetail;
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfCrm_ContactDetail
     */
    public $Details;
    /**
     * The EntityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityName;
    /**
     * The ValidationType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValidationType;
    /**
     * Constructor method for BizAction.Crm.ValidateMultipleContactDetails.Request
     * @uses BizAction_Crm_ValidateMultipleContactDetails_Request::setContactDetail()
     * @uses BizAction_Crm_ValidateMultipleContactDetails_Request::setDetails()
     * @uses BizAction_Crm_ValidateMultipleContactDetails_Request::setEntityName()
     * @uses BizAction_Crm_ValidateMultipleContactDetails_Request::setValidationType()
     * @param string $contactDetail
     * @param \patest\StructType\RecordSetOfCrm_ContactDetail $details
     * @param string $entityName
     * @param string $validationType
     */
    public function __construct($contactDetail = null, \patest\StructType\RecordSetOfCrm_ContactDetail $details = null, $entityName = null, $validationType = null)
    {
        $this
            ->setContactDetail($contactDetail)
            ->setDetails($details)
            ->setEntityName($entityName)
            ->setValidationType($validationType);
    }
    /**
     * Get ContactDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContactDetail()
    {
        return isset($this->ContactDetail) ? $this->ContactDetail : null;
    }
    /**
     * Set ContactDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contactDetail
     * @return \patest\StructType\BizAction_Crm_ValidateMultipleContactDetails_Request
     */
    public function setContactDetail($contactDetail = null)
    {
        // validation for constraint: string
        if (!is_null($contactDetail) && !is_string($contactDetail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactDetail, true), gettype($contactDetail)), __LINE__);
        }
        if (is_null($contactDetail) || (is_array($contactDetail) && empty($contactDetail))) {
            unset($this->ContactDetail);
        } else {
            $this->ContactDetail = $contactDetail;
        }
        return $this;
    }
    /**
     * Get Details value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfCrm_ContactDetail|null
     */
    public function getDetails()
    {
        return isset($this->Details) ? $this->Details : null;
    }
    /**
     * Set Details value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfCrm_ContactDetail $details
     * @return \patest\StructType\BizAction_Crm_ValidateMultipleContactDetails_Request
     */
    public function setDetails(\patest\StructType\RecordSetOfCrm_ContactDetail $details = null)
    {
        if (is_null($details) || (is_array($details) && empty($details))) {
            unset($this->Details);
        } else {
            $this->Details = $details;
        }
        return $this;
    }
    /**
     * Get EntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityName()
    {
        return isset($this->EntityName) ? $this->EntityName : null;
    }
    /**
     * Set EntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityName
     * @return \patest\StructType\BizAction_Crm_ValidateMultipleContactDetails_Request
     */
    public function setEntityName($entityName = null)
    {
        // validation for constraint: string
        if (!is_null($entityName) && !is_string($entityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityName, true), gettype($entityName)), __LINE__);
        }
        if (is_null($entityName) || (is_array($entityName) && empty($entityName))) {
            unset($this->EntityName);
        } else {
            $this->EntityName = $entityName;
        }
        return $this;
    }
    /**
     * Get ValidationType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValidationType()
    {
        return isset($this->ValidationType) ? $this->ValidationType : null;
    }
    /**
     * Set ValidationType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ValidationType::valueIsValid()
     * @uses \patest\EnumType\ValidationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $validationType
     * @return \patest\StructType\BizAction_Crm_ValidateMultipleContactDetails_Request
     */
    public function setValidationType($validationType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ValidationType::valueIsValid($validationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ValidationType', is_array($validationType) ? implode(', ', $validationType) : var_export($validationType, true), implode(', ', \patest\EnumType\ValidationType::getValidValues())), __LINE__);
        }
        if (is_null($validationType) || (is_array($validationType) && empty($validationType))) {
            unset($this->ValidationType);
        } else {
            $this->ValidationType = $validationType;
        }
        return $this;
    }
}
