<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Crm.MassEnrollToTicketScheme.Request StructType
 * @subpackage Structs
 */
class BizAction_Crm_MassEnrollToTicketScheme_Request extends AnyEntity
{
    /**
     * The AllowOperation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AllowOperation;
    /**
     * The ClientTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ClientTypes
     */
    public $ClientTypes;
    /**
     * The SelectedPopulation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SelectedPopulation;
    /**
     * The Series
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Series
     */
    public $Series;
    /**
     * The TestInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TestInfo;
    /**
     * The TestOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $TestOnly;
    /**
     * The TicketSchemeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TicketSchemeId;
    /**
     * Constructor method for BizAction.Crm.MassEnrollToTicketScheme.Request
     * @uses BizAction_Crm_MassEnrollToTicketScheme_Request::setAllowOperation()
     * @uses BizAction_Crm_MassEnrollToTicketScheme_Request::setClientTypes()
     * @uses BizAction_Crm_MassEnrollToTicketScheme_Request::setSelectedPopulation()
     * @uses BizAction_Crm_MassEnrollToTicketScheme_Request::setSeries()
     * @uses BizAction_Crm_MassEnrollToTicketScheme_Request::setTestInfo()
     * @uses BizAction_Crm_MassEnrollToTicketScheme_Request::setTestOnly()
     * @uses BizAction_Crm_MassEnrollToTicketScheme_Request::setTicketSchemeId()
     * @param bool $allowOperation
     * @param \patest\StructType\ClientTypes $clientTypes
     * @param int $selectedPopulation
     * @param \patest\StructType\Series $series
     * @param string $testInfo
     * @param bool $testOnly
     * @param string $ticketSchemeId
     */
    public function __construct($allowOperation = null, \patest\StructType\ClientTypes $clientTypes = null, $selectedPopulation = null, \patest\StructType\Series $series = null, $testInfo = null, $testOnly = null, $ticketSchemeId = null)
    {
        $this
            ->setAllowOperation($allowOperation)
            ->setClientTypes($clientTypes)
            ->setSelectedPopulation($selectedPopulation)
            ->setSeries($series)
            ->setTestInfo($testInfo)
            ->setTestOnly($testOnly)
            ->setTicketSchemeId($ticketSchemeId);
    }
    /**
     * Get AllowOperation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAllowOperation()
    {
        return isset($this->AllowOperation) ? $this->AllowOperation : null;
    }
    /**
     * Set AllowOperation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $allowOperation
     * @return \patest\StructType\BizAction_Crm_MassEnrollToTicketScheme_Request
     */
    public function setAllowOperation($allowOperation = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowOperation) && !is_bool($allowOperation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowOperation, true), gettype($allowOperation)), __LINE__);
        }
        if (is_null($allowOperation) || (is_array($allowOperation) && empty($allowOperation))) {
            unset($this->AllowOperation);
        } else {
            $this->AllowOperation = $allowOperation;
        }
        return $this;
    }
    /**
     * Get ClientTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ClientTypes|null
     */
    public function getClientTypes()
    {
        return isset($this->ClientTypes) ? $this->ClientTypes : null;
    }
    /**
     * Set ClientTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ClientTypes $clientTypes
     * @return \patest\StructType\BizAction_Crm_MassEnrollToTicketScheme_Request
     */
    public function setClientTypes(\patest\StructType\ClientTypes $clientTypes = null)
    {
        if (is_null($clientTypes) || (is_array($clientTypes) && empty($clientTypes))) {
            unset($this->ClientTypes);
        } else {
            $this->ClientTypes = $clientTypes;
        }
        return $this;
    }
    /**
     * Get SelectedPopulation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSelectedPopulation()
    {
        return isset($this->SelectedPopulation) ? $this->SelectedPopulation : null;
    }
    /**
     * Set SelectedPopulation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $selectedPopulation
     * @return \patest\StructType\BizAction_Crm_MassEnrollToTicketScheme_Request
     */
    public function setSelectedPopulation($selectedPopulation = null)
    {
        // validation for constraint: int
        if (!is_null($selectedPopulation) && !(is_int($selectedPopulation) || ctype_digit($selectedPopulation))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($selectedPopulation, true), gettype($selectedPopulation)), __LINE__);
        }
        if (is_null($selectedPopulation) || (is_array($selectedPopulation) && empty($selectedPopulation))) {
            unset($this->SelectedPopulation);
        } else {
            $this->SelectedPopulation = $selectedPopulation;
        }
        return $this;
    }
    /**
     * Get Series value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Series|null
     */
    public function getSeries()
    {
        return isset($this->Series) ? $this->Series : null;
    }
    /**
     * Set Series value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Series $series
     * @return \patest\StructType\BizAction_Crm_MassEnrollToTicketScheme_Request
     */
    public function setSeries(\patest\StructType\Series $series = null)
    {
        if (is_null($series) || (is_array($series) && empty($series))) {
            unset($this->Series);
        } else {
            $this->Series = $series;
        }
        return $this;
    }
    /**
     * Get TestInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTestInfo()
    {
        return isset($this->TestInfo) ? $this->TestInfo : null;
    }
    /**
     * Set TestInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $testInfo
     * @return \patest\StructType\BizAction_Crm_MassEnrollToTicketScheme_Request
     */
    public function setTestInfo($testInfo = null)
    {
        // validation for constraint: string
        if (!is_null($testInfo) && !is_string($testInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($testInfo, true), gettype($testInfo)), __LINE__);
        }
        if (is_null($testInfo) || (is_array($testInfo) && empty($testInfo))) {
            unset($this->TestInfo);
        } else {
            $this->TestInfo = $testInfo;
        }
        return $this;
    }
    /**
     * Get TestOnly value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getTestOnly()
    {
        return isset($this->TestOnly) ? $this->TestOnly : null;
    }
    /**
     * Set TestOnly value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $testOnly
     * @return \patest\StructType\BizAction_Crm_MassEnrollToTicketScheme_Request
     */
    public function setTestOnly($testOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($testOnly) && !is_bool($testOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($testOnly, true), gettype($testOnly)), __LINE__);
        }
        if (is_null($testOnly) || (is_array($testOnly) && empty($testOnly))) {
            unset($this->TestOnly);
        } else {
            $this->TestOnly = $testOnly;
        }
        return $this;
    }
    /**
     * Get TicketSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketSchemeId()
    {
        return isset($this->TicketSchemeId) ? $this->TicketSchemeId : null;
    }
    /**
     * Set TicketSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketSchemeId
     * @return \patest\StructType\BizAction_Crm_MassEnrollToTicketScheme_Request
     */
    public function setTicketSchemeId($ticketSchemeId = null)
    {
        // validation for constraint: string
        if (!is_null($ticketSchemeId) && !is_string($ticketSchemeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketSchemeId, true), gettype($ticketSchemeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ticketSchemeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ticketSchemeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ticketSchemeId, true)), __LINE__);
        }
        if (is_null($ticketSchemeId) || (is_array($ticketSchemeId) && empty($ticketSchemeId))) {
            unset($this->TicketSchemeId);
        } else {
            $this->TicketSchemeId = $ticketSchemeId;
        }
        return $this;
    }
}
