<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Crm.LinkPaymentToTicketScheme.Request StructType
 * @subpackage Structs
 */
class BizAction_Crm_LinkPaymentToTicketScheme_Request extends AnyEntity
{
    /**
     * The AllowOperation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AllowOperation;
    /**
     * The ClientTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ClientTypes
     */
    public $ClientTypes;
    /**
     * The OverWrite
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OverWrite;
    /**
     * The PaymentMethodIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PaymentMethodIds
     */
    public $PaymentMethodIds;
    /**
     * The PaymentMethodToUseMsg
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethodToUseMsg;
    /**
     * The PaymentMethodType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethodType;
    /**
     * The PaymentTokensInEnrollMsg
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentTokensInEnrollMsg;
    /**
     * The SelectedPopulation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SelectedPopulation;
    /**
     * The SelectedPopulationMsg
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SelectedPopulationMsg;
    /**
     * The Series
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Series
     */
    public $Series;
    /**
     * The TestInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TestInfo;
    /**
     * The TestOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $TestOnly;
    /**
     * The TicketSchemeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TicketSchemeId;
    /**
     * The UseSeasonCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UseSeasonCard;
    /**
     * Constructor method for BizAction.Crm.LinkPaymentToTicketScheme.Request
     * @uses BizAction_Crm_LinkPaymentToTicketScheme_Request::setAllowOperation()
     * @uses BizAction_Crm_LinkPaymentToTicketScheme_Request::setClientTypes()
     * @uses BizAction_Crm_LinkPaymentToTicketScheme_Request::setOverWrite()
     * @uses BizAction_Crm_LinkPaymentToTicketScheme_Request::setPaymentMethodIds()
     * @uses BizAction_Crm_LinkPaymentToTicketScheme_Request::setPaymentMethodToUseMsg()
     * @uses BizAction_Crm_LinkPaymentToTicketScheme_Request::setPaymentMethodType()
     * @uses BizAction_Crm_LinkPaymentToTicketScheme_Request::setPaymentTokensInEnrollMsg()
     * @uses BizAction_Crm_LinkPaymentToTicketScheme_Request::setSelectedPopulation()
     * @uses BizAction_Crm_LinkPaymentToTicketScheme_Request::setSelectedPopulationMsg()
     * @uses BizAction_Crm_LinkPaymentToTicketScheme_Request::setSeries()
     * @uses BizAction_Crm_LinkPaymentToTicketScheme_Request::setTestInfo()
     * @uses BizAction_Crm_LinkPaymentToTicketScheme_Request::setTestOnly()
     * @uses BizAction_Crm_LinkPaymentToTicketScheme_Request::setTicketSchemeId()
     * @uses BizAction_Crm_LinkPaymentToTicketScheme_Request::setUseSeasonCard()
     * @param bool $allowOperation
     * @param \patest\StructType\ClientTypes $clientTypes
     * @param bool $overWrite
     * @param \patest\StructType\PaymentMethodIds $paymentMethodIds
     * @param string $paymentMethodToUseMsg
     * @param string $paymentMethodType
     * @param string $paymentTokensInEnrollMsg
     * @param int $selectedPopulation
     * @param string $selectedPopulationMsg
     * @param \patest\StructType\Series $series
     * @param string $testInfo
     * @param bool $testOnly
     * @param string $ticketSchemeId
     * @param bool $useSeasonCard
     */
    public function __construct($allowOperation = null, \patest\StructType\ClientTypes $clientTypes = null, $overWrite = null, \patest\StructType\PaymentMethodIds $paymentMethodIds = null, $paymentMethodToUseMsg = null, $paymentMethodType = null, $paymentTokensInEnrollMsg = null, $selectedPopulation = null, $selectedPopulationMsg = null, \patest\StructType\Series $series = null, $testInfo = null, $testOnly = null, $ticketSchemeId = null, $useSeasonCard = null)
    {
        $this
            ->setAllowOperation($allowOperation)
            ->setClientTypes($clientTypes)
            ->setOverWrite($overWrite)
            ->setPaymentMethodIds($paymentMethodIds)
            ->setPaymentMethodToUseMsg($paymentMethodToUseMsg)
            ->setPaymentMethodType($paymentMethodType)
            ->setPaymentTokensInEnrollMsg($paymentTokensInEnrollMsg)
            ->setSelectedPopulation($selectedPopulation)
            ->setSelectedPopulationMsg($selectedPopulationMsg)
            ->setSeries($series)
            ->setTestInfo($testInfo)
            ->setTestOnly($testOnly)
            ->setTicketSchemeId($ticketSchemeId)
            ->setUseSeasonCard($useSeasonCard);
    }
    /**
     * Get AllowOperation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAllowOperation()
    {
        return isset($this->AllowOperation) ? $this->AllowOperation : null;
    }
    /**
     * Set AllowOperation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $allowOperation
     * @return \patest\StructType\BizAction_Crm_LinkPaymentToTicketScheme_Request
     */
    public function setAllowOperation($allowOperation = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowOperation) && !is_bool($allowOperation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowOperation, true), gettype($allowOperation)), __LINE__);
        }
        if (is_null($allowOperation) || (is_array($allowOperation) && empty($allowOperation))) {
            unset($this->AllowOperation);
        } else {
            $this->AllowOperation = $allowOperation;
        }
        return $this;
    }
    /**
     * Get ClientTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ClientTypes|null
     */
    public function getClientTypes()
    {
        return isset($this->ClientTypes) ? $this->ClientTypes : null;
    }
    /**
     * Set ClientTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ClientTypes $clientTypes
     * @return \patest\StructType\BizAction_Crm_LinkPaymentToTicketScheme_Request
     */
    public function setClientTypes(\patest\StructType\ClientTypes $clientTypes = null)
    {
        if (is_null($clientTypes) || (is_array($clientTypes) && empty($clientTypes))) {
            unset($this->ClientTypes);
        } else {
            $this->ClientTypes = $clientTypes;
        }
        return $this;
    }
    /**
     * Get OverWrite value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOverWrite()
    {
        return isset($this->OverWrite) ? $this->OverWrite : null;
    }
    /**
     * Set OverWrite value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $overWrite
     * @return \patest\StructType\BizAction_Crm_LinkPaymentToTicketScheme_Request
     */
    public function setOverWrite($overWrite = null)
    {
        // validation for constraint: boolean
        if (!is_null($overWrite) && !is_bool($overWrite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($overWrite, true), gettype($overWrite)), __LINE__);
        }
        if (is_null($overWrite) || (is_array($overWrite) && empty($overWrite))) {
            unset($this->OverWrite);
        } else {
            $this->OverWrite = $overWrite;
        }
        return $this;
    }
    /**
     * Get PaymentMethodIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PaymentMethodIds|null
     */
    public function getPaymentMethodIds()
    {
        return isset($this->PaymentMethodIds) ? $this->PaymentMethodIds : null;
    }
    /**
     * Set PaymentMethodIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\PaymentMethodIds $paymentMethodIds
     * @return \patest\StructType\BizAction_Crm_LinkPaymentToTicketScheme_Request
     */
    public function setPaymentMethodIds(\patest\StructType\PaymentMethodIds $paymentMethodIds = null)
    {
        if (is_null($paymentMethodIds) || (is_array($paymentMethodIds) && empty($paymentMethodIds))) {
            unset($this->PaymentMethodIds);
        } else {
            $this->PaymentMethodIds = $paymentMethodIds;
        }
        return $this;
    }
    /**
     * Get PaymentMethodToUseMsg value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodToUseMsg()
    {
        return isset($this->PaymentMethodToUseMsg) ? $this->PaymentMethodToUseMsg : null;
    }
    /**
     * Set PaymentMethodToUseMsg value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodToUseMsg
     * @return \patest\StructType\BizAction_Crm_LinkPaymentToTicketScheme_Request
     */
    public function setPaymentMethodToUseMsg($paymentMethodToUseMsg = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodToUseMsg) && !is_string($paymentMethodToUseMsg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodToUseMsg, true), gettype($paymentMethodToUseMsg)), __LINE__);
        }
        if (is_null($paymentMethodToUseMsg) || (is_array($paymentMethodToUseMsg) && empty($paymentMethodToUseMsg))) {
            unset($this->PaymentMethodToUseMsg);
        } else {
            $this->PaymentMethodToUseMsg = $paymentMethodToUseMsg;
        }
        return $this;
    }
    /**
     * Get PaymentMethodType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodType()
    {
        return isset($this->PaymentMethodType) ? $this->PaymentMethodType : null;
    }
    /**
     * Set PaymentMethodType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PaymentMethodType::valueIsValid()
     * @uses \patest\EnumType\PaymentMethodType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentMethodType
     * @return \patest\StructType\BizAction_Crm_LinkPaymentToTicketScheme_Request
     */
    public function setPaymentMethodType($paymentMethodType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentMethodType::valueIsValid($paymentMethodType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentMethodType', is_array($paymentMethodType) ? implode(', ', $paymentMethodType) : var_export($paymentMethodType, true), implode(', ', \patest\EnumType\PaymentMethodType::getValidValues())), __LINE__);
        }
        if (is_null($paymentMethodType) || (is_array($paymentMethodType) && empty($paymentMethodType))) {
            unset($this->PaymentMethodType);
        } else {
            $this->PaymentMethodType = $paymentMethodType;
        }
        return $this;
    }
    /**
     * Get PaymentTokensInEnrollMsg value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentTokensInEnrollMsg()
    {
        return isset($this->PaymentTokensInEnrollMsg) ? $this->PaymentTokensInEnrollMsg : null;
    }
    /**
     * Set PaymentTokensInEnrollMsg value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentTokensInEnrollMsg
     * @return \patest\StructType\BizAction_Crm_LinkPaymentToTicketScheme_Request
     */
    public function setPaymentTokensInEnrollMsg($paymentTokensInEnrollMsg = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTokensInEnrollMsg) && !is_string($paymentTokensInEnrollMsg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentTokensInEnrollMsg, true), gettype($paymentTokensInEnrollMsg)), __LINE__);
        }
        if (is_null($paymentTokensInEnrollMsg) || (is_array($paymentTokensInEnrollMsg) && empty($paymentTokensInEnrollMsg))) {
            unset($this->PaymentTokensInEnrollMsg);
        } else {
            $this->PaymentTokensInEnrollMsg = $paymentTokensInEnrollMsg;
        }
        return $this;
    }
    /**
     * Get SelectedPopulation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSelectedPopulation()
    {
        return isset($this->SelectedPopulation) ? $this->SelectedPopulation : null;
    }
    /**
     * Set SelectedPopulation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $selectedPopulation
     * @return \patest\StructType\BizAction_Crm_LinkPaymentToTicketScheme_Request
     */
    public function setSelectedPopulation($selectedPopulation = null)
    {
        // validation for constraint: int
        if (!is_null($selectedPopulation) && !(is_int($selectedPopulation) || ctype_digit($selectedPopulation))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($selectedPopulation, true), gettype($selectedPopulation)), __LINE__);
        }
        if (is_null($selectedPopulation) || (is_array($selectedPopulation) && empty($selectedPopulation))) {
            unset($this->SelectedPopulation);
        } else {
            $this->SelectedPopulation = $selectedPopulation;
        }
        return $this;
    }
    /**
     * Get SelectedPopulationMsg value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSelectedPopulationMsg()
    {
        return isset($this->SelectedPopulationMsg) ? $this->SelectedPopulationMsg : null;
    }
    /**
     * Set SelectedPopulationMsg value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $selectedPopulationMsg
     * @return \patest\StructType\BizAction_Crm_LinkPaymentToTicketScheme_Request
     */
    public function setSelectedPopulationMsg($selectedPopulationMsg = null)
    {
        // validation for constraint: string
        if (!is_null($selectedPopulationMsg) && !is_string($selectedPopulationMsg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($selectedPopulationMsg, true), gettype($selectedPopulationMsg)), __LINE__);
        }
        if (is_null($selectedPopulationMsg) || (is_array($selectedPopulationMsg) && empty($selectedPopulationMsg))) {
            unset($this->SelectedPopulationMsg);
        } else {
            $this->SelectedPopulationMsg = $selectedPopulationMsg;
        }
        return $this;
    }
    /**
     * Get Series value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Series|null
     */
    public function getSeries()
    {
        return isset($this->Series) ? $this->Series : null;
    }
    /**
     * Set Series value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Series $series
     * @return \patest\StructType\BizAction_Crm_LinkPaymentToTicketScheme_Request
     */
    public function setSeries(\patest\StructType\Series $series = null)
    {
        if (is_null($series) || (is_array($series) && empty($series))) {
            unset($this->Series);
        } else {
            $this->Series = $series;
        }
        return $this;
    }
    /**
     * Get TestInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTestInfo()
    {
        return isset($this->TestInfo) ? $this->TestInfo : null;
    }
    /**
     * Set TestInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $testInfo
     * @return \patest\StructType\BizAction_Crm_LinkPaymentToTicketScheme_Request
     */
    public function setTestInfo($testInfo = null)
    {
        // validation for constraint: string
        if (!is_null($testInfo) && !is_string($testInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($testInfo, true), gettype($testInfo)), __LINE__);
        }
        if (is_null($testInfo) || (is_array($testInfo) && empty($testInfo))) {
            unset($this->TestInfo);
        } else {
            $this->TestInfo = $testInfo;
        }
        return $this;
    }
    /**
     * Get TestOnly value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getTestOnly()
    {
        return isset($this->TestOnly) ? $this->TestOnly : null;
    }
    /**
     * Set TestOnly value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $testOnly
     * @return \patest\StructType\BizAction_Crm_LinkPaymentToTicketScheme_Request
     */
    public function setTestOnly($testOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($testOnly) && !is_bool($testOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($testOnly, true), gettype($testOnly)), __LINE__);
        }
        if (is_null($testOnly) || (is_array($testOnly) && empty($testOnly))) {
            unset($this->TestOnly);
        } else {
            $this->TestOnly = $testOnly;
        }
        return $this;
    }
    /**
     * Get TicketSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketSchemeId()
    {
        return isset($this->TicketSchemeId) ? $this->TicketSchemeId : null;
    }
    /**
     * Set TicketSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketSchemeId
     * @return \patest\StructType\BizAction_Crm_LinkPaymentToTicketScheme_Request
     */
    public function setTicketSchemeId($ticketSchemeId = null)
    {
        // validation for constraint: string
        if (!is_null($ticketSchemeId) && !is_string($ticketSchemeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketSchemeId, true), gettype($ticketSchemeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ticketSchemeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ticketSchemeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ticketSchemeId, true)), __LINE__);
        }
        if (is_null($ticketSchemeId) || (is_array($ticketSchemeId) && empty($ticketSchemeId))) {
            unset($this->TicketSchemeId);
        } else {
            $this->TicketSchemeId = $ticketSchemeId;
        }
        return $this;
    }
    /**
     * Get UseSeasonCard value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUseSeasonCard()
    {
        return isset($this->UseSeasonCard) ? $this->UseSeasonCard : null;
    }
    /**
     * Set UseSeasonCard value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $useSeasonCard
     * @return \patest\StructType\BizAction_Crm_LinkPaymentToTicketScheme_Request
     */
    public function setUseSeasonCard($useSeasonCard = null)
    {
        // validation for constraint: boolean
        if (!is_null($useSeasonCard) && !is_bool($useSeasonCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useSeasonCard, true), gettype($useSeasonCard)), __LINE__);
        }
        if (is_null($useSeasonCard) || (is_array($useSeasonCard) && empty($useSeasonCard))) {
            unset($this->UseSeasonCard);
        } else {
            $this->UseSeasonCard = $useSeasonCard;
        }
        return $this;
    }
}
