<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Crm.ImportCustomers.Request StructType
 * @subpackage Structs
 */
class BizAction_Crm_ImportCustomers_Request extends AnyEntity
{
    /**
     * The CustomerIdentifierField
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CustomerIdentifierField;
    /**
     * The CustomerMapping
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfCrm_CustomerExternalManipulations_ColumnMapping
     */
    public $CustomerMapping;
    /**
     * The DateTimeFormat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DateTimeFormat;
    /**
     * The Notes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Notes;
    /**
     * The UploadedDataId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UploadedDataId;
    /**
     * Constructor method for BizAction.Crm.ImportCustomers.Request
     * @uses BizAction_Crm_ImportCustomers_Request::setCustomerIdentifierField()
     * @uses BizAction_Crm_ImportCustomers_Request::setCustomerMapping()
     * @uses BizAction_Crm_ImportCustomers_Request::setDateTimeFormat()
     * @uses BizAction_Crm_ImportCustomers_Request::setNotes()
     * @uses BizAction_Crm_ImportCustomers_Request::setUploadedDataId()
     * @param string $customerIdentifierField
     * @param \patest\StructType\RecordSetOfCrm_CustomerExternalManipulations_ColumnMapping $customerMapping
     * @param string $dateTimeFormat
     * @param string $notes
     * @param string $uploadedDataId
     */
    public function __construct($customerIdentifierField = null, \patest\StructType\RecordSetOfCrm_CustomerExternalManipulations_ColumnMapping $customerMapping = null, $dateTimeFormat = null, $notes = null, $uploadedDataId = null)
    {
        $this
            ->setCustomerIdentifierField($customerIdentifierField)
            ->setCustomerMapping($customerMapping)
            ->setDateTimeFormat($dateTimeFormat)
            ->setNotes($notes)
            ->setUploadedDataId($uploadedDataId);
    }
    /**
     * Get CustomerIdentifierField value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomerIdentifierField()
    {
        return isset($this->CustomerIdentifierField) ? $this->CustomerIdentifierField : null;
    }
    /**
     * Set CustomerIdentifierField value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\CustomerIdentifierFieldForBatch::valueIsValid()
     * @uses \patest\EnumType\CustomerIdentifierFieldForBatch::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $customerIdentifierField
     * @return \patest\StructType\BizAction_Crm_ImportCustomers_Request
     */
    public function setCustomerIdentifierField($customerIdentifierField = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\CustomerIdentifierFieldForBatch::valueIsValid($customerIdentifierField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\CustomerIdentifierFieldForBatch', is_array($customerIdentifierField) ? implode(', ', $customerIdentifierField) : var_export($customerIdentifierField, true), implode(', ', \patest\EnumType\CustomerIdentifierFieldForBatch::getValidValues())), __LINE__);
        }
        if (is_null($customerIdentifierField) || (is_array($customerIdentifierField) && empty($customerIdentifierField))) {
            unset($this->CustomerIdentifierField);
        } else {
            $this->CustomerIdentifierField = $customerIdentifierField;
        }
        return $this;
    }
    /**
     * Get CustomerMapping value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfCrm_CustomerExternalManipulations_ColumnMapping|null
     */
    public function getCustomerMapping()
    {
        return isset($this->CustomerMapping) ? $this->CustomerMapping : null;
    }
    /**
     * Set CustomerMapping value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfCrm_CustomerExternalManipulations_ColumnMapping $customerMapping
     * @return \patest\StructType\BizAction_Crm_ImportCustomers_Request
     */
    public function setCustomerMapping(\patest\StructType\RecordSetOfCrm_CustomerExternalManipulations_ColumnMapping $customerMapping = null)
    {
        if (is_null($customerMapping) || (is_array($customerMapping) && empty($customerMapping))) {
            unset($this->CustomerMapping);
        } else {
            $this->CustomerMapping = $customerMapping;
        }
        return $this;
    }
    /**
     * Get DateTimeFormat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateTimeFormat()
    {
        return isset($this->DateTimeFormat) ? $this->DateTimeFormat : null;
    }
    /**
     * Set DateTimeFormat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateTimeFormat
     * @return \patest\StructType\BizAction_Crm_ImportCustomers_Request
     */
    public function setDateTimeFormat($dateTimeFormat = null)
    {
        // validation for constraint: string
        if (!is_null($dateTimeFormat) && !is_string($dateTimeFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTimeFormat, true), gettype($dateTimeFormat)), __LINE__);
        }
        if (is_null($dateTimeFormat) || (is_array($dateTimeFormat) && empty($dateTimeFormat))) {
            unset($this->DateTimeFormat);
        } else {
            $this->DateTimeFormat = $dateTimeFormat;
        }
        return $this;
    }
    /**
     * Get Notes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotes()
    {
        return isset($this->Notes) ? $this->Notes : null;
    }
    /**
     * Set Notes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notes
     * @return \patest\StructType\BizAction_Crm_ImportCustomers_Request
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notes, true), gettype($notes)), __LINE__);
        }
        if (is_null($notes) || (is_array($notes) && empty($notes))) {
            unset($this->Notes);
        } else {
            $this->Notes = $notes;
        }
        return $this;
    }
    /**
     * Get UploadedDataId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUploadedDataId()
    {
        return isset($this->UploadedDataId) ? $this->UploadedDataId : null;
    }
    /**
     * Set UploadedDataId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uploadedDataId
     * @return \patest\StructType\BizAction_Crm_ImportCustomers_Request
     */
    public function setUploadedDataId($uploadedDataId = null)
    {
        // validation for constraint: string
        if (!is_null($uploadedDataId) && !is_string($uploadedDataId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uploadedDataId, true), gettype($uploadedDataId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($uploadedDataId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $uploadedDataId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($uploadedDataId, true)), __LINE__);
        }
        if (is_null($uploadedDataId) || (is_array($uploadedDataId) && empty($uploadedDataId))) {
            unset($this->UploadedDataId);
        } else {
            $this->UploadedDataId = $uploadedDataId;
        }
        return $this;
    }
}
