<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Crm.ImportCustomersResults.Request StructType
 * @subpackage Structs
 */
class BizAction_Crm_ImportCustomersResults_Request extends AnyEntity
{
    /**
     * The ImportCustomersErrorsLogId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ImportCustomersErrorsLogId;
    /**
     * The IsDownloadResults
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDownloadResults;
    /**
     * The NotSuccessResults
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NotSuccessResults;
    /**
     * The SuccessResults
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SuccessResults;
    /**
     * Constructor method for BizAction.Crm.ImportCustomersResults.Request
     * @uses BizAction_Crm_ImportCustomersResults_Request::setImportCustomersErrorsLogId()
     * @uses BizAction_Crm_ImportCustomersResults_Request::setIsDownloadResults()
     * @uses BizAction_Crm_ImportCustomersResults_Request::setNotSuccessResults()
     * @uses BizAction_Crm_ImportCustomersResults_Request::setSuccessResults()
     * @param string $importCustomersErrorsLogId
     * @param bool $isDownloadResults
     * @param int $notSuccessResults
     * @param int $successResults
     */
    public function __construct($importCustomersErrorsLogId = null, $isDownloadResults = null, $notSuccessResults = null, $successResults = null)
    {
        $this
            ->setImportCustomersErrorsLogId($importCustomersErrorsLogId)
            ->setIsDownloadResults($isDownloadResults)
            ->setNotSuccessResults($notSuccessResults)
            ->setSuccessResults($successResults);
    }
    /**
     * Get ImportCustomersErrorsLogId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImportCustomersErrorsLogId()
    {
        return isset($this->ImportCustomersErrorsLogId) ? $this->ImportCustomersErrorsLogId : null;
    }
    /**
     * Set ImportCustomersErrorsLogId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $importCustomersErrorsLogId
     * @return \patest\StructType\BizAction_Crm_ImportCustomersResults_Request
     */
    public function setImportCustomersErrorsLogId($importCustomersErrorsLogId = null)
    {
        // validation for constraint: string
        if (!is_null($importCustomersErrorsLogId) && !is_string($importCustomersErrorsLogId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($importCustomersErrorsLogId, true), gettype($importCustomersErrorsLogId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($importCustomersErrorsLogId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $importCustomersErrorsLogId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($importCustomersErrorsLogId, true)), __LINE__);
        }
        if (is_null($importCustomersErrorsLogId) || (is_array($importCustomersErrorsLogId) && empty($importCustomersErrorsLogId))) {
            unset($this->ImportCustomersErrorsLogId);
        } else {
            $this->ImportCustomersErrorsLogId = $importCustomersErrorsLogId;
        }
        return $this;
    }
    /**
     * Get IsDownloadResults value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDownloadResults()
    {
        return isset($this->IsDownloadResults) ? $this->IsDownloadResults : null;
    }
    /**
     * Set IsDownloadResults value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDownloadResults
     * @return \patest\StructType\BizAction_Crm_ImportCustomersResults_Request
     */
    public function setIsDownloadResults($isDownloadResults = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDownloadResults) && !is_bool($isDownloadResults)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDownloadResults, true), gettype($isDownloadResults)), __LINE__);
        }
        if (is_null($isDownloadResults) || (is_array($isDownloadResults) && empty($isDownloadResults))) {
            unset($this->IsDownloadResults);
        } else {
            $this->IsDownloadResults = $isDownloadResults;
        }
        return $this;
    }
    /**
     * Get NotSuccessResults value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNotSuccessResults()
    {
        return isset($this->NotSuccessResults) ? $this->NotSuccessResults : null;
    }
    /**
     * Set NotSuccessResults value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $notSuccessResults
     * @return \patest\StructType\BizAction_Crm_ImportCustomersResults_Request
     */
    public function setNotSuccessResults($notSuccessResults = null)
    {
        // validation for constraint: int
        if (!is_null($notSuccessResults) && !(is_int($notSuccessResults) || ctype_digit($notSuccessResults))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($notSuccessResults, true), gettype($notSuccessResults)), __LINE__);
        }
        if (is_null($notSuccessResults) || (is_array($notSuccessResults) && empty($notSuccessResults))) {
            unset($this->NotSuccessResults);
        } else {
            $this->NotSuccessResults = $notSuccessResults;
        }
        return $this;
    }
    /**
     * Get SuccessResults value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSuccessResults()
    {
        return isset($this->SuccessResults) ? $this->SuccessResults : null;
    }
    /**
     * Set SuccessResults value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $successResults
     * @return \patest\StructType\BizAction_Crm_ImportCustomersResults_Request
     */
    public function setSuccessResults($successResults = null)
    {
        // validation for constraint: int
        if (!is_null($successResults) && !(is_int($successResults) || ctype_digit($successResults))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($successResults, true), gettype($successResults)), __LINE__);
        }
        if (is_null($successResults) || (is_array($successResults) && empty($successResults))) {
            unset($this->SuccessResults);
        } else {
            $this->SuccessResults = $successResults;
        }
        return $this;
    }
}
