<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Crm.AssignedClientsManipulations.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Crm_AssignedClientsManipulations_Request extends AnyEntity
{
    /**
     * The AssociatedClients
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfCrm_AssociatedClientToSalesRep
     */
    public $AssociatedClients;
    /**
     * The SalesRepCustomerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SalesRepCustomerId;
    /**
     * The SalesRepId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SalesRepId;
    /**
     * The SearchCriteria
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SearchCriteria;
    /**
     * Constructor method for BizAction.Crm.AssignedClientsManipulations.Request
     * @uses BizAction_Crm_AssignedClientsManipulations_Request::setAssociatedClients()
     * @uses BizAction_Crm_AssignedClientsManipulations_Request::setSalesRepCustomerId()
     * @uses BizAction_Crm_AssignedClientsManipulations_Request::setSalesRepId()
     * @uses BizAction_Crm_AssignedClientsManipulations_Request::setSearchCriteria()
     * @param \patest\StructType\RecordSetOfCrm_AssociatedClientToSalesRep $associatedClients
     * @param string $salesRepCustomerId
     * @param string $salesRepId
     * @param string $searchCriteria
     */
    public function __construct(\patest\StructType\RecordSetOfCrm_AssociatedClientToSalesRep $associatedClients = null, $salesRepCustomerId = null, $salesRepId = null, $searchCriteria = null)
    {
        $this
            ->setAssociatedClients($associatedClients)
            ->setSalesRepCustomerId($salesRepCustomerId)
            ->setSalesRepId($salesRepId)
            ->setSearchCriteria($searchCriteria);
    }
    /**
     * Get AssociatedClients value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfCrm_AssociatedClientToSalesRep|null
     */
    public function getAssociatedClients()
    {
        return isset($this->AssociatedClients) ? $this->AssociatedClients : null;
    }
    /**
     * Set AssociatedClients value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfCrm_AssociatedClientToSalesRep $associatedClients
     * @return \patest\StructType\BizAction_Crm_AssignedClientsManipulations_Request
     */
    public function setAssociatedClients(\patest\StructType\RecordSetOfCrm_AssociatedClientToSalesRep $associatedClients = null)
    {
        if (is_null($associatedClients) || (is_array($associatedClients) && empty($associatedClients))) {
            unset($this->AssociatedClients);
        } else {
            $this->AssociatedClients = $associatedClients;
        }
        return $this;
    }
    /**
     * Get SalesRepCustomerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalesRepCustomerId()
    {
        return isset($this->SalesRepCustomerId) ? $this->SalesRepCustomerId : null;
    }
    /**
     * Set SalesRepCustomerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salesRepCustomerId
     * @return \patest\StructType\BizAction_Crm_AssignedClientsManipulations_Request
     */
    public function setSalesRepCustomerId($salesRepCustomerId = null)
    {
        // validation for constraint: string
        if (!is_null($salesRepCustomerId) && !is_string($salesRepCustomerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesRepCustomerId, true), gettype($salesRepCustomerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($salesRepCustomerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $salesRepCustomerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($salesRepCustomerId, true)), __LINE__);
        }
        if (is_null($salesRepCustomerId) || (is_array($salesRepCustomerId) && empty($salesRepCustomerId))) {
            unset($this->SalesRepCustomerId);
        } else {
            $this->SalesRepCustomerId = $salesRepCustomerId;
        }
        return $this;
    }
    /**
     * Get SalesRepId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalesRepId()
    {
        return isset($this->SalesRepId) ? $this->SalesRepId : null;
    }
    /**
     * Set SalesRepId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salesRepId
     * @return \patest\StructType\BizAction_Crm_AssignedClientsManipulations_Request
     */
    public function setSalesRepId($salesRepId = null)
    {
        // validation for constraint: string
        if (!is_null($salesRepId) && !is_string($salesRepId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesRepId, true), gettype($salesRepId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($salesRepId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $salesRepId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($salesRepId, true)), __LINE__);
        }
        if (is_null($salesRepId) || (is_array($salesRepId) && empty($salesRepId))) {
            unset($this->SalesRepId);
        } else {
            $this->SalesRepId = $salesRepId;
        }
        return $this;
    }
    /**
     * Get SearchCriteria value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSearchCriteria()
    {
        return isset($this->SearchCriteria) ? $this->SearchCriteria : null;
    }
    /**
     * Set SearchCriteria value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $searchCriteria
     * @return \patest\StructType\BizAction_Crm_AssignedClientsManipulations_Request
     */
    public function setSearchCriteria($searchCriteria = null)
    {
        // validation for constraint: string
        if (!is_null($searchCriteria) && !is_string($searchCriteria)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($searchCriteria, true), gettype($searchCriteria)), __LINE__);
        }
        if (is_null($searchCriteria) || (is_array($searchCriteria) && empty($searchCriteria))) {
            unset($this->SearchCriteria);
        } else {
            $this->SearchCriteria = $searchCriteria;
        }
        return $this;
    }
}
