<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Crm.AddSalesRepToClient.Request StructType
 * @subpackage Structs
 */
class BizAction_Crm_AddSalesRepToClient_Request extends AnyEntity
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The GoalAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $GoalAmount;
    /**
     * The GoalFromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GoalFromDate;
    /**
     * The Goals
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfCrm_SalesRepGoal
     */
    public $Goals;
    /**
     * The GoalToDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GoalToDate;
    /**
     * The IsNewGoal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsNewGoal;
    /**
     * The SalesRepCustomerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SalesRepCustomerId;
    /**
     * The SalesRepId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SalesRepId;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Type;
    /**
     * Constructor method for BizAction.Crm.AddSalesRepToClient.Request
     * @uses BizAction_Crm_AddSalesRepToClient_Request::setClientId()
     * @uses BizAction_Crm_AddSalesRepToClient_Request::setGoalAmount()
     * @uses BizAction_Crm_AddSalesRepToClient_Request::setGoalFromDate()
     * @uses BizAction_Crm_AddSalesRepToClient_Request::setGoals()
     * @uses BizAction_Crm_AddSalesRepToClient_Request::setGoalToDate()
     * @uses BizAction_Crm_AddSalesRepToClient_Request::setIsNewGoal()
     * @uses BizAction_Crm_AddSalesRepToClient_Request::setSalesRepCustomerId()
     * @uses BizAction_Crm_AddSalesRepToClient_Request::setSalesRepId()
     * @uses BizAction_Crm_AddSalesRepToClient_Request::setType()
     * @param string $clientId
     * @param \patest\StructType\Money $goalAmount
     * @param string $goalFromDate
     * @param \patest\StructType\RecordSetOfCrm_SalesRepGoal $goals
     * @param string $goalToDate
     * @param bool $isNewGoal
     * @param string $salesRepCustomerId
     * @param string $salesRepId
     * @param string $type
     */
    public function __construct($clientId = null, \patest\StructType\Money $goalAmount = null, $goalFromDate = null, \patest\StructType\RecordSetOfCrm_SalesRepGoal $goals = null, $goalToDate = null, $isNewGoal = null, $salesRepCustomerId = null, $salesRepId = null, $type = null)
    {
        $this
            ->setClientId($clientId)
            ->setGoalAmount($goalAmount)
            ->setGoalFromDate($goalFromDate)
            ->setGoals($goals)
            ->setGoalToDate($goalToDate)
            ->setIsNewGoal($isNewGoal)
            ->setSalesRepCustomerId($salesRepCustomerId)
            ->setSalesRepId($salesRepId)
            ->setType($type);
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\BizAction_Crm_AddSalesRepToClient_Request
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get GoalAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getGoalAmount()
    {
        return isset($this->GoalAmount) ? $this->GoalAmount : null;
    }
    /**
     * Set GoalAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $goalAmount
     * @return \patest\StructType\BizAction_Crm_AddSalesRepToClient_Request
     */
    public function setGoalAmount(\patest\StructType\Money $goalAmount = null)
    {
        if (is_null($goalAmount) || (is_array($goalAmount) && empty($goalAmount))) {
            unset($this->GoalAmount);
        } else {
            $this->GoalAmount = $goalAmount;
        }
        return $this;
    }
    /**
     * Get GoalFromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGoalFromDate()
    {
        return isset($this->GoalFromDate) ? $this->GoalFromDate : null;
    }
    /**
     * Set GoalFromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $goalFromDate
     * @return \patest\StructType\BizAction_Crm_AddSalesRepToClient_Request
     */
    public function setGoalFromDate($goalFromDate = null)
    {
        // validation for constraint: string
        if (!is_null($goalFromDate) && !is_string($goalFromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($goalFromDate, true), gettype($goalFromDate)), __LINE__);
        }
        if (is_null($goalFromDate) || (is_array($goalFromDate) && empty($goalFromDate))) {
            unset($this->GoalFromDate);
        } else {
            $this->GoalFromDate = $goalFromDate;
        }
        return $this;
    }
    /**
     * Get Goals value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfCrm_SalesRepGoal|null
     */
    public function getGoals()
    {
        return isset($this->Goals) ? $this->Goals : null;
    }
    /**
     * Set Goals value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfCrm_SalesRepGoal $goals
     * @return \patest\StructType\BizAction_Crm_AddSalesRepToClient_Request
     */
    public function setGoals(\patest\StructType\RecordSetOfCrm_SalesRepGoal $goals = null)
    {
        if (is_null($goals) || (is_array($goals) && empty($goals))) {
            unset($this->Goals);
        } else {
            $this->Goals = $goals;
        }
        return $this;
    }
    /**
     * Get GoalToDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGoalToDate()
    {
        return isset($this->GoalToDate) ? $this->GoalToDate : null;
    }
    /**
     * Set GoalToDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $goalToDate
     * @return \patest\StructType\BizAction_Crm_AddSalesRepToClient_Request
     */
    public function setGoalToDate($goalToDate = null)
    {
        // validation for constraint: string
        if (!is_null($goalToDate) && !is_string($goalToDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($goalToDate, true), gettype($goalToDate)), __LINE__);
        }
        if (is_null($goalToDate) || (is_array($goalToDate) && empty($goalToDate))) {
            unset($this->GoalToDate);
        } else {
            $this->GoalToDate = $goalToDate;
        }
        return $this;
    }
    /**
     * Get IsNewGoal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsNewGoal()
    {
        return isset($this->IsNewGoal) ? $this->IsNewGoal : null;
    }
    /**
     * Set IsNewGoal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isNewGoal
     * @return \patest\StructType\BizAction_Crm_AddSalesRepToClient_Request
     */
    public function setIsNewGoal($isNewGoal = null)
    {
        // validation for constraint: boolean
        if (!is_null($isNewGoal) && !is_bool($isNewGoal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isNewGoal, true), gettype($isNewGoal)), __LINE__);
        }
        if (is_null($isNewGoal) || (is_array($isNewGoal) && empty($isNewGoal))) {
            unset($this->IsNewGoal);
        } else {
            $this->IsNewGoal = $isNewGoal;
        }
        return $this;
    }
    /**
     * Get SalesRepCustomerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalesRepCustomerId()
    {
        return isset($this->SalesRepCustomerId) ? $this->SalesRepCustomerId : null;
    }
    /**
     * Set SalesRepCustomerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salesRepCustomerId
     * @return \patest\StructType\BizAction_Crm_AddSalesRepToClient_Request
     */
    public function setSalesRepCustomerId($salesRepCustomerId = null)
    {
        // validation for constraint: string
        if (!is_null($salesRepCustomerId) && !is_string($salesRepCustomerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesRepCustomerId, true), gettype($salesRepCustomerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($salesRepCustomerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $salesRepCustomerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($salesRepCustomerId, true)), __LINE__);
        }
        if (is_null($salesRepCustomerId) || (is_array($salesRepCustomerId) && empty($salesRepCustomerId))) {
            unset($this->SalesRepCustomerId);
        } else {
            $this->SalesRepCustomerId = $salesRepCustomerId;
        }
        return $this;
    }
    /**
     * Get SalesRepId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalesRepId()
    {
        return isset($this->SalesRepId) ? $this->SalesRepId : null;
    }
    /**
     * Set SalesRepId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salesRepId
     * @return \patest\StructType\BizAction_Crm_AddSalesRepToClient_Request
     */
    public function setSalesRepId($salesRepId = null)
    {
        // validation for constraint: string
        if (!is_null($salesRepId) && !is_string($salesRepId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesRepId, true), gettype($salesRepId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($salesRepId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $salesRepId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($salesRepId, true)), __LINE__);
        }
        if (is_null($salesRepId) || (is_array($salesRepId) && empty($salesRepId))) {
            unset($this->SalesRepId);
        } else {
            $this->SalesRepId = $salesRepId;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SalesRepType::valueIsValid()
     * @uses \patest\EnumType\SalesRepType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \patest\StructType\BizAction_Crm_AddSalesRepToClient_Request
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SalesRepType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SalesRepType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \patest\EnumType\SalesRepType::getValidValues())), __LINE__);
        }
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
}
