<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Crm.AddRelationshipMaxAllowedOverride.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Crm_AddRelationshipMaxAllowedOverride_Request extends AnyEntity
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The MaxAllowedOverrides
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfBizAction_Crm_RelationshipTypeMaxAllowedOverride
     */
    public $MaxAllowedOverrides;
    /**
     * Constructor method for BizAction.Crm.AddRelationshipMaxAllowedOverride.Request
     * @uses BizAction_Crm_AddRelationshipMaxAllowedOverride_Request::setClientId()
     * @uses BizAction_Crm_AddRelationshipMaxAllowedOverride_Request::setMaxAllowedOverrides()
     * @param string $clientId
     * @param \patest\StructType\RecordSetOfBizAction_Crm_RelationshipTypeMaxAllowedOverride $maxAllowedOverrides
     */
    public function __construct($clientId = null, \patest\StructType\RecordSetOfBizAction_Crm_RelationshipTypeMaxAllowedOverride $maxAllowedOverrides = null)
    {
        $this
            ->setClientId($clientId)
            ->setMaxAllowedOverrides($maxAllowedOverrides);
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\BizAction_Crm_AddRelationshipMaxAllowedOverride_Request
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get MaxAllowedOverrides value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfBizAction_Crm_RelationshipTypeMaxAllowedOverride|null
     */
    public function getMaxAllowedOverrides()
    {
        return isset($this->MaxAllowedOverrides) ? $this->MaxAllowedOverrides : null;
    }
    /**
     * Set MaxAllowedOverrides value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfBizAction_Crm_RelationshipTypeMaxAllowedOverride $maxAllowedOverrides
     * @return \patest\StructType\BizAction_Crm_AddRelationshipMaxAllowedOverride_Request
     */
    public function setMaxAllowedOverrides(\patest\StructType\RecordSetOfBizAction_Crm_RelationshipTypeMaxAllowedOverride $maxAllowedOverrides = null)
    {
        if (is_null($maxAllowedOverrides) || (is_array($maxAllowedOverrides) && empty($maxAllowedOverrides))) {
            unset($this->MaxAllowedOverrides);
        } else {
            $this->MaxAllowedOverrides = $maxAllowedOverrides;
        }
        return $this;
    }
}
