<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.BizResource.CopyVisit.Request StructType
 * @subpackage Structs
 */
class BizAction_BizResource_CopyVisit_Request extends AnyEntity
{
    /**
     * The Classes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Classes;
    /**
     * The GradeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GradeId;
    /**
     * The GroupName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GroupName;
    /**
     * The OrderType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrderType;
    /**
     * The PreferredEndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PreferredEndDate;
    /**
     * The PreferredStartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PreferredStartDate;
    /**
     * The SourceOrderVisitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SourceOrderVisitId;
    /**
     * Constructor method for BizAction.BizResource.CopyVisit.Request
     * @uses BizAction_BizResource_CopyVisit_Request::setClasses()
     * @uses BizAction_BizResource_CopyVisit_Request::setGradeId()
     * @uses BizAction_BizResource_CopyVisit_Request::setGroupName()
     * @uses BizAction_BizResource_CopyVisit_Request::setOrderType()
     * @uses BizAction_BizResource_CopyVisit_Request::setPreferredEndDate()
     * @uses BizAction_BizResource_CopyVisit_Request::setPreferredStartDate()
     * @uses BizAction_BizResource_CopyVisit_Request::setSourceOrderVisitId()
     * @param string $classes
     * @param string $gradeId
     * @param string $groupName
     * @param string $orderType
     * @param string $preferredEndDate
     * @param string $preferredStartDate
     * @param string $sourceOrderVisitId
     */
    public function __construct($classes = null, $gradeId = null, $groupName = null, $orderType = null, $preferredEndDate = null, $preferredStartDate = null, $sourceOrderVisitId = null)
    {
        $this
            ->setClasses($classes)
            ->setGradeId($gradeId)
            ->setGroupName($groupName)
            ->setOrderType($orderType)
            ->setPreferredEndDate($preferredEndDate)
            ->setPreferredStartDate($preferredStartDate)
            ->setSourceOrderVisitId($sourceOrderVisitId);
    }
    /**
     * Get Classes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClasses()
    {
        return isset($this->Classes) ? $this->Classes : null;
    }
    /**
     * Set Classes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $classes
     * @return \patest\StructType\BizAction_BizResource_CopyVisit_Request
     */
    public function setClasses($classes = null)
    {
        // validation for constraint: string
        if (!is_null($classes) && !is_string($classes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($classes, true), gettype($classes)), __LINE__);
        }
        if (is_null($classes) || (is_array($classes) && empty($classes))) {
            unset($this->Classes);
        } else {
            $this->Classes = $classes;
        }
        return $this;
    }
    /**
     * Get GradeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGradeId()
    {
        return isset($this->GradeId) ? $this->GradeId : null;
    }
    /**
     * Set GradeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gradeId
     * @return \patest\StructType\BizAction_BizResource_CopyVisit_Request
     */
    public function setGradeId($gradeId = null)
    {
        // validation for constraint: string
        if (!is_null($gradeId) && !is_string($gradeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gradeId, true), gettype($gradeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($gradeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $gradeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($gradeId, true)), __LINE__);
        }
        if (is_null($gradeId) || (is_array($gradeId) && empty($gradeId))) {
            unset($this->GradeId);
        } else {
            $this->GradeId = $gradeId;
        }
        return $this;
    }
    /**
     * Get GroupName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGroupName()
    {
        return isset($this->GroupName) ? $this->GroupName : null;
    }
    /**
     * Set GroupName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $groupName
     * @return \patest\StructType\BizAction_BizResource_CopyVisit_Request
     */
    public function setGroupName($groupName = null)
    {
        // validation for constraint: string
        if (!is_null($groupName) && !is_string($groupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupName, true), gettype($groupName)), __LINE__);
        }
        if (is_null($groupName) || (is_array($groupName) && empty($groupName))) {
            unset($this->GroupName);
        } else {
            $this->GroupName = $groupName;
        }
        return $this;
    }
    /**
     * Get OrderType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderType()
    {
        return isset($this->OrderType) ? $this->OrderType : null;
    }
    /**
     * Set OrderType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\OrderType::valueIsValid()
     * @uses \patest\EnumType\OrderType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $orderType
     * @return \patest\StructType\BizAction_BizResource_CopyVisit_Request
     */
    public function setOrderType($orderType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\OrderType::valueIsValid($orderType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\OrderType', is_array($orderType) ? implode(', ', $orderType) : var_export($orderType, true), implode(', ', \patest\EnumType\OrderType::getValidValues())), __LINE__);
        }
        if (is_null($orderType) || (is_array($orderType) && empty($orderType))) {
            unset($this->OrderType);
        } else {
            $this->OrderType = $orderType;
        }
        return $this;
    }
    /**
     * Get PreferredEndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPreferredEndDate()
    {
        return isset($this->PreferredEndDate) ? $this->PreferredEndDate : null;
    }
    /**
     * Set PreferredEndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $preferredEndDate
     * @return \patest\StructType\BizAction_BizResource_CopyVisit_Request
     */
    public function setPreferredEndDate($preferredEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($preferredEndDate) && !is_string($preferredEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($preferredEndDate, true), gettype($preferredEndDate)), __LINE__);
        }
        if (is_null($preferredEndDate) || (is_array($preferredEndDate) && empty($preferredEndDate))) {
            unset($this->PreferredEndDate);
        } else {
            $this->PreferredEndDate = $preferredEndDate;
        }
        return $this;
    }
    /**
     * Get PreferredStartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPreferredStartDate()
    {
        return isset($this->PreferredStartDate) ? $this->PreferredStartDate : null;
    }
    /**
     * Set PreferredStartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $preferredStartDate
     * @return \patest\StructType\BizAction_BizResource_CopyVisit_Request
     */
    public function setPreferredStartDate($preferredStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($preferredStartDate) && !is_string($preferredStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($preferredStartDate, true), gettype($preferredStartDate)), __LINE__);
        }
        if (is_null($preferredStartDate) || (is_array($preferredStartDate) && empty($preferredStartDate))) {
            unset($this->PreferredStartDate);
        } else {
            $this->PreferredStartDate = $preferredStartDate;
        }
        return $this;
    }
    /**
     * Get SourceOrderVisitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSourceOrderVisitId()
    {
        return isset($this->SourceOrderVisitId) ? $this->SourceOrderVisitId : null;
    }
    /**
     * Set SourceOrderVisitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sourceOrderVisitId
     * @return \patest\StructType\BizAction_BizResource_CopyVisit_Request
     */
    public function setSourceOrderVisitId($sourceOrderVisitId = null)
    {
        // validation for constraint: string
        if (!is_null($sourceOrderVisitId) && !is_string($sourceOrderVisitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceOrderVisitId, true), gettype($sourceOrderVisitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sourceOrderVisitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sourceOrderVisitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sourceOrderVisitId, true)), __LINE__);
        }
        if (is_null($sourceOrderVisitId) || (is_array($sourceOrderVisitId) && empty($sourceOrderVisitId))) {
            unset($this->SourceOrderVisitId);
        } else {
            $this->SourceOrderVisitId = $sourceOrderVisitId;
        }
        return $this;
    }
}
