<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.AccessControl.SyncEntitiesToShowtime.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_AccessControl_SyncEntitiesToShowtime_Request extends AnyEntity
{
    /**
     * The AccessControlSystemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessControlSystemId;
    /**
     * Constructor method for BizAction.AccessControl.SyncEntitiesToShowtime.Request
     * @uses BizAction_AccessControl_SyncEntitiesToShowtime_Request::setAccessControlSystemId()
     * @param string $accessControlSystemId
     */
    public function __construct($accessControlSystemId = null)
    {
        $this
            ->setAccessControlSystemId($accessControlSystemId);
    }
    /**
     * Get AccessControlSystemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlSystemId()
    {
        return isset($this->AccessControlSystemId) ? $this->AccessControlSystemId : null;
    }
    /**
     * Set AccessControlSystemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessControlSystemId
     * @return \patest\StructType\BizAction_AccessControl_SyncEntitiesToShowtime_Request
     */
    public function setAccessControlSystemId($accessControlSystemId = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlSystemId) && !is_string($accessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlSystemId, true), gettype($accessControlSystemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessControlSystemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessControlSystemId, true)), __LINE__);
        }
        if (is_null($accessControlSystemId) || (is_array($accessControlSystemId) && empty($accessControlSystemId))) {
            unset($this->AccessControlSystemId);
        } else {
            $this->AccessControlSystemId = $accessControlSystemId;
        }
        return $this;
    }
}
