<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.AccessControl.ShowtimeSyncEventBarcodes.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_AccessControl_ShowtimeSyncEventBarcodes_Request extends AnyEntity
{
    /**
     * The BarcodesToSync
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $BarcodesToSync;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The SyncProgressStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SyncProgressStatus;
    /**
     * The SyncRequestInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SyncRequestInfo;
    /**
     * Constructor method for BizAction.AccessControl.ShowtimeSyncEventBarcodes.Request
     * @uses BizAction_AccessControl_ShowtimeSyncEventBarcodes_Request::setBarcodesToSync()
     * @uses BizAction_AccessControl_ShowtimeSyncEventBarcodes_Request::setEventId()
     * @uses BizAction_AccessControl_ShowtimeSyncEventBarcodes_Request::setSyncProgressStatus()
     * @uses BizAction_AccessControl_ShowtimeSyncEventBarcodes_Request::setSyncRequestInfo()
     * @param int $barcodesToSync
     * @param string $eventId
     * @param string $syncProgressStatus
     * @param string $syncRequestInfo
     */
    public function __construct($barcodesToSync = null, $eventId = null, $syncProgressStatus = null, $syncRequestInfo = null)
    {
        $this
            ->setBarcodesToSync($barcodesToSync)
            ->setEventId($eventId)
            ->setSyncProgressStatus($syncProgressStatus)
            ->setSyncRequestInfo($syncRequestInfo);
    }
    /**
     * Get BarcodesToSync value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBarcodesToSync()
    {
        return isset($this->BarcodesToSync) ? $this->BarcodesToSync : null;
    }
    /**
     * Set BarcodesToSync value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $barcodesToSync
     * @return \patest\StructType\BizAction_AccessControl_ShowtimeSyncEventBarcodes_Request
     */
    public function setBarcodesToSync($barcodesToSync = null)
    {
        // validation for constraint: int
        if (!is_null($barcodesToSync) && !(is_int($barcodesToSync) || ctype_digit($barcodesToSync))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($barcodesToSync, true), gettype($barcodesToSync)), __LINE__);
        }
        if (is_null($barcodesToSync) || (is_array($barcodesToSync) && empty($barcodesToSync))) {
            unset($this->BarcodesToSync);
        } else {
            $this->BarcodesToSync = $barcodesToSync;
        }
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\BizAction_AccessControl_ShowtimeSyncEventBarcodes_Request
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get SyncProgressStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSyncProgressStatus()
    {
        return isset($this->SyncProgressStatus) ? $this->SyncProgressStatus : null;
    }
    /**
     * Set SyncProgressStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $syncProgressStatus
     * @return \patest\StructType\BizAction_AccessControl_ShowtimeSyncEventBarcodes_Request
     */
    public function setSyncProgressStatus($syncProgressStatus = null)
    {
        // validation for constraint: string
        if (!is_null($syncProgressStatus) && !is_string($syncProgressStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($syncProgressStatus, true), gettype($syncProgressStatus)), __LINE__);
        }
        if (is_null($syncProgressStatus) || (is_array($syncProgressStatus) && empty($syncProgressStatus))) {
            unset($this->SyncProgressStatus);
        } else {
            $this->SyncProgressStatus = $syncProgressStatus;
        }
        return $this;
    }
    /**
     * Get SyncRequestInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSyncRequestInfo()
    {
        return isset($this->SyncRequestInfo) ? $this->SyncRequestInfo : null;
    }
    /**
     * Set SyncRequestInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $syncRequestInfo
     * @return \patest\StructType\BizAction_AccessControl_ShowtimeSyncEventBarcodes_Request
     */
    public function setSyncRequestInfo($syncRequestInfo = null)
    {
        // validation for constraint: string
        if (!is_null($syncRequestInfo) && !is_string($syncRequestInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($syncRequestInfo, true), gettype($syncRequestInfo)), __LINE__);
        }
        if (is_null($syncRequestInfo) || (is_array($syncRequestInfo) && empty($syncRequestInfo))) {
            unset($this->SyncRequestInfo);
        } else {
            $this->SyncRequestInfo = $syncRequestInfo;
        }
        return $this;
    }
}
