<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.AccessControl.Sales.LoadAccessCard.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_AccessControl_Sales_LoadAccessCard_Request extends AnyEntity
{
    /**
     * The IsTransactionCommitted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsTransactionCommitted;
    /**
     * The ItemIdsFilter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ItemIdsFilter;
    /**
     * The RequestedBasketItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfAccessControl_SaleItemAccessCardInformation
     */
    public $RequestedBasketItems;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The ValidationErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValidationErrors;
    /**
     * Constructor method for BizAction.AccessControl.Sales.LoadAccessCard.Request
     * @uses BizAction_AccessControl_Sales_LoadAccessCard_Request::setIsTransactionCommitted()
     * @uses BizAction_AccessControl_Sales_LoadAccessCard_Request::setItemIdsFilter()
     * @uses BizAction_AccessControl_Sales_LoadAccessCard_Request::setRequestedBasketItems()
     * @uses BizAction_AccessControl_Sales_LoadAccessCard_Request::setTransactionGuid()
     * @uses BizAction_AccessControl_Sales_LoadAccessCard_Request::setValidationErrors()
     * @param bool $isTransactionCommitted
     * @param string $itemIdsFilter
     * @param \patest\StructType\RecordSetOfAccessControl_SaleItemAccessCardInformation $requestedBasketItems
     * @param string $transactionGuid
     * @param string $validationErrors
     */
    public function __construct($isTransactionCommitted = null, $itemIdsFilter = null, \patest\StructType\RecordSetOfAccessControl_SaleItemAccessCardInformation $requestedBasketItems = null, $transactionGuid = null, $validationErrors = null)
    {
        $this
            ->setIsTransactionCommitted($isTransactionCommitted)
            ->setItemIdsFilter($itemIdsFilter)
            ->setRequestedBasketItems($requestedBasketItems)
            ->setTransactionGuid($transactionGuid)
            ->setValidationErrors($validationErrors);
    }
    /**
     * Get IsTransactionCommitted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsTransactionCommitted()
    {
        return isset($this->IsTransactionCommitted) ? $this->IsTransactionCommitted : null;
    }
    /**
     * Set IsTransactionCommitted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isTransactionCommitted
     * @return \patest\StructType\BizAction_AccessControl_Sales_LoadAccessCard_Request
     */
    public function setIsTransactionCommitted($isTransactionCommitted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTransactionCommitted) && !is_bool($isTransactionCommitted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTransactionCommitted, true), gettype($isTransactionCommitted)), __LINE__);
        }
        if (is_null($isTransactionCommitted) || (is_array($isTransactionCommitted) && empty($isTransactionCommitted))) {
            unset($this->IsTransactionCommitted);
        } else {
            $this->IsTransactionCommitted = $isTransactionCommitted;
        }
        return $this;
    }
    /**
     * Get ItemIdsFilter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemIdsFilter()
    {
        return isset($this->ItemIdsFilter) ? $this->ItemIdsFilter : null;
    }
    /**
     * Set ItemIdsFilter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemIdsFilter
     * @return \patest\StructType\BizAction_AccessControl_Sales_LoadAccessCard_Request
     */
    public function setItemIdsFilter($itemIdsFilter = null)
    {
        // validation for constraint: string
        if (!is_null($itemIdsFilter) && !is_string($itemIdsFilter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemIdsFilter, true), gettype($itemIdsFilter)), __LINE__);
        }
        if (is_null($itemIdsFilter) || (is_array($itemIdsFilter) && empty($itemIdsFilter))) {
            unset($this->ItemIdsFilter);
        } else {
            $this->ItemIdsFilter = $itemIdsFilter;
        }
        return $this;
    }
    /**
     * Get RequestedBasketItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfAccessControl_SaleItemAccessCardInformation|null
     */
    public function getRequestedBasketItems()
    {
        return isset($this->RequestedBasketItems) ? $this->RequestedBasketItems : null;
    }
    /**
     * Set RequestedBasketItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfAccessControl_SaleItemAccessCardInformation $requestedBasketItems
     * @return \patest\StructType\BizAction_AccessControl_Sales_LoadAccessCard_Request
     */
    public function setRequestedBasketItems(\patest\StructType\RecordSetOfAccessControl_SaleItemAccessCardInformation $requestedBasketItems = null)
    {
        if (is_null($requestedBasketItems) || (is_array($requestedBasketItems) && empty($requestedBasketItems))) {
            unset($this->RequestedBasketItems);
        } else {
            $this->RequestedBasketItems = $requestedBasketItems;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\BizAction_AccessControl_Sales_LoadAccessCard_Request
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
    /**
     * Get ValidationErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValidationErrors()
    {
        return isset($this->ValidationErrors) ? $this->ValidationErrors : null;
    }
    /**
     * Set ValidationErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $validationErrors
     * @return \patest\StructType\BizAction_AccessControl_Sales_LoadAccessCard_Request
     */
    public function setValidationErrors($validationErrors = null)
    {
        // validation for constraint: string
        if (!is_null($validationErrors) && !is_string($validationErrors)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validationErrors, true), gettype($validationErrors)), __LINE__);
        }
        if (is_null($validationErrors) || (is_array($validationErrors) && empty($validationErrors))) {
            unset($this->ValidationErrors);
        } else {
            $this->ValidationErrors = $validationErrors;
        }
        return $this;
    }
}
