<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * BizActionLogics.Foundation.ProcessSchedule.Schedule.Request StructType
 * @subpackage Structs
 */
class BizActionLogics_Foundation_ProcessSchedule_Schedule_Request extends AnyEntity
{
    /**
     * The ProcessDefinitionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProcessDefinitionId;
    /**
     * The Schedule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Foundation_ProcessSchedule
     */
    public $Schedule;
    /**
     * Constructor method for
     * BizActionLogics.Foundation.ProcessSchedule.Schedule.Request
     * @uses BizActionLogics_Foundation_ProcessSchedule_Schedule_Request::setProcessDefinitionId()
     * @uses BizActionLogics_Foundation_ProcessSchedule_Schedule_Request::setSchedule()
     * @param string $processDefinitionId
     * @param \patest\StructType\Foundation_ProcessSchedule $schedule
     */
    public function __construct($processDefinitionId = null, \patest\StructType\Foundation_ProcessSchedule $schedule = null)
    {
        $this
            ->setProcessDefinitionId($processDefinitionId)
            ->setSchedule($schedule);
    }
    /**
     * Get ProcessDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProcessDefinitionId()
    {
        return isset($this->ProcessDefinitionId) ? $this->ProcessDefinitionId : null;
    }
    /**
     * Set ProcessDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $processDefinitionId
     * @return \patest\StructType\BizActionLogics_Foundation_ProcessSchedule_Schedule_Request
     */
    public function setProcessDefinitionId($processDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($processDefinitionId) && !is_string($processDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($processDefinitionId, true), gettype($processDefinitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($processDefinitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $processDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($processDefinitionId, true)), __LINE__);
        }
        if (is_null($processDefinitionId) || (is_array($processDefinitionId) && empty($processDefinitionId))) {
            unset($this->ProcessDefinitionId);
        } else {
            $this->ProcessDefinitionId = $processDefinitionId;
        }
        return $this;
    }
    /**
     * Get Schedule value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Foundation_ProcessSchedule|null
     */
    public function getSchedule()
    {
        return isset($this->Schedule) ? $this->Schedule : null;
    }
    /**
     * Set Schedule value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Foundation_ProcessSchedule $schedule
     * @return \patest\StructType\BizActionLogics_Foundation_ProcessSchedule_Schedule_Request
     */
    public function setSchedule(\patest\StructType\Foundation_ProcessSchedule $schedule = null)
    {
        if (is_null($schedule) || (is_array($schedule) && empty($schedule))) {
            unset($this->Schedule);
        } else {
            $this->Schedule = $schedule;
        }
        return $this;
    }
}
