<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizActionLogics.AccessControl.SynchronizeEntity.Request
 * StructType
 * @subpackage Structs
 */
class BizActionLogics_AccessControl_SynchronizeEntity_Request extends AnyEntity
{
    /**
     * The AccessControlDataId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessControlDataId;
    /**
     * The AccessControlSystemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessControlSystemId;
    /**
     * The EntityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityName;
    /**
     * The GuidEntityId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GuidEntityId;
    /**
     * The IntEntityId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $IntEntityId;
    /**
     * The StringEntityId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StringEntityId;
    /**
     * Constructor method for BizActionLogics.AccessControl.SynchronizeEntity.Request
     * @uses BizActionLogics_AccessControl_SynchronizeEntity_Request::setAccessControlDataId()
     * @uses BizActionLogics_AccessControl_SynchronizeEntity_Request::setAccessControlSystemId()
     * @uses BizActionLogics_AccessControl_SynchronizeEntity_Request::setEntityName()
     * @uses BizActionLogics_AccessControl_SynchronizeEntity_Request::setGuidEntityId()
     * @uses BizActionLogics_AccessControl_SynchronizeEntity_Request::setIntEntityId()
     * @uses BizActionLogics_AccessControl_SynchronizeEntity_Request::setStringEntityId()
     * @param string $accessControlDataId
     * @param string $accessControlSystemId
     * @param string $entityName
     * @param string $guidEntityId
     * @param int $intEntityId
     * @param string $stringEntityId
     */
    public function __construct($accessControlDataId = null, $accessControlSystemId = null, $entityName = null, $guidEntityId = null, $intEntityId = null, $stringEntityId = null)
    {
        $this
            ->setAccessControlDataId($accessControlDataId)
            ->setAccessControlSystemId($accessControlSystemId)
            ->setEntityName($entityName)
            ->setGuidEntityId($guidEntityId)
            ->setIntEntityId($intEntityId)
            ->setStringEntityId($stringEntityId);
    }
    /**
     * Get AccessControlDataId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlDataId()
    {
        return isset($this->AccessControlDataId) ? $this->AccessControlDataId : null;
    }
    /**
     * Set AccessControlDataId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessControlDataId
     * @return \patest\StructType\BizActionLogics_AccessControl_SynchronizeEntity_Request
     */
    public function setAccessControlDataId($accessControlDataId = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlDataId) && !is_string($accessControlDataId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlDataId, true), gettype($accessControlDataId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessControlDataId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessControlDataId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessControlDataId, true)), __LINE__);
        }
        if (is_null($accessControlDataId) || (is_array($accessControlDataId) && empty($accessControlDataId))) {
            unset($this->AccessControlDataId);
        } else {
            $this->AccessControlDataId = $accessControlDataId;
        }
        return $this;
    }
    /**
     * Get AccessControlSystemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlSystemId()
    {
        return isset($this->AccessControlSystemId) ? $this->AccessControlSystemId : null;
    }
    /**
     * Set AccessControlSystemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessControlSystemId
     * @return \patest\StructType\BizActionLogics_AccessControl_SynchronizeEntity_Request
     */
    public function setAccessControlSystemId($accessControlSystemId = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlSystemId) && !is_string($accessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlSystemId, true), gettype($accessControlSystemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessControlSystemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessControlSystemId, true)), __LINE__);
        }
        if (is_null($accessControlSystemId) || (is_array($accessControlSystemId) && empty($accessControlSystemId))) {
            unset($this->AccessControlSystemId);
        } else {
            $this->AccessControlSystemId = $accessControlSystemId;
        }
        return $this;
    }
    /**
     * Get EntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityName()
    {
        return isset($this->EntityName) ? $this->EntityName : null;
    }
    /**
     * Set EntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityName
     * @return \patest\StructType\BizActionLogics_AccessControl_SynchronizeEntity_Request
     */
    public function setEntityName($entityName = null)
    {
        // validation for constraint: string
        if (!is_null($entityName) && !is_string($entityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityName, true), gettype($entityName)), __LINE__);
        }
        if (is_null($entityName) || (is_array($entityName) && empty($entityName))) {
            unset($this->EntityName);
        } else {
            $this->EntityName = $entityName;
        }
        return $this;
    }
    /**
     * Get GuidEntityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGuidEntityId()
    {
        return isset($this->GuidEntityId) ? $this->GuidEntityId : null;
    }
    /**
     * Set GuidEntityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $guidEntityId
     * @return \patest\StructType\BizActionLogics_AccessControl_SynchronizeEntity_Request
     */
    public function setGuidEntityId($guidEntityId = null)
    {
        // validation for constraint: string
        if (!is_null($guidEntityId) && !is_string($guidEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guidEntityId, true), gettype($guidEntityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($guidEntityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $guidEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($guidEntityId, true)), __LINE__);
        }
        if (is_null($guidEntityId) || (is_array($guidEntityId) && empty($guidEntityId))) {
            unset($this->GuidEntityId);
        } else {
            $this->GuidEntityId = $guidEntityId;
        }
        return $this;
    }
    /**
     * Get IntEntityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIntEntityId()
    {
        return isset($this->IntEntityId) ? $this->IntEntityId : null;
    }
    /**
     * Set IntEntityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $intEntityId
     * @return \patest\StructType\BizActionLogics_AccessControl_SynchronizeEntity_Request
     */
    public function setIntEntityId($intEntityId = null)
    {
        // validation for constraint: int
        if (!is_null($intEntityId) && !(is_int($intEntityId) || ctype_digit($intEntityId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($intEntityId, true), gettype($intEntityId)), __LINE__);
        }
        if (is_null($intEntityId) || (is_array($intEntityId) && empty($intEntityId))) {
            unset($this->IntEntityId);
        } else {
            $this->IntEntityId = $intEntityId;
        }
        return $this;
    }
    /**
     * Get StringEntityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStringEntityId()
    {
        return isset($this->StringEntityId) ? $this->StringEntityId : null;
    }
    /**
     * Set StringEntityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stringEntityId
     * @return \patest\StructType\BizActionLogics_AccessControl_SynchronizeEntity_Request
     */
    public function setStringEntityId($stringEntityId = null)
    {
        // validation for constraint: string
        if (!is_null($stringEntityId) && !is_string($stringEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stringEntityId, true), gettype($stringEntityId)), __LINE__);
        }
        if (is_null($stringEntityId) || (is_array($stringEntityId) && empty($stringEntityId))) {
            unset($this->StringEntityId);
        } else {
            $this->StringEntityId = $stringEntityId;
        }
        return $this;
    }
}
