<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BenefitPackageGrantData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BenefitPackageGrantData
 * @subpackage Structs
 */
class BenefitPackageGrantData extends AbstractStructBase
{
    /**
     * The BenefitPackageId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BenefitPackageId;
    /**
     * The Elements
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfBenefitPackageElementData
     */
    public $Elements;
    /**
     * Constructor method for BenefitPackageGrantData
     * @uses BenefitPackageGrantData::setBenefitPackageId()
     * @uses BenefitPackageGrantData::setElements()
     * @param string $benefitPackageId
     * @param \patest\ArrayType\ArrayOfBenefitPackageElementData $elements
     */
    public function __construct($benefitPackageId = null, \patest\ArrayType\ArrayOfBenefitPackageElementData $elements = null)
    {
        $this
            ->setBenefitPackageId($benefitPackageId)
            ->setElements($elements);
    }
    /**
     * Get BenefitPackageId value
     * @return string|null
     */
    public function getBenefitPackageId()
    {
        return $this->BenefitPackageId;
    }
    /**
     * Set BenefitPackageId value
     * @param string $benefitPackageId
     * @return \patest\StructType\BenefitPackageGrantData
     */
    public function setBenefitPackageId($benefitPackageId = null)
    {
        // validation for constraint: string
        if (!is_null($benefitPackageId) && !is_string($benefitPackageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($benefitPackageId, true), gettype($benefitPackageId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($benefitPackageId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $benefitPackageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($benefitPackageId, true)), __LINE__);
        }
        $this->BenefitPackageId = $benefitPackageId;
        return $this;
    }
    /**
     * Get Elements value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfBenefitPackageElementData|null
     */
    public function getElements()
    {
        return isset($this->Elements) ? $this->Elements : null;
    }
    /**
     * Set Elements value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfBenefitPackageElementData $elements
     * @return \patest\StructType\BenefitPackageGrantData
     */
    public function setElements(\patest\ArrayType\ArrayOfBenefitPackageElementData $elements = null)
    {
        if (is_null($elements) || (is_array($elements) && empty($elements))) {
            unset($this->Elements);
        } else {
            $this->Elements = $elements;
        }
        return $this;
    }
}
