<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BenefitPackageElementData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BenefitPackageElementData
 * @subpackage Structs
 */
class BenefitPackageElementData extends AbstractStructBase
{
    /**
     * The BenefitElementId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BenefitElementId;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The Enabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Enabled;
    /**
     * The NewId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NewId;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Quantity;
    /**
     * The ValueForTax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ValueForTax;
    /**
     * Constructor method for BenefitPackageElementData
     * @uses BenefitPackageElementData::setBenefitElementId()
     * @uses BenefitPackageElementData::setDescription()
     * @uses BenefitPackageElementData::setEnabled()
     * @uses BenefitPackageElementData::setNewId()
     * @uses BenefitPackageElementData::setQuantity()
     * @uses BenefitPackageElementData::setValueForTax()
     * @param string $benefitElementId
     * @param string $description
     * @param bool $enabled
     * @param string $newId
     * @param int $quantity
     * @param float $valueForTax
     */
    public function __construct($benefitElementId = null, $description = null, $enabled = null, $newId = null, $quantity = null, $valueForTax = null)
    {
        $this
            ->setBenefitElementId($benefitElementId)
            ->setDescription($description)
            ->setEnabled($enabled)
            ->setNewId($newId)
            ->setQuantity($quantity)
            ->setValueForTax($valueForTax);
    }
    /**
     * Get BenefitElementId value
     * @return string|null
     */
    public function getBenefitElementId()
    {
        return $this->BenefitElementId;
    }
    /**
     * Set BenefitElementId value
     * @param string $benefitElementId
     * @return \patest\StructType\BenefitPackageElementData
     */
    public function setBenefitElementId($benefitElementId = null)
    {
        // validation for constraint: string
        if (!is_null($benefitElementId) && !is_string($benefitElementId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($benefitElementId, true), gettype($benefitElementId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($benefitElementId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $benefitElementId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($benefitElementId, true)), __LINE__);
        }
        $this->BenefitElementId = $benefitElementId;
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \patest\StructType\BenefitPackageElementData
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Enabled value
     * @return bool|null
     */
    public function getEnabled()
    {
        return $this->Enabled;
    }
    /**
     * Set Enabled value
     * @param bool $enabled
     * @return \patest\StructType\BenefitPackageElementData
     */
    public function setEnabled($enabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($enabled) && !is_bool($enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enabled, true), gettype($enabled)), __LINE__);
        }
        $this->Enabled = $enabled;
        return $this;
    }
    /**
     * Get NewId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewId()
    {
        return isset($this->NewId) ? $this->NewId : null;
    }
    /**
     * Set NewId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newId
     * @return \patest\StructType\BenefitPackageElementData
     */
    public function setNewId($newId = null)
    {
        // validation for constraint: string
        if (!is_null($newId) && !is_string($newId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newId, true), gettype($newId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($newId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $newId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($newId, true)), __LINE__);
        }
        if (is_null($newId) || (is_array($newId) && empty($newId))) {
            unset($this->NewId);
        } else {
            $this->NewId = $newId;
        }
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \patest\StructType\BenefitPackageElementData
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get ValueForTax value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValueForTax()
    {
        return isset($this->ValueForTax) ? $this->ValueForTax : null;
    }
    /**
     * Set ValueForTax value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $valueForTax
     * @return \patest\StructType\BenefitPackageElementData
     */
    public function setValueForTax($valueForTax = null)
    {
        // validation for constraint: float
        if (!is_null($valueForTax) && !(is_float($valueForTax) || is_numeric($valueForTax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valueForTax, true), gettype($valueForTax)), __LINE__);
        }
        if (is_null($valueForTax) || (is_array($valueForTax) && empty($valueForTax))) {
            unset($this->ValueForTax);
        } else {
            $this->ValueForTax = $valueForTax;
        }
        return $this;
    }
}
