<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BeginCustomerRegistration-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BeginCustomerRegistration-Request
 * @subpackage Structs
 */
class BeginCustomerRegistration_Request extends AbstractStructBase
{
    /**
     * The ClientEntity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ClientEntity
     */
    public $ClientEntity;
    /**
     * The LoginUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LoginUrl;
    /**
     * The RegistrationLandingUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RegistrationLandingUrl;
    /**
     * The ResetPasswordUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResetPasswordUrl;
    /**
     * Constructor method for BeginCustomerRegistration-Request
     * @uses BeginCustomerRegistration_Request::setClientEntity()
     * @uses BeginCustomerRegistration_Request::setLoginUrl()
     * @uses BeginCustomerRegistration_Request::setRegistrationLandingUrl()
     * @uses BeginCustomerRegistration_Request::setResetPasswordUrl()
     * @param \patest\StructType\ClientEntity $clientEntity
     * @param string $loginUrl
     * @param string $registrationLandingUrl
     * @param string $resetPasswordUrl
     */
    public function __construct(\patest\StructType\ClientEntity $clientEntity = null, $loginUrl = null, $registrationLandingUrl = null, $resetPasswordUrl = null)
    {
        $this
            ->setClientEntity($clientEntity)
            ->setLoginUrl($loginUrl)
            ->setRegistrationLandingUrl($registrationLandingUrl)
            ->setResetPasswordUrl($resetPasswordUrl);
    }
    /**
     * Get ClientEntity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ClientEntity|null
     */
    public function getClientEntity()
    {
        return isset($this->ClientEntity) ? $this->ClientEntity : null;
    }
    /**
     * Set ClientEntity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ClientEntity $clientEntity
     * @return \patest\StructType\BeginCustomerRegistration_Request
     */
    public function setClientEntity(\patest\StructType\ClientEntity $clientEntity = null)
    {
        if (is_null($clientEntity) || (is_array($clientEntity) && empty($clientEntity))) {
            unset($this->ClientEntity);
        } else {
            $this->ClientEntity = $clientEntity;
        }
        return $this;
    }
    /**
     * Get LoginUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoginUrl()
    {
        return isset($this->LoginUrl) ? $this->LoginUrl : null;
    }
    /**
     * Set LoginUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $loginUrl
     * @return \patest\StructType\BeginCustomerRegistration_Request
     */
    public function setLoginUrl($loginUrl = null)
    {
        // validation for constraint: string
        if (!is_null($loginUrl) && !is_string($loginUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginUrl, true), gettype($loginUrl)), __LINE__);
        }
        if (is_null($loginUrl) || (is_array($loginUrl) && empty($loginUrl))) {
            unset($this->LoginUrl);
        } else {
            $this->LoginUrl = $loginUrl;
        }
        return $this;
    }
    /**
     * Get RegistrationLandingUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRegistrationLandingUrl()
    {
        return isset($this->RegistrationLandingUrl) ? $this->RegistrationLandingUrl : null;
    }
    /**
     * Set RegistrationLandingUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $registrationLandingUrl
     * @return \patest\StructType\BeginCustomerRegistration_Request
     */
    public function setRegistrationLandingUrl($registrationLandingUrl = null)
    {
        // validation for constraint: string
        if (!is_null($registrationLandingUrl) && !is_string($registrationLandingUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($registrationLandingUrl, true), gettype($registrationLandingUrl)), __LINE__);
        }
        if (is_null($registrationLandingUrl) || (is_array($registrationLandingUrl) && empty($registrationLandingUrl))) {
            unset($this->RegistrationLandingUrl);
        } else {
            $this->RegistrationLandingUrl = $registrationLandingUrl;
        }
        return $this;
    }
    /**
     * Get ResetPasswordUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResetPasswordUrl()
    {
        return isset($this->ResetPasswordUrl) ? $this->ResetPasswordUrl : null;
    }
    /**
     * Set ResetPasswordUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resetPasswordUrl
     * @return \patest\StructType\BeginCustomerRegistration_Request
     */
    public function setResetPasswordUrl($resetPasswordUrl = null)
    {
        // validation for constraint: string
        if (!is_null($resetPasswordUrl) && !is_string($resetPasswordUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resetPasswordUrl, true), gettype($resetPasswordUrl)), __LINE__);
        }
        if (is_null($resetPasswordUrl) || (is_array($resetPasswordUrl) && empty($resetPasswordUrl))) {
            unset($this->ResetPasswordUrl);
        } else {
            $this->ResetPasswordUrl = $resetPasswordUrl;
        }
        return $this;
    }
}
