<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BasketItemAccessControlValidationErrors StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BasketItemAccessControlValidationErrors
 * @subpackage Structs
 */
class BasketItemAccessControlValidationErrors extends AbstractStructBase
{
    /**
     * The ItemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ItemId;
    /**
     * The ValidationError
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\FailureInformation
     */
    public $ValidationError;
    /**
     * Constructor method for BasketItemAccessControlValidationErrors
     * @uses BasketItemAccessControlValidationErrors::setItemId()
     * @uses BasketItemAccessControlValidationErrors::setValidationError()
     * @param int $itemId
     * @param \patest\StructType\FailureInformation $validationError
     */
    public function __construct($itemId = null, \patest\StructType\FailureInformation $validationError = null)
    {
        $this
            ->setItemId($itemId)
            ->setValidationError($validationError);
    }
    /**
     * Get ItemId value
     * @return int|null
     */
    public function getItemId()
    {
        return $this->ItemId;
    }
    /**
     * Set ItemId value
     * @param int $itemId
     * @return \patest\StructType\BasketItemAccessControlValidationErrors
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: int
        if (!is_null($itemId) && !(is_int($itemId) || ctype_digit($itemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        $this->ItemId = $itemId;
        return $this;
    }
    /**
     * Get ValidationError value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\FailureInformation|null
     */
    public function getValidationError()
    {
        return isset($this->ValidationError) ? $this->ValidationError : null;
    }
    /**
     * Set ValidationError value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\FailureInformation $validationError
     * @return \patest\StructType\BasketItemAccessControlValidationErrors
     */
    public function setValidationError(\patest\StructType\FailureInformation $validationError = null)
    {
        if (is_null($validationError) || (is_array($validationError) && empty($validationError))) {
            unset($this->ValidationError);
        } else {
            $this->ValidationError = $validationError;
        }
        return $this;
    }
}
