<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BasketItemAccessCardData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BasketItemAccessCardData
 * @subpackage Structs
 */
class BasketItemAccessCardData extends AbstractStructBase
{
    /**
     * The AccessControlSystemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessControlSystemId;
    /**
     * The CardId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CardId;
    /**
     * The CardName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardName;
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardNumber;
    /**
     * The IsNewCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsNewCard;
    /**
     * The OwnerClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OwnerClientId;
    /**
     * The ActiveLoadedItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfstringArrayOfguidty7Ep6D1
     */
    public $ActiveLoadedItems;
    /**
     * Constructor method for BasketItemAccessCardData
     * @uses BasketItemAccessCardData::setAccessControlSystemId()
     * @uses BasketItemAccessCardData::setCardId()
     * @uses BasketItemAccessCardData::setCardName()
     * @uses BasketItemAccessCardData::setCardNumber()
     * @uses BasketItemAccessCardData::setIsNewCard()
     * @uses BasketItemAccessCardData::setOwnerClientId()
     * @uses BasketItemAccessCardData::setActiveLoadedItems()
     * @param string $accessControlSystemId
     * @param string $cardId
     * @param string $cardName
     * @param string $cardNumber
     * @param bool $isNewCard
     * @param string $ownerClientId
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringArrayOfguidty7Ep6D1 $activeLoadedItems
     */
    public function __construct($accessControlSystemId = null, $cardId = null, $cardName = null, $cardNumber = null, $isNewCard = null, $ownerClientId = null, \patest\ArrayType\ArrayOfKeyValueOfstringArrayOfguidty7Ep6D1 $activeLoadedItems = null)
    {
        $this
            ->setAccessControlSystemId($accessControlSystemId)
            ->setCardId($cardId)
            ->setCardName($cardName)
            ->setCardNumber($cardNumber)
            ->setIsNewCard($isNewCard)
            ->setOwnerClientId($ownerClientId)
            ->setActiveLoadedItems($activeLoadedItems);
    }
    /**
     * Get AccessControlSystemId value
     * @return string|null
     */
    public function getAccessControlSystemId()
    {
        return $this->AccessControlSystemId;
    }
    /**
     * Set AccessControlSystemId value
     * @param string $accessControlSystemId
     * @return \patest\StructType\BasketItemAccessCardData
     */
    public function setAccessControlSystemId($accessControlSystemId = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlSystemId) && !is_string($accessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlSystemId, true), gettype($accessControlSystemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessControlSystemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessControlSystemId, true)), __LINE__);
        }
        $this->AccessControlSystemId = $accessControlSystemId;
        return $this;
    }
    /**
     * Get CardId value
     * @return string|null
     */
    public function getCardId()
    {
        return $this->CardId;
    }
    /**
     * Set CardId value
     * @param string $cardId
     * @return \patest\StructType\BasketItemAccessCardData
     */
    public function setCardId($cardId = null)
    {
        // validation for constraint: string
        if (!is_null($cardId) && !is_string($cardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardId, true), gettype($cardId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($cardId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $cardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($cardId, true)), __LINE__);
        }
        $this->CardId = $cardId;
        return $this;
    }
    /**
     * Get CardName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardName()
    {
        return isset($this->CardName) ? $this->CardName : null;
    }
    /**
     * Set CardName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardName
     * @return \patest\StructType\BasketItemAccessCardData
     */
    public function setCardName($cardName = null)
    {
        // validation for constraint: string
        if (!is_null($cardName) && !is_string($cardName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardName, true), gettype($cardName)), __LINE__);
        }
        if (is_null($cardName) || (is_array($cardName) && empty($cardName))) {
            unset($this->CardName);
        } else {
            $this->CardName = $cardName;
        }
        return $this;
    }
    /**
     * Get CardNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardNumber()
    {
        return isset($this->CardNumber) ? $this->CardNumber : null;
    }
    /**
     * Set CardNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardNumber
     * @return \patest\StructType\BasketItemAccessCardData
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        if (is_null($cardNumber) || (is_array($cardNumber) && empty($cardNumber))) {
            unset($this->CardNumber);
        } else {
            $this->CardNumber = $cardNumber;
        }
        return $this;
    }
    /**
     * Get IsNewCard value
     * @return bool|null
     */
    public function getIsNewCard()
    {
        return $this->IsNewCard;
    }
    /**
     * Set IsNewCard value
     * @param bool $isNewCard
     * @return \patest\StructType\BasketItemAccessCardData
     */
    public function setIsNewCard($isNewCard = null)
    {
        // validation for constraint: boolean
        if (!is_null($isNewCard) && !is_bool($isNewCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isNewCard, true), gettype($isNewCard)), __LINE__);
        }
        $this->IsNewCard = $isNewCard;
        return $this;
    }
    /**
     * Get OwnerClientId value
     * @return string|null
     */
    public function getOwnerClientId()
    {
        return $this->OwnerClientId;
    }
    /**
     * Set OwnerClientId value
     * @param string $ownerClientId
     * @return \patest\StructType\BasketItemAccessCardData
     */
    public function setOwnerClientId($ownerClientId = null)
    {
        // validation for constraint: string
        if (!is_null($ownerClientId) && !is_string($ownerClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerClientId, true), gettype($ownerClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ownerClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ownerClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ownerClientId, true)), __LINE__);
        }
        $this->OwnerClientId = $ownerClientId;
        return $this;
    }
    /**
     * Get ActiveLoadedItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfstringArrayOfguidty7Ep6D1|null
     */
    public function getActiveLoadedItems()
    {
        return isset($this->ActiveLoadedItems) ? $this->ActiveLoadedItems : null;
    }
    /**
     * Set ActiveLoadedItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringArrayOfguidty7Ep6D1 $activeLoadedItems
     * @return \patest\StructType\BasketItemAccessCardData
     */
    public function setActiveLoadedItems(\patest\ArrayType\ArrayOfKeyValueOfstringArrayOfguidty7Ep6D1 $activeLoadedItems = null)
    {
        if (is_null($activeLoadedItems) || (is_array($activeLoadedItems) && empty($activeLoadedItems))) {
            unset($this->ActiveLoadedItems);
        } else {
            $this->ActiveLoadedItems = $activeLoadedItems;
        }
        return $this;
    }
}
