<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BackOfficeUI.ClientTypeDetailExtended StructType
 * @subpackage Structs
 */
class BackOfficeUI_ClientTypeDetailExtended extends Crm_ClientTypeDetail
{
    /**
     * The ClientTypeName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $ClientTypeName;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Description;
    /**
     * The DisplayInClientAlerts
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DisplayInClientAlerts;
    /**
     * The DisplayInContactRecord
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DisplayInContactRecord;
    /**
     * Constructor method for BackOfficeUI.ClientTypeDetailExtended
     * @uses BackOfficeUI_ClientTypeDetailExtended::setClientTypeName()
     * @uses BackOfficeUI_ClientTypeDetailExtended::setDescription()
     * @uses BackOfficeUI_ClientTypeDetailExtended::setDisplayInClientAlerts()
     * @uses BackOfficeUI_ClientTypeDetailExtended::setDisplayInContactRecord()
     * @param \patest\StructType\GlobalString $clientTypeName
     * @param \patest\StructType\GlobalString $description
     * @param bool $displayInClientAlerts
     * @param bool $displayInContactRecord
     */
    public function __construct(\patest\StructType\GlobalString $clientTypeName = null, \patest\StructType\GlobalString $description = null, $displayInClientAlerts = null, $displayInContactRecord = null)
    {
        $this
            ->setClientTypeName($clientTypeName)
            ->setDescription($description)
            ->setDisplayInClientAlerts($displayInClientAlerts)
            ->setDisplayInContactRecord($displayInContactRecord);
    }
    /**
     * Get ClientTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getClientTypeName()
    {
        return isset($this->ClientTypeName) ? $this->ClientTypeName : null;
    }
    /**
     * Set ClientTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $clientTypeName
     * @return \patest\StructType\BackOfficeUI_ClientTypeDetailExtended
     */
    public function setClientTypeName(\patest\StructType\GlobalString $clientTypeName = null)
    {
        if (is_null($clientTypeName) || (is_array($clientTypeName) && empty($clientTypeName))) {
            unset($this->ClientTypeName);
        } else {
            $this->ClientTypeName = $clientTypeName;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $description
     * @return \patest\StructType\BackOfficeUI_ClientTypeDetailExtended
     */
    public function setDescription(\patest\StructType\GlobalString $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get DisplayInClientAlerts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDisplayInClientAlerts()
    {
        return isset($this->DisplayInClientAlerts) ? $this->DisplayInClientAlerts : null;
    }
    /**
     * Set DisplayInClientAlerts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $displayInClientAlerts
     * @return \patest\StructType\BackOfficeUI_ClientTypeDetailExtended
     */
    public function setDisplayInClientAlerts($displayInClientAlerts = null)
    {
        // validation for constraint: boolean
        if (!is_null($displayInClientAlerts) && !is_bool($displayInClientAlerts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($displayInClientAlerts, true), gettype($displayInClientAlerts)), __LINE__);
        }
        if (is_null($displayInClientAlerts) || (is_array($displayInClientAlerts) && empty($displayInClientAlerts))) {
            unset($this->DisplayInClientAlerts);
        } else {
            $this->DisplayInClientAlerts = $displayInClientAlerts;
        }
        return $this;
    }
    /**
     * Get DisplayInContactRecord value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDisplayInContactRecord()
    {
        return isset($this->DisplayInContactRecord) ? $this->DisplayInContactRecord : null;
    }
    /**
     * Set DisplayInContactRecord value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $displayInContactRecord
     * @return \patest\StructType\BackOfficeUI_ClientTypeDetailExtended
     */
    public function setDisplayInContactRecord($displayInContactRecord = null)
    {
        // validation for constraint: boolean
        if (!is_null($displayInContactRecord) && !is_bool($displayInContactRecord)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($displayInContactRecord, true), gettype($displayInContactRecord)), __LINE__);
        }
        if (is_null($displayInContactRecord) || (is_array($displayInContactRecord) && empty($displayInContactRecord))) {
            unset($this->DisplayInContactRecord);
        } else {
            $this->DisplayInContactRecord = $displayInContactRecord;
        }
        return $this;
    }
}
