<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for bSRO.Sales.ItemReprintReason StructType
 * @subpackage Structs
 */
class BSRO_Sales_ItemReprintReason extends AnyEntity
{
    /**
     * The ItemReprintReasonId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ItemReprintReasonId;
    /**
     * Constructor method for bSRO.Sales.ItemReprintReason
     * @uses BSRO_Sales_ItemReprintReason::setItemReprintReasonId()
     * @param string $itemReprintReasonId
     */
    public function __construct($itemReprintReasonId = null)
    {
        $this
            ->setItemReprintReasonId($itemReprintReasonId);
    }
    /**
     * Get ItemReprintReasonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemReprintReasonId()
    {
        return isset($this->ItemReprintReasonId) ? $this->ItemReprintReasonId : null;
    }
    /**
     * Set ItemReprintReasonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemReprintReasonId
     * @return \patest\StructType\BSRO_Sales_ItemReprintReason
     */
    public function setItemReprintReasonId($itemReprintReasonId = null)
    {
        // validation for constraint: string
        if (!is_null($itemReprintReasonId) && !is_string($itemReprintReasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemReprintReasonId, true), gettype($itemReprintReasonId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($itemReprintReasonId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $itemReprintReasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($itemReprintReasonId, true)), __LINE__);
        }
        if (is_null($itemReprintReasonId) || (is_array($itemReprintReasonId) && empty($itemReprintReasonId))) {
            unset($this->ItemReprintReasonId);
        } else {
            $this->ItemReprintReasonId = $itemReprintReasonId;
        }
        return $this;
    }
}
