<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for bSRO.Sales.EditSeriesInformation StructType
 * @subpackage Structs
 */
class BSRO_Sales_EditSeriesInformation extends AnyEntity
{
    /**
     * The Area
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Area;
    /**
     * The EventsQuantity
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventsQuantity;
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Note;
    /**
     * The PriceLevel
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceLevel;
    /**
     * The SelectedSeatQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SelectedSeatQuantity;
    /**
     * Constructor method for bSRO.Sales.EditSeriesInformation
     * @uses BSRO_Sales_EditSeriesInformation::setArea()
     * @uses BSRO_Sales_EditSeriesInformation::setEventsQuantity()
     * @uses BSRO_Sales_EditSeriesInformation::setNote()
     * @uses BSRO_Sales_EditSeriesInformation::setPriceLevel()
     * @uses BSRO_Sales_EditSeriesInformation::setSelectedSeatQuantity()
     * @param string $area
     * @param string $eventsQuantity
     * @param string $note
     * @param string $priceLevel
     * @param int $selectedSeatQuantity
     */
    public function __construct($area = null, $eventsQuantity = null, $note = null, $priceLevel = null, $selectedSeatQuantity = null)
    {
        $this
            ->setArea($area)
            ->setEventsQuantity($eventsQuantity)
            ->setNote($note)
            ->setPriceLevel($priceLevel)
            ->setSelectedSeatQuantity($selectedSeatQuantity);
    }
    /**
     * Get Area value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArea()
    {
        return isset($this->Area) ? $this->Area : null;
    }
    /**
     * Set Area value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $area
     * @return \patest\StructType\BSRO_Sales_EditSeriesInformation
     */
    public function setArea($area = null)
    {
        // validation for constraint: string
        if (!is_null($area) && !is_string($area)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($area, true), gettype($area)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($area) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $area)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($area, true)), __LINE__);
        }
        if (is_null($area) || (is_array($area) && empty($area))) {
            unset($this->Area);
        } else {
            $this->Area = $area;
        }
        return $this;
    }
    /**
     * Get EventsQuantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventsQuantity()
    {
        return isset($this->EventsQuantity) ? $this->EventsQuantity : null;
    }
    /**
     * Set EventsQuantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventsQuantity
     * @return \patest\StructType\BSRO_Sales_EditSeriesInformation
     */
    public function setEventsQuantity($eventsQuantity = null)
    {
        // validation for constraint: string
        if (!is_null($eventsQuantity) && !is_string($eventsQuantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventsQuantity, true), gettype($eventsQuantity)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventsQuantity) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventsQuantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventsQuantity, true)), __LINE__);
        }
        if (is_null($eventsQuantity) || (is_array($eventsQuantity) && empty($eventsQuantity))) {
            unset($this->EventsQuantity);
        } else {
            $this->EventsQuantity = $eventsQuantity;
        }
        return $this;
    }
    /**
     * Get Note value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNote()
    {
        return isset($this->Note) ? $this->Note : null;
    }
    /**
     * Set Note value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $note
     * @return \patest\StructType\BSRO_Sales_EditSeriesInformation
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note, true), gettype($note)), __LINE__);
        }
        if (is_null($note) || (is_array($note) && empty($note))) {
            unset($this->Note);
        } else {
            $this->Note = $note;
        }
        return $this;
    }
    /**
     * Get PriceLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceLevel()
    {
        return isset($this->PriceLevel) ? $this->PriceLevel : null;
    }
    /**
     * Set PriceLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceLevel
     * @return \patest\StructType\BSRO_Sales_EditSeriesInformation
     */
    public function setPriceLevel($priceLevel = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevel) && !is_string($priceLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevel, true), gettype($priceLevel)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceLevel) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceLevel, true)), __LINE__);
        }
        if (is_null($priceLevel) || (is_array($priceLevel) && empty($priceLevel))) {
            unset($this->PriceLevel);
        } else {
            $this->PriceLevel = $priceLevel;
        }
        return $this;
    }
    /**
     * Get SelectedSeatQuantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSelectedSeatQuantity()
    {
        return isset($this->SelectedSeatQuantity) ? $this->SelectedSeatQuantity : null;
    }
    /**
     * Set SelectedSeatQuantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $selectedSeatQuantity
     * @return \patest\StructType\BSRO_Sales_EditSeriesInformation
     */
    public function setSelectedSeatQuantity($selectedSeatQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($selectedSeatQuantity) && !(is_int($selectedSeatQuantity) || ctype_digit($selectedSeatQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($selectedSeatQuantity, true), gettype($selectedSeatQuantity)), __LINE__);
        }
        if (is_null($selectedSeatQuantity) || (is_array($selectedSeatQuantity) && empty($selectedSeatQuantity))) {
            unset($this->SelectedSeatQuantity);
        } else {
            $this->SelectedSeatQuantity = $selectedSeatQuantity;
        }
        return $this;
    }
}
