<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for bSRO.Sales.ActiveCustomerDepositCategories StructType
 * @subpackage Structs
 */
class BSRO_Sales_ActiveCustomerDepositCategories extends AnyEntity
{
    /**
     * The ClientAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ClientAmount;
    /**
     * The DepositCategoryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DepositCategoryId;
    /**
     * The OriginalAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $OriginalAmount;
    /**
     * The ReferenceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReferenceNumber;
    /**
     * The RemainingAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $RemainingAmount;
    /**
     * Constructor method for bSRO.Sales.ActiveCustomerDepositCategories
     * @uses BSRO_Sales_ActiveCustomerDepositCategories::setClientAmount()
     * @uses BSRO_Sales_ActiveCustomerDepositCategories::setDepositCategoryId()
     * @uses BSRO_Sales_ActiveCustomerDepositCategories::setOriginalAmount()
     * @uses BSRO_Sales_ActiveCustomerDepositCategories::setReferenceNumber()
     * @uses BSRO_Sales_ActiveCustomerDepositCategories::setRemainingAmount()
     * @param float $clientAmount
     * @param string $depositCategoryId
     * @param float $originalAmount
     * @param string $referenceNumber
     * @param float $remainingAmount
     */
    public function __construct($clientAmount = null, $depositCategoryId = null, $originalAmount = null, $referenceNumber = null, $remainingAmount = null)
    {
        $this
            ->setClientAmount($clientAmount)
            ->setDepositCategoryId($depositCategoryId)
            ->setOriginalAmount($originalAmount)
            ->setReferenceNumber($referenceNumber)
            ->setRemainingAmount($remainingAmount);
    }
    /**
     * Get ClientAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getClientAmount()
    {
        return isset($this->ClientAmount) ? $this->ClientAmount : null;
    }
    /**
     * Set ClientAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $clientAmount
     * @return \patest\StructType\BSRO_Sales_ActiveCustomerDepositCategories
     */
    public function setClientAmount($clientAmount = null)
    {
        // validation for constraint: float
        if (!is_null($clientAmount) && !(is_float($clientAmount) || is_numeric($clientAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($clientAmount, true), gettype($clientAmount)), __LINE__);
        }
        if (is_null($clientAmount) || (is_array($clientAmount) && empty($clientAmount))) {
            unset($this->ClientAmount);
        } else {
            $this->ClientAmount = $clientAmount;
        }
        return $this;
    }
    /**
     * Get DepositCategoryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDepositCategoryId()
    {
        return isset($this->DepositCategoryId) ? $this->DepositCategoryId : null;
    }
    /**
     * Set DepositCategoryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $depositCategoryId
     * @return \patest\StructType\BSRO_Sales_ActiveCustomerDepositCategories
     */
    public function setDepositCategoryId($depositCategoryId = null)
    {
        // validation for constraint: string
        if (!is_null($depositCategoryId) && !is_string($depositCategoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depositCategoryId, true), gettype($depositCategoryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($depositCategoryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $depositCategoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($depositCategoryId, true)), __LINE__);
        }
        if (is_null($depositCategoryId) || (is_array($depositCategoryId) && empty($depositCategoryId))) {
            unset($this->DepositCategoryId);
        } else {
            $this->DepositCategoryId = $depositCategoryId;
        }
        return $this;
    }
    /**
     * Get OriginalAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getOriginalAmount()
    {
        return isset($this->OriginalAmount) ? $this->OriginalAmount : null;
    }
    /**
     * Set OriginalAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $originalAmount
     * @return \patest\StructType\BSRO_Sales_ActiveCustomerDepositCategories
     */
    public function setOriginalAmount($originalAmount = null)
    {
        // validation for constraint: float
        if (!is_null($originalAmount) && !(is_float($originalAmount) || is_numeric($originalAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($originalAmount, true), gettype($originalAmount)), __LINE__);
        }
        if (is_null($originalAmount) || (is_array($originalAmount) && empty($originalAmount))) {
            unset($this->OriginalAmount);
        } else {
            $this->OriginalAmount = $originalAmount;
        }
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReferenceNumber()
    {
        return isset($this->ReferenceNumber) ? $this->ReferenceNumber : null;
    }
    /**
     * Set ReferenceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $referenceNumber
     * @return \patest\StructType\BSRO_Sales_ActiveCustomerDepositCategories
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNumber) && !is_string($referenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceNumber, true), gettype($referenceNumber)), __LINE__);
        }
        if (is_null($referenceNumber) || (is_array($referenceNumber) && empty($referenceNumber))) {
            unset($this->ReferenceNumber);
        } else {
            $this->ReferenceNumber = $referenceNumber;
        }
        return $this;
    }
    /**
     * Get RemainingAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getRemainingAmount()
    {
        return isset($this->RemainingAmount) ? $this->RemainingAmount : null;
    }
    /**
     * Set RemainingAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $remainingAmount
     * @return \patest\StructType\BSRO_Sales_ActiveCustomerDepositCategories
     */
    public function setRemainingAmount($remainingAmount = null)
    {
        // validation for constraint: float
        if (!is_null($remainingAmount) && !(is_float($remainingAmount) || is_numeric($remainingAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($remainingAmount, true), gettype($remainingAmount)), __LINE__);
        }
        if (is_null($remainingAmount) || (is_array($remainingAmount) && empty($remainingAmount))) {
            unset($this->RemainingAmount);
        } else {
            $this->RemainingAmount = $remainingAmount;
        }
        return $this;
    }
}
