<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for bSRO.Payment.PaymentPlanCustomInstallmentSchedule
 * StructType
 * @subpackage Structs
 */
class BSRO_Payment_PaymentPlanCustomInstallmentSchedule extends AnyEntity
{
    /**
     * The InstallmentDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InstallmentDate;
    /**
     * The PastDueMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PastDueMessage;
    /**
     * Constructor method for bSRO.Payment.PaymentPlanCustomInstallmentSchedule
     * @uses BSRO_Payment_PaymentPlanCustomInstallmentSchedule::setInstallmentDate()
     * @uses BSRO_Payment_PaymentPlanCustomInstallmentSchedule::setPastDueMessage()
     * @param string $installmentDate
     * @param string $pastDueMessage
     */
    public function __construct($installmentDate = null, $pastDueMessage = null)
    {
        $this
            ->setInstallmentDate($installmentDate)
            ->setPastDueMessage($pastDueMessage);
    }
    /**
     * Get InstallmentDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstallmentDate()
    {
        return isset($this->InstallmentDate) ? $this->InstallmentDate : null;
    }
    /**
     * Set InstallmentDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $installmentDate
     * @return \patest\StructType\BSRO_Payment_PaymentPlanCustomInstallmentSchedule
     */
    public function setInstallmentDate($installmentDate = null)
    {
        // validation for constraint: string
        if (!is_null($installmentDate) && !is_string($installmentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($installmentDate, true), gettype($installmentDate)), __LINE__);
        }
        if (is_null($installmentDate) || (is_array($installmentDate) && empty($installmentDate))) {
            unset($this->InstallmentDate);
        } else {
            $this->InstallmentDate = $installmentDate;
        }
        return $this;
    }
    /**
     * Get PastDueMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPastDueMessage()
    {
        return isset($this->PastDueMessage) ? $this->PastDueMessage : null;
    }
    /**
     * Set PastDueMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pastDueMessage
     * @return \patest\StructType\BSRO_Payment_PaymentPlanCustomInstallmentSchedule
     */
    public function setPastDueMessage($pastDueMessage = null)
    {
        // validation for constraint: string
        if (!is_null($pastDueMessage) && !is_string($pastDueMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pastDueMessage, true), gettype($pastDueMessage)), __LINE__);
        }
        if (is_null($pastDueMessage) || (is_array($pastDueMessage) && empty($pastDueMessage))) {
            unset($this->PastDueMessage);
        } else {
            $this->PastDueMessage = $pastDueMessage;
        }
        return $this;
    }
}
