<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Authentication.PublicUserAuthenticationData StructType
 * @subpackage Structs
 */
class Authentication_PublicUserAuthenticationData extends PersistableEntity
{
    /**
     * The ConnectorId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ConnectorId;
    /**
     * The ConnectorReferenceId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ConnectorReferenceId;
    /**
     * The ExternalUserId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalUserId;
    /**
     * The IsLocked
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsLocked;
    /**
     * The LockDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LockDateTime;
    /**
     * The LockReason
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LockReason;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The PasswordIsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PasswordIsActive;
    /**
     * The UserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UserId;
    /**
     * The UserLogin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserLogin;
    /**
     * The UserMustChangePassword
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UserMustChangePassword;
    /**
     * The UserType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserType;
    /**
     * Constructor method for Authentication.PublicUserAuthenticationData
     * @uses Authentication_PublicUserAuthenticationData::setConnectorId()
     * @uses Authentication_PublicUserAuthenticationData::setConnectorReferenceId()
     * @uses Authentication_PublicUserAuthenticationData::setExternalUserId()
     * @uses Authentication_PublicUserAuthenticationData::setIsLocked()
     * @uses Authentication_PublicUserAuthenticationData::setLockDateTime()
     * @uses Authentication_PublicUserAuthenticationData::setLockReason()
     * @uses Authentication_PublicUserAuthenticationData::setOrganizationUnitId()
     * @uses Authentication_PublicUserAuthenticationData::setPasswordIsActive()
     * @uses Authentication_PublicUserAuthenticationData::setUserId()
     * @uses Authentication_PublicUserAuthenticationData::setUserLogin()
     * @uses Authentication_PublicUserAuthenticationData::setUserMustChangePassword()
     * @uses Authentication_PublicUserAuthenticationData::setUserType()
     * @param string $connectorId
     * @param string $connectorReferenceId
     * @param string $externalUserId
     * @param bool $isLocked
     * @param string $lockDateTime
     * @param string $lockReason
     * @param string $organizationUnitId
     * @param bool $passwordIsActive
     * @param string $userId
     * @param string $userLogin
     * @param bool $userMustChangePassword
     * @param string $userType
     */
    public function __construct($connectorId = null, $connectorReferenceId = null, $externalUserId = null, $isLocked = null, $lockDateTime = null, $lockReason = null, $organizationUnitId = null, $passwordIsActive = null, $userId = null, $userLogin = null, $userMustChangePassword = null, $userType = null)
    {
        $this
            ->setConnectorId($connectorId)
            ->setConnectorReferenceId($connectorReferenceId)
            ->setExternalUserId($externalUserId)
            ->setIsLocked($isLocked)
            ->setLockDateTime($lockDateTime)
            ->setLockReason($lockReason)
            ->setOrganizationUnitId($organizationUnitId)
            ->setPasswordIsActive($passwordIsActive)
            ->setUserId($userId)
            ->setUserLogin($userLogin)
            ->setUserMustChangePassword($userMustChangePassword)
            ->setUserType($userType);
    }
    /**
     * Get ConnectorId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConnectorId()
    {
        return isset($this->ConnectorId) ? $this->ConnectorId : null;
    }
    /**
     * Set ConnectorId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $connectorId
     * @return \patest\StructType\Authentication_PublicUserAuthenticationData
     */
    public function setConnectorId($connectorId = null)
    {
        // validation for constraint: string
        if (!is_null($connectorId) && !is_string($connectorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($connectorId, true), gettype($connectorId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($connectorId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $connectorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($connectorId, true)), __LINE__);
        }
        if (is_null($connectorId) || (is_array($connectorId) && empty($connectorId))) {
            unset($this->ConnectorId);
        } else {
            $this->ConnectorId = $connectorId;
        }
        return $this;
    }
    /**
     * Get ConnectorReferenceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConnectorReferenceId()
    {
        return isset($this->ConnectorReferenceId) ? $this->ConnectorReferenceId : null;
    }
    /**
     * Set ConnectorReferenceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $connectorReferenceId
     * @return \patest\StructType\Authentication_PublicUserAuthenticationData
     */
    public function setConnectorReferenceId($connectorReferenceId = null)
    {
        // validation for constraint: string
        if (!is_null($connectorReferenceId) && !is_string($connectorReferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($connectorReferenceId, true), gettype($connectorReferenceId)), __LINE__);
        }
        if (is_null($connectorReferenceId) || (is_array($connectorReferenceId) && empty($connectorReferenceId))) {
            unset($this->ConnectorReferenceId);
        } else {
            $this->ConnectorReferenceId = $connectorReferenceId;
        }
        return $this;
    }
    /**
     * Get ExternalUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalUserId()
    {
        return isset($this->ExternalUserId) ? $this->ExternalUserId : null;
    }
    /**
     * Set ExternalUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalUserId
     * @return \patest\StructType\Authentication_PublicUserAuthenticationData
     */
    public function setExternalUserId($externalUserId = null)
    {
        // validation for constraint: string
        if (!is_null($externalUserId) && !is_string($externalUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalUserId, true), gettype($externalUserId)), __LINE__);
        }
        if (is_null($externalUserId) || (is_array($externalUserId) && empty($externalUserId))) {
            unset($this->ExternalUserId);
        } else {
            $this->ExternalUserId = $externalUserId;
        }
        return $this;
    }
    /**
     * Get IsLocked value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsLocked()
    {
        return isset($this->IsLocked) ? $this->IsLocked : null;
    }
    /**
     * Set IsLocked value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isLocked
     * @return \patest\StructType\Authentication_PublicUserAuthenticationData
     */
    public function setIsLocked($isLocked = null)
    {
        // validation for constraint: boolean
        if (!is_null($isLocked) && !is_bool($isLocked)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isLocked, true), gettype($isLocked)), __LINE__);
        }
        if (is_null($isLocked) || (is_array($isLocked) && empty($isLocked))) {
            unset($this->IsLocked);
        } else {
            $this->IsLocked = $isLocked;
        }
        return $this;
    }
    /**
     * Get LockDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLockDateTime()
    {
        return isset($this->LockDateTime) ? $this->LockDateTime : null;
    }
    /**
     * Set LockDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lockDateTime
     * @return \patest\StructType\Authentication_PublicUserAuthenticationData
     */
    public function setLockDateTime($lockDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($lockDateTime) && !is_string($lockDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lockDateTime, true), gettype($lockDateTime)), __LINE__);
        }
        if (is_null($lockDateTime) || (is_array($lockDateTime) && empty($lockDateTime))) {
            unset($this->LockDateTime);
        } else {
            $this->LockDateTime = $lockDateTime;
        }
        return $this;
    }
    /**
     * Get LockReason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLockReason()
    {
        return isset($this->LockReason) ? $this->LockReason : null;
    }
    /**
     * Set LockReason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lockReason
     * @return \patest\StructType\Authentication_PublicUserAuthenticationData
     */
    public function setLockReason($lockReason = null)
    {
        // validation for constraint: string
        if (!is_null($lockReason) && !is_string($lockReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lockReason, true), gettype($lockReason)), __LINE__);
        }
        if (is_null($lockReason) || (is_array($lockReason) && empty($lockReason))) {
            unset($this->LockReason);
        } else {
            $this->LockReason = $lockReason;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Authentication_PublicUserAuthenticationData
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get PasswordIsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPasswordIsActive()
    {
        return isset($this->PasswordIsActive) ? $this->PasswordIsActive : null;
    }
    /**
     * Set PasswordIsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $passwordIsActive
     * @return \patest\StructType\Authentication_PublicUserAuthenticationData
     */
    public function setPasswordIsActive($passwordIsActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($passwordIsActive) && !is_bool($passwordIsActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($passwordIsActive, true), gettype($passwordIsActive)), __LINE__);
        }
        if (is_null($passwordIsActive) || (is_array($passwordIsActive) && empty($passwordIsActive))) {
            unset($this->PasswordIsActive);
        } else {
            $this->PasswordIsActive = $passwordIsActive;
        }
        return $this;
    }
    /**
     * Get UserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserId()
    {
        return isset($this->UserId) ? $this->UserId : null;
    }
    /**
     * Set UserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userId
     * @return \patest\StructType\Authentication_PublicUserAuthenticationData
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($userId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($userId, true)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->UserId);
        } else {
            $this->UserId = $userId;
        }
        return $this;
    }
    /**
     * Get UserLogin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserLogin()
    {
        return isset($this->UserLogin) ? $this->UserLogin : null;
    }
    /**
     * Set UserLogin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userLogin
     * @return \patest\StructType\Authentication_PublicUserAuthenticationData
     */
    public function setUserLogin($userLogin = null)
    {
        // validation for constraint: string
        if (!is_null($userLogin) && !is_string($userLogin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userLogin, true), gettype($userLogin)), __LINE__);
        }
        if (is_null($userLogin) || (is_array($userLogin) && empty($userLogin))) {
            unset($this->UserLogin);
        } else {
            $this->UserLogin = $userLogin;
        }
        return $this;
    }
    /**
     * Get UserMustChangePassword value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUserMustChangePassword()
    {
        return isset($this->UserMustChangePassword) ? $this->UserMustChangePassword : null;
    }
    /**
     * Set UserMustChangePassword value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $userMustChangePassword
     * @return \patest\StructType\Authentication_PublicUserAuthenticationData
     */
    public function setUserMustChangePassword($userMustChangePassword = null)
    {
        // validation for constraint: boolean
        if (!is_null($userMustChangePassword) && !is_bool($userMustChangePassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($userMustChangePassword, true), gettype($userMustChangePassword)), __LINE__);
        }
        if (is_null($userMustChangePassword) || (is_array($userMustChangePassword) && empty($userMustChangePassword))) {
            unset($this->UserMustChangePassword);
        } else {
            $this->UserMustChangePassword = $userMustChangePassword;
        }
        return $this;
    }
    /**
     * Get UserType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserType()
    {
        return isset($this->UserType) ? $this->UserType : null;
    }
    /**
     * Set UserType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userType
     * @return \patest\StructType\Authentication_PublicUserAuthenticationData
     */
    public function setUserType($userType = null)
    {
        // validation for constraint: string
        if (!is_null($userType) && !is_string($userType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userType, true), gettype($userType)), __LINE__);
        }
        if (is_null($userType) || (is_array($userType) && empty($userType))) {
            unset($this->UserType);
        } else {
            $this->UserType = $userType;
        }
        return $this;
    }
}
