<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AttachTicketSchemeFulfillmentToExistingReservation-Request
 * StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AttachTicketSchemeFulfillmentToExistingReservation-Request
 * @subpackage Structs
 */
class AttachTicketSchemeFulfillmentToExistingReservation_Request extends ExtensibleDataContract
{
    /**
     * The FulfillmentId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $FulfillmentId;
    /**
     * The TicketId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TicketId;
    /**
     * Constructor method for
     * AttachTicketSchemeFulfillmentToExistingReservation-Request
     * @uses AttachTicketSchemeFulfillmentToExistingReservation_Request::setFulfillmentId()
     * @uses AttachTicketSchemeFulfillmentToExistingReservation_Request::setTicketId()
     * @param string $fulfillmentId
     * @param string $ticketId
     */
    public function __construct($fulfillmentId = null, $ticketId = null)
    {
        $this
            ->setFulfillmentId($fulfillmentId)
            ->setTicketId($ticketId);
    }
    /**
     * Get FulfillmentId value
     * @return string|null
     */
    public function getFulfillmentId()
    {
        return $this->FulfillmentId;
    }
    /**
     * Set FulfillmentId value
     * @param string $fulfillmentId
     * @return \patest\StructType\AttachTicketSchemeFulfillmentToExistingReservation_Request
     */
    public function setFulfillmentId($fulfillmentId = null)
    {
        // validation for constraint: string
        if (!is_null($fulfillmentId) && !is_string($fulfillmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fulfillmentId, true), gettype($fulfillmentId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($fulfillmentId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $fulfillmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($fulfillmentId, true)), __LINE__);
        }
        $this->FulfillmentId = $fulfillmentId;
        return $this;
    }
    /**
     * Get TicketId value
     * @return string|null
     */
    public function getTicketId()
    {
        return $this->TicketId;
    }
    /**
     * Set TicketId value
     * @param string $ticketId
     * @return \patest\StructType\AttachTicketSchemeFulfillmentToExistingReservation_Request
     */
    public function setTicketId($ticketId = null)
    {
        // validation for constraint: string
        if (!is_null($ticketId) && !is_string($ticketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketId, true), gettype($ticketId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ticketId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ticketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ticketId, true)), __LINE__);
        }
        $this->TicketId = $ticketId;
        return $this;
    }
}
