<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AreaSeatsProperties StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AreaSeatsProperties
 * @subpackage Structs
 */
class AreaSeatsProperties extends AbstractStructBase
{
    /**
     * The SeatCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SeatCount;
    /**
     * The SeatIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SerializedSeatsPropertyValuesInt
     */
    public $SeatIds;
    /**
     * The SeatProperties
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfSeatPropertyNamesSerializedSeatsPropertyValuesn51wGZ5l
     */
    public $SeatProperties;
    /**
     * Constructor method for AreaSeatsProperties
     * @uses AreaSeatsProperties::setSeatCount()
     * @uses AreaSeatsProperties::setSeatIds()
     * @uses AreaSeatsProperties::setSeatProperties()
     * @param int $seatCount
     * @param \patest\StructType\SerializedSeatsPropertyValuesInt $seatIds
     * @param \patest\ArrayType\ArrayOfKeyValueOfSeatPropertyNamesSerializedSeatsPropertyValuesn51wGZ5l $seatProperties
     */
    public function __construct($seatCount = null, \patest\StructType\SerializedSeatsPropertyValuesInt $seatIds = null, \patest\ArrayType\ArrayOfKeyValueOfSeatPropertyNamesSerializedSeatsPropertyValuesn51wGZ5l $seatProperties = null)
    {
        $this
            ->setSeatCount($seatCount)
            ->setSeatIds($seatIds)
            ->setSeatProperties($seatProperties);
    }
    /**
     * Get SeatCount value
     * @return int|null
     */
    public function getSeatCount()
    {
        return $this->SeatCount;
    }
    /**
     * Set SeatCount value
     * @param int $seatCount
     * @return \patest\StructType\AreaSeatsProperties
     */
    public function setSeatCount($seatCount = null)
    {
        // validation for constraint: int
        if (!is_null($seatCount) && !(is_int($seatCount) || ctype_digit($seatCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatCount, true), gettype($seatCount)), __LINE__);
        }
        $this->SeatCount = $seatCount;
        return $this;
    }
    /**
     * Get SeatIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SerializedSeatsPropertyValuesInt|null
     */
    public function getSeatIds()
    {
        return isset($this->SeatIds) ? $this->SeatIds : null;
    }
    /**
     * Set SeatIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SerializedSeatsPropertyValuesInt $seatIds
     * @return \patest\StructType\AreaSeatsProperties
     */
    public function setSeatIds(\patest\StructType\SerializedSeatsPropertyValuesInt $seatIds = null)
    {
        if (is_null($seatIds) || (is_array($seatIds) && empty($seatIds))) {
            unset($this->SeatIds);
        } else {
            $this->SeatIds = $seatIds;
        }
        return $this;
    }
    /**
     * Get SeatProperties value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfSeatPropertyNamesSerializedSeatsPropertyValuesn51wGZ5l|null
     */
    public function getSeatProperties()
    {
        return isset($this->SeatProperties) ? $this->SeatProperties : null;
    }
    /**
     * Set SeatProperties value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfSeatPropertyNamesSerializedSeatsPropertyValuesn51wGZ5l $seatProperties
     * @return \patest\StructType\AreaSeatsProperties
     */
    public function setSeatProperties(\patest\ArrayType\ArrayOfKeyValueOfSeatPropertyNamesSerializedSeatsPropertyValuesn51wGZ5l $seatProperties = null)
    {
        if (is_null($seatProperties) || (is_array($seatProperties) && empty($seatProperties))) {
            unset($this->SeatProperties);
        } else {
            $this->SeatProperties = $seatProperties;
        }
        return $this;
    }
}
