<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AreaLayerSettings StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AreaLayerSettings
 * @subpackage Structs
 */
class AreaLayerSettings extends AbstractStructBase
{
    /**
     * The Action
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Action;
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * Constructor method for AreaLayerSettings
     * @uses AreaLayerSettings::setAction()
     * @uses AreaLayerSettings::setAreaId()
     * @param string $action
     * @param string $areaId
     */
    public function __construct($action = null, $areaId = null)
    {
        $this
            ->setAction($action)
            ->setAreaId($areaId);
    }
    /**
     * Get Action value
     * @return string|null
     */
    public function getAction()
    {
        return $this->Action;
    }
    /**
     * Set Action value
     * @uses \patest\EnumType\LayerApplyAction::valueIsValid()
     * @uses \patest\EnumType\LayerApplyAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $action
     * @return \patest\StructType\AreaLayerSettings
     */
    public function setAction($action = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\LayerApplyAction::valueIsValid($action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\LayerApplyAction', is_array($action) ? implode(', ', $action) : var_export($action, true), implode(', ', \patest\EnumType\LayerApplyAction::getValidValues())), __LINE__);
        }
        $this->Action = $action;
        return $this;
    }
    /**
     * Get AreaId value
     * @return string|null
     */
    public function getAreaId()
    {
        return $this->AreaId;
    }
    /**
     * Set AreaId value
     * @param string $areaId
     * @return \patest\StructType\AreaLayerSettings
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        $this->AreaId = $areaId;
        return $this;
    }
}
