<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ApplyLayer-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ApplyLayer-Request
 * @subpackage Structs
 */
class ApplyLayer_Request extends ExtensibleDataContract
{
    /**
     * The EventGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventGuid;
    /**
     * The HallVersionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallVersionGuid;
    /**
     * The LayerSettings
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfAreaLayerSettings
     */
    public $LayerSettings;
    /**
     * The ShowGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ShowGuid;
    /**
     * The SeatingPlanGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeatingPlanGuid;
    /**
     * The ApplyToAllRelatedHallVersions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ApplyToAllRelatedHallVersions;
    /**
     * The AreaMapId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaMapId;
    /**
     * The ShouldCheckMatchingRestrictionsWithChildEntities
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ShouldCheckMatchingRestrictionsWithChildEntities;
    /**
     * The ForceUpdateSeatsOnAreaLayer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ForceUpdateSeatsOnAreaLayer;
    /**
     * Constructor method for ApplyLayer-Request
     * @uses ApplyLayer_Request::setEventGuid()
     * @uses ApplyLayer_Request::setHallVersionGuid()
     * @uses ApplyLayer_Request::setLayerSettings()
     * @uses ApplyLayer_Request::setShowGuid()
     * @uses ApplyLayer_Request::setSeatingPlanGuid()
     * @uses ApplyLayer_Request::setApplyToAllRelatedHallVersions()
     * @uses ApplyLayer_Request::setAreaMapId()
     * @uses ApplyLayer_Request::setShouldCheckMatchingRestrictionsWithChildEntities()
     * @uses ApplyLayer_Request::setForceUpdateSeatsOnAreaLayer()
     * @param string $eventGuid
     * @param string $hallVersionGuid
     * @param \patest\ArrayType\ArrayOfAreaLayerSettings $layerSettings
     * @param string $showGuid
     * @param string $seatingPlanGuid
     * @param bool $applyToAllRelatedHallVersions
     * @param string $areaMapId
     * @param bool $shouldCheckMatchingRestrictionsWithChildEntities
     * @param bool $forceUpdateSeatsOnAreaLayer
     */
    public function __construct($eventGuid = null, $hallVersionGuid = null, \patest\ArrayType\ArrayOfAreaLayerSettings $layerSettings = null, $showGuid = null, $seatingPlanGuid = null, $applyToAllRelatedHallVersions = null, $areaMapId = null, $shouldCheckMatchingRestrictionsWithChildEntities = null, $forceUpdateSeatsOnAreaLayer = null)
    {
        $this
            ->setEventGuid($eventGuid)
            ->setHallVersionGuid($hallVersionGuid)
            ->setLayerSettings($layerSettings)
            ->setShowGuid($showGuid)
            ->setSeatingPlanGuid($seatingPlanGuid)
            ->setApplyToAllRelatedHallVersions($applyToAllRelatedHallVersions)
            ->setAreaMapId($areaMapId)
            ->setShouldCheckMatchingRestrictionsWithChildEntities($shouldCheckMatchingRestrictionsWithChildEntities)
            ->setForceUpdateSeatsOnAreaLayer($forceUpdateSeatsOnAreaLayer);
    }
    /**
     * Get EventGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventGuid()
    {
        return isset($this->EventGuid) ? $this->EventGuid : null;
    }
    /**
     * Set EventGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventGuid
     * @return \patest\StructType\ApplyLayer_Request
     */
    public function setEventGuid($eventGuid = null)
    {
        // validation for constraint: string
        if (!is_null($eventGuid) && !is_string($eventGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventGuid, true), gettype($eventGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventGuid, true)), __LINE__);
        }
        if (is_null($eventGuid) || (is_array($eventGuid) && empty($eventGuid))) {
            unset($this->EventGuid);
        } else {
            $this->EventGuid = $eventGuid;
        }
        return $this;
    }
    /**
     * Get HallVersionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallVersionGuid()
    {
        return isset($this->HallVersionGuid) ? $this->HallVersionGuid : null;
    }
    /**
     * Set HallVersionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallVersionGuid
     * @return \patest\StructType\ApplyLayer_Request
     */
    public function setHallVersionGuid($hallVersionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($hallVersionGuid) && !is_string($hallVersionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallVersionGuid, true), gettype($hallVersionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallVersionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallVersionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallVersionGuid, true)), __LINE__);
        }
        if (is_null($hallVersionGuid) || (is_array($hallVersionGuid) && empty($hallVersionGuid))) {
            unset($this->HallVersionGuid);
        } else {
            $this->HallVersionGuid = $hallVersionGuid;
        }
        return $this;
    }
    /**
     * Get LayerSettings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfAreaLayerSettings|null
     */
    public function getLayerSettings()
    {
        return isset($this->LayerSettings) ? $this->LayerSettings : null;
    }
    /**
     * Set LayerSettings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfAreaLayerSettings $layerSettings
     * @return \patest\StructType\ApplyLayer_Request
     */
    public function setLayerSettings(\patest\ArrayType\ArrayOfAreaLayerSettings $layerSettings = null)
    {
        if (is_null($layerSettings) || (is_array($layerSettings) && empty($layerSettings))) {
            unset($this->LayerSettings);
        } else {
            $this->LayerSettings = $layerSettings;
        }
        return $this;
    }
    /**
     * Get ShowGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowGuid()
    {
        return isset($this->ShowGuid) ? $this->ShowGuid : null;
    }
    /**
     * Set ShowGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showGuid
     * @return \patest\StructType\ApplyLayer_Request
     */
    public function setShowGuid($showGuid = null)
    {
        // validation for constraint: string
        if (!is_null($showGuid) && !is_string($showGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showGuid, true), gettype($showGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($showGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $showGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($showGuid, true)), __LINE__);
        }
        if (is_null($showGuid) || (is_array($showGuid) && empty($showGuid))) {
            unset($this->ShowGuid);
        } else {
            $this->ShowGuid = $showGuid;
        }
        return $this;
    }
    /**
     * Get SeatingPlanGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatingPlanGuid()
    {
        return isset($this->SeatingPlanGuid) ? $this->SeatingPlanGuid : null;
    }
    /**
     * Set SeatingPlanGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatingPlanGuid
     * @return \patest\StructType\ApplyLayer_Request
     */
    public function setSeatingPlanGuid($seatingPlanGuid = null)
    {
        // validation for constraint: string
        if (!is_null($seatingPlanGuid) && !is_string($seatingPlanGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatingPlanGuid, true), gettype($seatingPlanGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seatingPlanGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seatingPlanGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seatingPlanGuid, true)), __LINE__);
        }
        if (is_null($seatingPlanGuid) || (is_array($seatingPlanGuid) && empty($seatingPlanGuid))) {
            unset($this->SeatingPlanGuid);
        } else {
            $this->SeatingPlanGuid = $seatingPlanGuid;
        }
        return $this;
    }
    /**
     * Get ApplyToAllRelatedHallVersions value
     * @return bool|null
     */
    public function getApplyToAllRelatedHallVersions()
    {
        return $this->ApplyToAllRelatedHallVersions;
    }
    /**
     * Set ApplyToAllRelatedHallVersions value
     * @param bool $applyToAllRelatedHallVersions
     * @return \patest\StructType\ApplyLayer_Request
     */
    public function setApplyToAllRelatedHallVersions($applyToAllRelatedHallVersions = null)
    {
        // validation for constraint: boolean
        if (!is_null($applyToAllRelatedHallVersions) && !is_bool($applyToAllRelatedHallVersions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($applyToAllRelatedHallVersions, true), gettype($applyToAllRelatedHallVersions)), __LINE__);
        }
        $this->ApplyToAllRelatedHallVersions = $applyToAllRelatedHallVersions;
        return $this;
    }
    /**
     * Get AreaMapId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaMapId()
    {
        return isset($this->AreaMapId) ? $this->AreaMapId : null;
    }
    /**
     * Set AreaMapId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaMapId
     * @return \patest\StructType\ApplyLayer_Request
     */
    public function setAreaMapId($areaMapId = null)
    {
        // validation for constraint: string
        if (!is_null($areaMapId) && !is_string($areaMapId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaMapId, true), gettype($areaMapId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaMapId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaMapId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaMapId, true)), __LINE__);
        }
        if (is_null($areaMapId) || (is_array($areaMapId) && empty($areaMapId))) {
            unset($this->AreaMapId);
        } else {
            $this->AreaMapId = $areaMapId;
        }
        return $this;
    }
    /**
     * Get ShouldCheckMatchingRestrictionsWithChildEntities value
     * @return bool|null
     */
    public function getShouldCheckMatchingRestrictionsWithChildEntities()
    {
        return $this->ShouldCheckMatchingRestrictionsWithChildEntities;
    }
    /**
     * Set ShouldCheckMatchingRestrictionsWithChildEntities value
     * @param bool $shouldCheckMatchingRestrictionsWithChildEntities
     * @return \patest\StructType\ApplyLayer_Request
     */
    public function setShouldCheckMatchingRestrictionsWithChildEntities($shouldCheckMatchingRestrictionsWithChildEntities = null)
    {
        // validation for constraint: boolean
        if (!is_null($shouldCheckMatchingRestrictionsWithChildEntities) && !is_bool($shouldCheckMatchingRestrictionsWithChildEntities)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($shouldCheckMatchingRestrictionsWithChildEntities, true), gettype($shouldCheckMatchingRestrictionsWithChildEntities)), __LINE__);
        }
        $this->ShouldCheckMatchingRestrictionsWithChildEntities = $shouldCheckMatchingRestrictionsWithChildEntities;
        return $this;
    }
    /**
     * Get ForceUpdateSeatsOnAreaLayer value
     * @return bool|null
     */
    public function getForceUpdateSeatsOnAreaLayer()
    {
        return $this->ForceUpdateSeatsOnAreaLayer;
    }
    /**
     * Set ForceUpdateSeatsOnAreaLayer value
     * @param bool $forceUpdateSeatsOnAreaLayer
     * @return \patest\StructType\ApplyLayer_Request
     */
    public function setForceUpdateSeatsOnAreaLayer($forceUpdateSeatsOnAreaLayer = null)
    {
        // validation for constraint: boolean
        if (!is_null($forceUpdateSeatsOnAreaLayer) && !is_bool($forceUpdateSeatsOnAreaLayer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($forceUpdateSeatsOnAreaLayer, true), gettype($forceUpdateSeatsOnAreaLayer)), __LINE__);
        }
        $this->ForceUpdateSeatsOnAreaLayer = $forceUpdateSeatsOnAreaLayer;
        return $this;
    }
}
