<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ApplyChangeToPaymentPlanInstallments-Response StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ApplyChangeToPaymentPlanInstallments-Response
 * @subpackage Structs
 */
class ApplyChangeToPaymentPlanInstallments_Response extends AbstractStructBase
{
    /**
     * The InstallmentItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfInstallmentItem
     */
    public $InstallmentItems;
    /**
     * The OrderOfAffectedInstallment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $OrderOfAffectedInstallment;
    /**
     * Constructor method for ApplyChangeToPaymentPlanInstallments-Response
     * @uses ApplyChangeToPaymentPlanInstallments_Response::setInstallmentItems()
     * @uses ApplyChangeToPaymentPlanInstallments_Response::setOrderOfAffectedInstallment()
     * @param \patest\ArrayType\ArrayOfInstallmentItem $installmentItems
     * @param int $orderOfAffectedInstallment
     */
    public function __construct(\patest\ArrayType\ArrayOfInstallmentItem $installmentItems = null, $orderOfAffectedInstallment = null)
    {
        $this
            ->setInstallmentItems($installmentItems)
            ->setOrderOfAffectedInstallment($orderOfAffectedInstallment);
    }
    /**
     * Get InstallmentItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfInstallmentItem|null
     */
    public function getInstallmentItems()
    {
        return isset($this->InstallmentItems) ? $this->InstallmentItems : null;
    }
    /**
     * Set InstallmentItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfInstallmentItem $installmentItems
     * @return \patest\StructType\ApplyChangeToPaymentPlanInstallments_Response
     */
    public function setInstallmentItems(\patest\ArrayType\ArrayOfInstallmentItem $installmentItems = null)
    {
        if (is_null($installmentItems) || (is_array($installmentItems) && empty($installmentItems))) {
            unset($this->InstallmentItems);
        } else {
            $this->InstallmentItems = $installmentItems;
        }
        return $this;
    }
    /**
     * Get OrderOfAffectedInstallment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrderOfAffectedInstallment()
    {
        return isset($this->OrderOfAffectedInstallment) ? $this->OrderOfAffectedInstallment : null;
    }
    /**
     * Set OrderOfAffectedInstallment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $orderOfAffectedInstallment
     * @return \patest\StructType\ApplyChangeToPaymentPlanInstallments_Response
     */
    public function setOrderOfAffectedInstallment($orderOfAffectedInstallment = null)
    {
        // validation for constraint: int
        if (!is_null($orderOfAffectedInstallment) && !(is_int($orderOfAffectedInstallment) || ctype_digit($orderOfAffectedInstallment))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderOfAffectedInstallment, true), gettype($orderOfAffectedInstallment)), __LINE__);
        }
        if (is_null($orderOfAffectedInstallment) || (is_array($orderOfAffectedInstallment) && empty($orderOfAffectedInstallment))) {
            unset($this->OrderOfAffectedInstallment);
        } else {
            $this->OrderOfAffectedInstallment = $orderOfAffectedInstallment;
        }
        return $this;
    }
}
