<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Any.ImageMedia StructType
 * @subpackage Structs
 */
class Any_ImageMedia extends PersistableEntity
{
    /**
     * The EffectiveImageUrl
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EffectiveImageUrl;
    /**
     * The ImageId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ImageId;
    /**
     * The ImageName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ImageName;
    /**
     * The ImagePurpose
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ImagePurpose;
    /**
     * The ImageUrl
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ImageUrl;
    /**
     * The MediaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MediaId;
    /**
     * The SystemName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemName;
    /**
     * Constructor method for Any.ImageMedia
     * @uses Any_ImageMedia::setEffectiveImageUrl()
     * @uses Any_ImageMedia::setImageId()
     * @uses Any_ImageMedia::setImageName()
     * @uses Any_ImageMedia::setImagePurpose()
     * @uses Any_ImageMedia::setImageUrl()
     * @uses Any_ImageMedia::setMediaId()
     * @uses Any_ImageMedia::setSystemName()
     * @param string $effectiveImageUrl
     * @param int $imageId
     * @param string $imageName
     * @param string $imagePurpose
     * @param string $imageUrl
     * @param string $mediaId
     * @param string $systemName
     */
    public function __construct($effectiveImageUrl = null, $imageId = null, $imageName = null, $imagePurpose = null, $imageUrl = null, $mediaId = null, $systemName = null)
    {
        $this
            ->setEffectiveImageUrl($effectiveImageUrl)
            ->setImageId($imageId)
            ->setImageName($imageName)
            ->setImagePurpose($imagePurpose)
            ->setImageUrl($imageUrl)
            ->setMediaId($mediaId)
            ->setSystemName($systemName);
    }
    /**
     * Get EffectiveImageUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEffectiveImageUrl()
    {
        return isset($this->EffectiveImageUrl) ? $this->EffectiveImageUrl : null;
    }
    /**
     * Set EffectiveImageUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $effectiveImageUrl
     * @return \patest\StructType\Any_ImageMedia
     */
    public function setEffectiveImageUrl($effectiveImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveImageUrl) && !is_string($effectiveImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveImageUrl, true), gettype($effectiveImageUrl)), __LINE__);
        }
        if (is_null($effectiveImageUrl) || (is_array($effectiveImageUrl) && empty($effectiveImageUrl))) {
            unset($this->EffectiveImageUrl);
        } else {
            $this->EffectiveImageUrl = $effectiveImageUrl;
        }
        return $this;
    }
    /**
     * Get ImageId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getImageId()
    {
        return isset($this->ImageId) ? $this->ImageId : null;
    }
    /**
     * Set ImageId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $imageId
     * @return \patest\StructType\Any_ImageMedia
     */
    public function setImageId($imageId = null)
    {
        // validation for constraint: int
        if (!is_null($imageId) && !(is_int($imageId) || ctype_digit($imageId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($imageId, true), gettype($imageId)), __LINE__);
        }
        if (is_null($imageId) || (is_array($imageId) && empty($imageId))) {
            unset($this->ImageId);
        } else {
            $this->ImageId = $imageId;
        }
        return $this;
    }
    /**
     * Get ImageName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImageName()
    {
        return isset($this->ImageName) ? $this->ImageName : null;
    }
    /**
     * Set ImageName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $imageName
     * @return \patest\StructType\Any_ImageMedia
     */
    public function setImageName($imageName = null)
    {
        // validation for constraint: string
        if (!is_null($imageName) && !is_string($imageName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($imageName, true), gettype($imageName)), __LINE__);
        }
        if (is_null($imageName) || (is_array($imageName) && empty($imageName))) {
            unset($this->ImageName);
        } else {
            $this->ImageName = $imageName;
        }
        return $this;
    }
    /**
     * Get ImagePurpose value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImagePurpose()
    {
        return isset($this->ImagePurpose) ? $this->ImagePurpose : null;
    }
    /**
     * Set ImagePurpose value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ImagePurpose::valueIsValid()
     * @uses \patest\EnumType\ImagePurpose::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $imagePurpose
     * @return \patest\StructType\Any_ImageMedia
     */
    public function setImagePurpose($imagePurpose = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ImagePurpose::valueIsValid($imagePurpose)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ImagePurpose', is_array($imagePurpose) ? implode(', ', $imagePurpose) : var_export($imagePurpose, true), implode(', ', \patest\EnumType\ImagePurpose::getValidValues())), __LINE__);
        }
        if (is_null($imagePurpose) || (is_array($imagePurpose) && empty($imagePurpose))) {
            unset($this->ImagePurpose);
        } else {
            $this->ImagePurpose = $imagePurpose;
        }
        return $this;
    }
    /**
     * Get ImageUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImageUrl()
    {
        return isset($this->ImageUrl) ? $this->ImageUrl : null;
    }
    /**
     * Set ImageUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $imageUrl
     * @return \patest\StructType\Any_ImageMedia
     */
    public function setImageUrl($imageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($imageUrl) && !is_string($imageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($imageUrl, true), gettype($imageUrl)), __LINE__);
        }
        if (is_null($imageUrl) || (is_array($imageUrl) && empty($imageUrl))) {
            unset($this->ImageUrl);
        } else {
            $this->ImageUrl = $imageUrl;
        }
        return $this;
    }
    /**
     * Get MediaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMediaId()
    {
        return isset($this->MediaId) ? $this->MediaId : null;
    }
    /**
     * Set MediaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mediaId
     * @return \patest\StructType\Any_ImageMedia
     */
    public function setMediaId($mediaId = null)
    {
        // validation for constraint: string
        if (!is_null($mediaId) && !is_string($mediaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mediaId, true), gettype($mediaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($mediaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $mediaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($mediaId, true)), __LINE__);
        }
        if (is_null($mediaId) || (is_array($mediaId) && empty($mediaId))) {
            unset($this->MediaId);
        } else {
            $this->MediaId = $mediaId;
        }
        return $this;
    }
    /**
     * Get SystemName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemName()
    {
        return isset($this->SystemName) ? $this->SystemName : null;
    }
    /**
     * Set SystemName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemName
     * @return \patest\StructType\Any_ImageMedia
     */
    public function setSystemName($systemName = null)
    {
        // validation for constraint: string
        if (!is_null($systemName) && !is_string($systemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemName, true), gettype($systemName)), __LINE__);
        }
        if (is_null($systemName) || (is_array($systemName) && empty($systemName))) {
            unset($this->SystemName);
        } else {
            $this->SystemName = $systemName;
        }
        return $this;
    }
}
