<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Any.ExternalSystemIdentityHelper StructType
 * @subpackage Structs
 */
class Any_ExternalSystemIdentityHelper extends PersistableEntity
{
    /**
     * The Identifier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Identifier;
    /**
     * The SroEntityId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SroEntityId;
    /**
     * Constructor method for Any.ExternalSystemIdentityHelper
     * @uses Any_ExternalSystemIdentityHelper::setIdentifier()
     * @uses Any_ExternalSystemIdentityHelper::setSroEntityId()
     * @param string $identifier
     * @param string $sroEntityId
     */
    public function __construct($identifier = null, $sroEntityId = null)
    {
        $this
            ->setIdentifier($identifier)
            ->setSroEntityId($sroEntityId);
    }
    /**
     * Get Identifier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdentifier()
    {
        return isset($this->Identifier) ? $this->Identifier : null;
    }
    /**
     * Set Identifier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $identifier
     * @return \patest\StructType\Any_ExternalSystemIdentityHelper
     */
    public function setIdentifier($identifier = null)
    {
        // validation for constraint: string
        if (!is_null($identifier) && !is_string($identifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identifier, true), gettype($identifier)), __LINE__);
        }
        if (is_null($identifier) || (is_array($identifier) && empty($identifier))) {
            unset($this->Identifier);
        } else {
            $this->Identifier = $identifier;
        }
        return $this;
    }
    /**
     * Get SroEntityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSroEntityId()
    {
        return isset($this->SroEntityId) ? $this->SroEntityId : null;
    }
    /**
     * Set SroEntityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sroEntityId
     * @return \patest\StructType\Any_ExternalSystemIdentityHelper
     */
    public function setSroEntityId($sroEntityId = null)
    {
        // validation for constraint: string
        if (!is_null($sroEntityId) && !is_string($sroEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sroEntityId, true), gettype($sroEntityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sroEntityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sroEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sroEntityId, true)), __LINE__);
        }
        if (is_null($sroEntityId) || (is_array($sroEntityId) && empty($sroEntityId))) {
            unset($this->SroEntityId);
        } else {
            $this->SroEntityId = $sroEntityId;
        }
        return $this;
    }
}
