<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Any.ExplicitAcl StructType
 * @subpackage Structs
 */
class Any_ExplicitAcl extends PersistableEntity
{
    /**
     * The AclSchemeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AclSchemeId;
    /**
     * The BusinessFlow
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BusinessFlow;
    /**
     * The IsAccessAllowed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAccessAllowed;
    /**
     * The SecurityTokenId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SecurityTokenId;
    /**
     * Constructor method for Any.ExplicitAcl
     * @uses Any_ExplicitAcl::setAclSchemeId()
     * @uses Any_ExplicitAcl::setBusinessFlow()
     * @uses Any_ExplicitAcl::setIsAccessAllowed()
     * @uses Any_ExplicitAcl::setSecurityTokenId()
     * @param int $aclSchemeId
     * @param string $businessFlow
     * @param bool $isAccessAllowed
     * @param string $securityTokenId
     */
    public function __construct($aclSchemeId = null, $businessFlow = null, $isAccessAllowed = null, $securityTokenId = null)
    {
        $this
            ->setAclSchemeId($aclSchemeId)
            ->setBusinessFlow($businessFlow)
            ->setIsAccessAllowed($isAccessAllowed)
            ->setSecurityTokenId($securityTokenId);
    }
    /**
     * Get AclSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAclSchemeId()
    {
        return isset($this->AclSchemeId) ? $this->AclSchemeId : null;
    }
    /**
     * Set AclSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aclSchemeId
     * @return \patest\StructType\Any_ExplicitAcl
     */
    public function setAclSchemeId($aclSchemeId = null)
    {
        // validation for constraint: int
        if (!is_null($aclSchemeId) && !(is_int($aclSchemeId) || ctype_digit($aclSchemeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aclSchemeId, true), gettype($aclSchemeId)), __LINE__);
        }
        if (is_null($aclSchemeId) || (is_array($aclSchemeId) && empty($aclSchemeId))) {
            unset($this->AclSchemeId);
        } else {
            $this->AclSchemeId = $aclSchemeId;
        }
        return $this;
    }
    /**
     * Get BusinessFlow value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBusinessFlow()
    {
        return isset($this->BusinessFlow) ? $this->BusinessFlow : null;
    }
    /**
     * Set BusinessFlow value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $businessFlow
     * @return \patest\StructType\Any_ExplicitAcl
     */
    public function setBusinessFlow($businessFlow = null)
    {
        // validation for constraint: string
        if (!is_null($businessFlow) && !is_string($businessFlow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($businessFlow, true), gettype($businessFlow)), __LINE__);
        }
        if (is_null($businessFlow) || (is_array($businessFlow) && empty($businessFlow))) {
            unset($this->BusinessFlow);
        } else {
            $this->BusinessFlow = $businessFlow;
        }
        return $this;
    }
    /**
     * Get IsAccessAllowed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAccessAllowed()
    {
        return isset($this->IsAccessAllowed) ? $this->IsAccessAllowed : null;
    }
    /**
     * Set IsAccessAllowed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAccessAllowed
     * @return \patest\StructType\Any_ExplicitAcl
     */
    public function setIsAccessAllowed($isAccessAllowed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAccessAllowed) && !is_bool($isAccessAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAccessAllowed, true), gettype($isAccessAllowed)), __LINE__);
        }
        if (is_null($isAccessAllowed) || (is_array($isAccessAllowed) && empty($isAccessAllowed))) {
            unset($this->IsAccessAllowed);
        } else {
            $this->IsAccessAllowed = $isAccessAllowed;
        }
        return $this;
    }
    /**
     * Get SecurityTokenId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecurityTokenId()
    {
        return isset($this->SecurityTokenId) ? $this->SecurityTokenId : null;
    }
    /**
     * Set SecurityTokenId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $securityTokenId
     * @return \patest\StructType\Any_ExplicitAcl
     */
    public function setSecurityTokenId($securityTokenId = null)
    {
        // validation for constraint: string
        if (!is_null($securityTokenId) && !is_string($securityTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($securityTokenId, true), gettype($securityTokenId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($securityTokenId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $securityTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($securityTokenId, true)), __LINE__);
        }
        if (is_null($securityTokenId) || (is_array($securityTokenId) && empty($securityTokenId))) {
            unset($this->SecurityTokenId);
        } else {
            $this->SecurityTokenId = $securityTokenId;
        }
        return $this;
    }
}
