<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Any.CrossOrgUnitsAcl StructType
 * @subpackage Structs
 */
class Any_CrossOrgUnitsAcl extends PersistableEntity
{
    /**
     * The AclSchemeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AclSchemeId;
    /**
     * The BusinessFlow
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BusinessFlow;
    /**
     * The IsAccessAllowed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAccessAllowed;
    /**
     * The TargetOrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TargetOrganizationUnitId;
    /**
     * Constructor method for Any.CrossOrgUnitsAcl
     * @uses Any_CrossOrgUnitsAcl::setAclSchemeId()
     * @uses Any_CrossOrgUnitsAcl::setBusinessFlow()
     * @uses Any_CrossOrgUnitsAcl::setIsAccessAllowed()
     * @uses Any_CrossOrgUnitsAcl::setTargetOrganizationUnitId()
     * @param int $aclSchemeId
     * @param string $businessFlow
     * @param bool $isAccessAllowed
     * @param string $targetOrganizationUnitId
     */
    public function __construct($aclSchemeId = null, $businessFlow = null, $isAccessAllowed = null, $targetOrganizationUnitId = null)
    {
        $this
            ->setAclSchemeId($aclSchemeId)
            ->setBusinessFlow($businessFlow)
            ->setIsAccessAllowed($isAccessAllowed)
            ->setTargetOrganizationUnitId($targetOrganizationUnitId);
    }
    /**
     * Get AclSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAclSchemeId()
    {
        return isset($this->AclSchemeId) ? $this->AclSchemeId : null;
    }
    /**
     * Set AclSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aclSchemeId
     * @return \patest\StructType\Any_CrossOrgUnitsAcl
     */
    public function setAclSchemeId($aclSchemeId = null)
    {
        // validation for constraint: int
        if (!is_null($aclSchemeId) && !(is_int($aclSchemeId) || ctype_digit($aclSchemeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aclSchemeId, true), gettype($aclSchemeId)), __LINE__);
        }
        if (is_null($aclSchemeId) || (is_array($aclSchemeId) && empty($aclSchemeId))) {
            unset($this->AclSchemeId);
        } else {
            $this->AclSchemeId = $aclSchemeId;
        }
        return $this;
    }
    /**
     * Get BusinessFlow value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBusinessFlow()
    {
        return isset($this->BusinessFlow) ? $this->BusinessFlow : null;
    }
    /**
     * Set BusinessFlow value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $businessFlow
     * @return \patest\StructType\Any_CrossOrgUnitsAcl
     */
    public function setBusinessFlow($businessFlow = null)
    {
        // validation for constraint: string
        if (!is_null($businessFlow) && !is_string($businessFlow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($businessFlow, true), gettype($businessFlow)), __LINE__);
        }
        if (is_null($businessFlow) || (is_array($businessFlow) && empty($businessFlow))) {
            unset($this->BusinessFlow);
        } else {
            $this->BusinessFlow = $businessFlow;
        }
        return $this;
    }
    /**
     * Get IsAccessAllowed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAccessAllowed()
    {
        return isset($this->IsAccessAllowed) ? $this->IsAccessAllowed : null;
    }
    /**
     * Set IsAccessAllowed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAccessAllowed
     * @return \patest\StructType\Any_CrossOrgUnitsAcl
     */
    public function setIsAccessAllowed($isAccessAllowed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAccessAllowed) && !is_bool($isAccessAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAccessAllowed, true), gettype($isAccessAllowed)), __LINE__);
        }
        if (is_null($isAccessAllowed) || (is_array($isAccessAllowed) && empty($isAccessAllowed))) {
            unset($this->IsAccessAllowed);
        } else {
            $this->IsAccessAllowed = $isAccessAllowed;
        }
        return $this;
    }
    /**
     * Get TargetOrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetOrganizationUnitId()
    {
        return isset($this->TargetOrganizationUnitId) ? $this->TargetOrganizationUnitId : null;
    }
    /**
     * Set TargetOrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetOrganizationUnitId
     * @return \patest\StructType\Any_CrossOrgUnitsAcl
     */
    public function setTargetOrganizationUnitId($targetOrganizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($targetOrganizationUnitId) && !is_string($targetOrganizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetOrganizationUnitId, true), gettype($targetOrganizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($targetOrganizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $targetOrganizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($targetOrganizationUnitId, true)), __LINE__);
        }
        if (is_null($targetOrganizationUnitId) || (is_array($targetOrganizationUnitId) && empty($targetOrganizationUnitId))) {
            unset($this->TargetOrganizationUnitId);
        } else {
            $this->TargetOrganizationUnitId = $targetOrganizationUnitId;
        }
        return $this;
    }
}
