<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Any.BaseLinkPaymentLog StructType
 * @subpackage Structs
 */
class Any_BaseLinkPaymentLog extends PersistableEntity
{
    /**
     * The AlreadyHasLinkedToPayment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AlreadyHasLinkedToPayment;
    /**
     * The ClientTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientTypes;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Date;
    /**
     * The LinkPaymentErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LinkPaymentErrors;
    /**
     * The OverWrite
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OverWrite;
    /**
     * The Population
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Population;
    /**
     * The Processed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Processed;
    /**
     * The User
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $User;
    /**
     * Constructor method for Any.BaseLinkPaymentLog
     * @uses Any_BaseLinkPaymentLog::setAlreadyHasLinkedToPayment()
     * @uses Any_BaseLinkPaymentLog::setClientTypes()
     * @uses Any_BaseLinkPaymentLog::setDate()
     * @uses Any_BaseLinkPaymentLog::setLinkPaymentErrors()
     * @uses Any_BaseLinkPaymentLog::setOverWrite()
     * @uses Any_BaseLinkPaymentLog::setPopulation()
     * @uses Any_BaseLinkPaymentLog::setProcessed()
     * @uses Any_BaseLinkPaymentLog::setUser()
     * @param int $alreadyHasLinkedToPayment
     * @param string $clientTypes
     * @param string $date
     * @param int $linkPaymentErrors
     * @param bool $overWrite
     * @param int $population
     * @param int $processed
     * @param string $user
     */
    public function __construct($alreadyHasLinkedToPayment = null, $clientTypes = null, $date = null, $linkPaymentErrors = null, $overWrite = null, $population = null, $processed = null, $user = null)
    {
        $this
            ->setAlreadyHasLinkedToPayment($alreadyHasLinkedToPayment)
            ->setClientTypes($clientTypes)
            ->setDate($date)
            ->setLinkPaymentErrors($linkPaymentErrors)
            ->setOverWrite($overWrite)
            ->setPopulation($population)
            ->setProcessed($processed)
            ->setUser($user);
    }
    /**
     * Get AlreadyHasLinkedToPayment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAlreadyHasLinkedToPayment()
    {
        return isset($this->AlreadyHasLinkedToPayment) ? $this->AlreadyHasLinkedToPayment : null;
    }
    /**
     * Set AlreadyHasLinkedToPayment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $alreadyHasLinkedToPayment
     * @return \patest\StructType\Any_BaseLinkPaymentLog
     */
    public function setAlreadyHasLinkedToPayment($alreadyHasLinkedToPayment = null)
    {
        // validation for constraint: int
        if (!is_null($alreadyHasLinkedToPayment) && !(is_int($alreadyHasLinkedToPayment) || ctype_digit($alreadyHasLinkedToPayment))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($alreadyHasLinkedToPayment, true), gettype($alreadyHasLinkedToPayment)), __LINE__);
        }
        if (is_null($alreadyHasLinkedToPayment) || (is_array($alreadyHasLinkedToPayment) && empty($alreadyHasLinkedToPayment))) {
            unset($this->AlreadyHasLinkedToPayment);
        } else {
            $this->AlreadyHasLinkedToPayment = $alreadyHasLinkedToPayment;
        }
        return $this;
    }
    /**
     * Get ClientTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientTypes()
    {
        return isset($this->ClientTypes) ? $this->ClientTypes : null;
    }
    /**
     * Set ClientTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientTypes
     * @return \patest\StructType\Any_BaseLinkPaymentLog
     */
    public function setClientTypes($clientTypes = null)
    {
        // validation for constraint: string
        if (!is_null($clientTypes) && !is_string($clientTypes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientTypes, true), gettype($clientTypes)), __LINE__);
        }
        if (is_null($clientTypes) || (is_array($clientTypes) && empty($clientTypes))) {
            unset($this->ClientTypes);
        } else {
            $this->ClientTypes = $clientTypes;
        }
        return $this;
    }
    /**
     * Get Date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDate()
    {
        return isset($this->Date) ? $this->Date : null;
    }
    /**
     * Set Date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $date
     * @return \patest\StructType\Any_BaseLinkPaymentLog
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        if (is_null($date) || (is_array($date) && empty($date))) {
            unset($this->Date);
        } else {
            $this->Date = $date;
        }
        return $this;
    }
    /**
     * Get LinkPaymentErrors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLinkPaymentErrors()
    {
        return isset($this->LinkPaymentErrors) ? $this->LinkPaymentErrors : null;
    }
    /**
     * Set LinkPaymentErrors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $linkPaymentErrors
     * @return \patest\StructType\Any_BaseLinkPaymentLog
     */
    public function setLinkPaymentErrors($linkPaymentErrors = null)
    {
        // validation for constraint: int
        if (!is_null($linkPaymentErrors) && !(is_int($linkPaymentErrors) || ctype_digit($linkPaymentErrors))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($linkPaymentErrors, true), gettype($linkPaymentErrors)), __LINE__);
        }
        if (is_null($linkPaymentErrors) || (is_array($linkPaymentErrors) && empty($linkPaymentErrors))) {
            unset($this->LinkPaymentErrors);
        } else {
            $this->LinkPaymentErrors = $linkPaymentErrors;
        }
        return $this;
    }
    /**
     * Get OverWrite value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOverWrite()
    {
        return isset($this->OverWrite) ? $this->OverWrite : null;
    }
    /**
     * Set OverWrite value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $overWrite
     * @return \patest\StructType\Any_BaseLinkPaymentLog
     */
    public function setOverWrite($overWrite = null)
    {
        // validation for constraint: boolean
        if (!is_null($overWrite) && !is_bool($overWrite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($overWrite, true), gettype($overWrite)), __LINE__);
        }
        if (is_null($overWrite) || (is_array($overWrite) && empty($overWrite))) {
            unset($this->OverWrite);
        } else {
            $this->OverWrite = $overWrite;
        }
        return $this;
    }
    /**
     * Get Population value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPopulation()
    {
        return isset($this->Population) ? $this->Population : null;
    }
    /**
     * Set Population value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $population
     * @return \patest\StructType\Any_BaseLinkPaymentLog
     */
    public function setPopulation($population = null)
    {
        // validation for constraint: int
        if (!is_null($population) && !(is_int($population) || ctype_digit($population))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($population, true), gettype($population)), __LINE__);
        }
        if (is_null($population) || (is_array($population) && empty($population))) {
            unset($this->Population);
        } else {
            $this->Population = $population;
        }
        return $this;
    }
    /**
     * Get Processed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getProcessed()
    {
        return isset($this->Processed) ? $this->Processed : null;
    }
    /**
     * Set Processed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $processed
     * @return \patest\StructType\Any_BaseLinkPaymentLog
     */
    public function setProcessed($processed = null)
    {
        // validation for constraint: int
        if (!is_null($processed) && !(is_int($processed) || ctype_digit($processed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($processed, true), gettype($processed)), __LINE__);
        }
        if (is_null($processed) || (is_array($processed) && empty($processed))) {
            unset($this->Processed);
        } else {
            $this->Processed = $processed;
        }
        return $this;
    }
    /**
     * Get User value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUser()
    {
        return isset($this->User) ? $this->User : null;
    }
    /**
     * Set User value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $user
     * @return \patest\StructType\Any_BaseLinkPaymentLog
     */
    public function setUser($user = null)
    {
        // validation for constraint: string
        if (!is_null($user) && !is_string($user)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($user, true), gettype($user)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($user) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $user)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($user, true)), __LINE__);
        }
        if (is_null($user) || (is_array($user) && empty($user))) {
            unset($this->User);
        } else {
            $this->User = $user;
        }
        return $this;
    }
}
