<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AnalyzeTransactionInteractionRequirementsRequest
 * StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AnalyzeTransactionInteractionRequirementsRequest
 * @subpackage Structs
 */
class AnalyzeTransactionInteractionRequirementsRequest extends ExtensibleDataContract
{
    /**
     * The SituationName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SituationName;
    /**
     * The State
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfstringSerializedObjectWTEG5wMr
     */
    public $State;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * Constructor method for AnalyzeTransactionInteractionRequirementsRequest
     * @uses AnalyzeTransactionInteractionRequirementsRequest::setSituationName()
     * @uses AnalyzeTransactionInteractionRequirementsRequest::setState()
     * @uses AnalyzeTransactionInteractionRequirementsRequest::setTransactionGuid()
     * @param string $situationName
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringSerializedObjectWTEG5wMr $state
     * @param string $transactionGuid
     */
    public function __construct($situationName = null, \patest\ArrayType\ArrayOfKeyValueOfstringSerializedObjectWTEG5wMr $state = null, $transactionGuid = null)
    {
        $this
            ->setSituationName($situationName)
            ->setState($state)
            ->setTransactionGuid($transactionGuid);
    }
    /**
     * Get SituationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSituationName()
    {
        return isset($this->SituationName) ? $this->SituationName : null;
    }
    /**
     * Set SituationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $situationName
     * @return \patest\StructType\AnalyzeTransactionInteractionRequirementsRequest
     */
    public function setSituationName($situationName = null)
    {
        // validation for constraint: string
        if (!is_null($situationName) && !is_string($situationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($situationName, true), gettype($situationName)), __LINE__);
        }
        if (is_null($situationName) || (is_array($situationName) && empty($situationName))) {
            unset($this->SituationName);
        } else {
            $this->SituationName = $situationName;
        }
        return $this;
    }
    /**
     * Get State value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfstringSerializedObjectWTEG5wMr|null
     */
    public function getState()
    {
        return isset($this->State) ? $this->State : null;
    }
    /**
     * Set State value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringSerializedObjectWTEG5wMr $state
     * @return \patest\StructType\AnalyzeTransactionInteractionRequirementsRequest
     */
    public function setState(\patest\ArrayType\ArrayOfKeyValueOfstringSerializedObjectWTEG5wMr $state = null)
    {
        if (is_null($state) || (is_array($state) && empty($state))) {
            unset($this->State);
        } else {
            $this->State = $state;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return $this->TransactionGuid;
    }
    /**
     * Set TransactionGuid value
     * @param string $transactionGuid
     * @return \patest\StructType\AnalyzeTransactionInteractionRequirementsRequest
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        $this->TransactionGuid = $transactionGuid;
        return $this;
    }
}
