<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressSearchResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AddressSearchResponse
 * @subpackage Structs
 */
class AddressSearchResponse extends AbstractStructBase
{
    /**
     * The Addresses
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfPostalAddress
     */
    public $Addresses;
    /**
     * Constructor method for AddressSearchResponse
     * @uses AddressSearchResponse::setAddresses()
     * @param \patest\ArrayType\ArrayOfPostalAddress $addresses
     */
    public function __construct(\patest\ArrayType\ArrayOfPostalAddress $addresses = null)
    {
        $this
            ->setAddresses($addresses);
    }
    /**
     * Get Addresses value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfPostalAddress|null
     */
    public function getAddresses()
    {
        return isset($this->Addresses) ? $this->Addresses : null;
    }
    /**
     * Set Addresses value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfPostalAddress $addresses
     * @return \patest\StructType\AddressSearchResponse
     */
    public function setAddresses(\patest\ArrayType\ArrayOfPostalAddress $addresses = null)
    {
        if (is_null($addresses) || (is_array($addresses) && empty($addresses))) {
            unset($this->Addresses);
        } else {
            $this->Addresses = $addresses;
        }
        return $this;
    }
}
