<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdditionalTicketBackNote StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AdditionalTicketBackNote
 * @subpackage Structs
 */
class AdditionalTicketBackNote extends AbstractStructBase
{
    /**
     * The DataType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DataType;
    /**
     * The Label
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Label;
    /**
     * The NoteType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $NoteType;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Value;
    /**
     * Constructor method for AdditionalTicketBackNote
     * @uses AdditionalTicketBackNote::setDataType()
     * @uses AdditionalTicketBackNote::setLabel()
     * @uses AdditionalTicketBackNote::setNoteType()
     * @uses AdditionalTicketBackNote::setValue()
     * @param string $dataType
     * @param string $label
     * @param string $noteType
     * @param string $value
     */
    public function __construct($dataType = null, $label = null, $noteType = null, $value = null)
    {
        $this
            ->setDataType($dataType)
            ->setLabel($label)
            ->setNoteType($noteType)
            ->setValue($value);
    }
    /**
     * Get DataType value
     * @return string|null
     */
    public function getDataType()
    {
        return $this->DataType;
    }
    /**
     * Set DataType value
     * @uses \patest\EnumType\TicketViewAdditionalNoteDataType::valueIsValid()
     * @uses \patest\EnumType\TicketViewAdditionalNoteDataType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dataType
     * @return \patest\StructType\AdditionalTicketBackNote
     */
    public function setDataType($dataType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketViewAdditionalNoteDataType::valueIsValid($dataType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketViewAdditionalNoteDataType', is_array($dataType) ? implode(', ', $dataType) : var_export($dataType, true), implode(', ', \patest\EnumType\TicketViewAdditionalNoteDataType::getValidValues())), __LINE__);
        }
        $this->DataType = $dataType;
        return $this;
    }
    /**
     * Get Label value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLabel()
    {
        return isset($this->Label) ? $this->Label : null;
    }
    /**
     * Set Label value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $label
     * @return \patest\StructType\AdditionalTicketBackNote
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($label, true), gettype($label)), __LINE__);
        }
        if (is_null($label) || (is_array($label) && empty($label))) {
            unset($this->Label);
        } else {
            $this->Label = $label;
        }
        return $this;
    }
    /**
     * Get NoteType value
     * @return string|null
     */
    public function getNoteType()
    {
        return $this->NoteType;
    }
    /**
     * Set NoteType value
     * @uses \patest\EnumType\TicketViewAdditionalNoteType::valueIsValid()
     * @uses \patest\EnumType\TicketViewAdditionalNoteType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $noteType
     * @return \patest\StructType\AdditionalTicketBackNote
     */
    public function setNoteType($noteType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketViewAdditionalNoteType::valueIsValid($noteType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketViewAdditionalNoteType', is_array($noteType) ? implode(', ', $noteType) : var_export($noteType, true), implode(', ', \patest\EnumType\TicketViewAdditionalNoteType::getValidValues())), __LINE__);
        }
        $this->NoteType = $noteType;
        return $this;
    }
    /**
     * Get Value value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValue()
    {
        return isset($this->Value) ? $this->Value : null;
    }
    /**
     * Set Value value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $value
     * @return \patest\StructType\AdditionalTicketBackNote
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        if (is_null($value) || (is_array($value) && empty($value))) {
            unset($this->Value);
        } else {
            $this->Value = $value;
        }
        return $this;
    }
}
