<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddProductsToBasketResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AddProductsToBasketResponse
 * @subpackage Structs
 */
class AddProductsToBasketResponse extends ExtensibleDataContract
{
    /**
     * The InsertionGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $InsertionGroup;
    /**
     * The Items
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfAddProductsToBasketResponseItem
     */
    public $Items;
    /**
     * The TransactionSnapshot
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\TransactionSnapshot
     */
    public $TransactionSnapshot;
    /**
     * Constructor method for AddProductsToBasketResponse
     * @uses AddProductsToBasketResponse::setInsertionGroup()
     * @uses AddProductsToBasketResponse::setItems()
     * @uses AddProductsToBasketResponse::setTransactionSnapshot()
     * @param int $insertionGroup
     * @param \patest\ArrayType\ArrayOfAddProductsToBasketResponseItem $items
     * @param \patest\StructType\TransactionSnapshot $transactionSnapshot
     */
    public function __construct($insertionGroup = null, \patest\ArrayType\ArrayOfAddProductsToBasketResponseItem $items = null, \patest\StructType\TransactionSnapshot $transactionSnapshot = null)
    {
        $this
            ->setInsertionGroup($insertionGroup)
            ->setItems($items)
            ->setTransactionSnapshot($transactionSnapshot);
    }
    /**
     * Get InsertionGroup value
     * @return int|null
     */
    public function getInsertionGroup()
    {
        return $this->InsertionGroup;
    }
    /**
     * Set InsertionGroup value
     * @param int $insertionGroup
     * @return \patest\StructType\AddProductsToBasketResponse
     */
    public function setInsertionGroup($insertionGroup = null)
    {
        // validation for constraint: int
        if (!is_null($insertionGroup) && !(is_int($insertionGroup) || ctype_digit($insertionGroup))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($insertionGroup, true), gettype($insertionGroup)), __LINE__);
        }
        $this->InsertionGroup = $insertionGroup;
        return $this;
    }
    /**
     * Get Items value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfAddProductsToBasketResponseItem|null
     */
    public function getItems()
    {
        return isset($this->Items) ? $this->Items : null;
    }
    /**
     * Set Items value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfAddProductsToBasketResponseItem $items
     * @return \patest\StructType\AddProductsToBasketResponse
     */
    public function setItems(\patest\ArrayType\ArrayOfAddProductsToBasketResponseItem $items = null)
    {
        if (is_null($items) || (is_array($items) && empty($items))) {
            unset($this->Items);
        } else {
            $this->Items = $items;
        }
        return $this;
    }
    /**
     * Get TransactionSnapshot value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\TransactionSnapshot|null
     */
    public function getTransactionSnapshot()
    {
        return isset($this->TransactionSnapshot) ? $this->TransactionSnapshot : null;
    }
    /**
     * Set TransactionSnapshot value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\TransactionSnapshot $transactionSnapshot
     * @return \patest\StructType\AddProductsToBasketResponse
     */
    public function setTransactionSnapshot(\patest\StructType\TransactionSnapshot $transactionSnapshot = null)
    {
        if (is_null($transactionSnapshot) || (is_array($transactionSnapshot) && empty($transactionSnapshot))) {
            unset($this->TransactionSnapshot);
        } else {
            $this->TransactionSnapshot = $transactionSnapshot;
        }
        return $this;
    }
}
