<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddProductsToBasketRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AddProductsToBasketRequest
 * @subpackage Structs
 */
class AddProductsToBasketRequest extends ExtensibleDataContract
{
    /**
     * The CouponDefinitionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CouponDefinitionId;
    /**
     * The IsConvertPricingErrorsIntoIncomplete
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsConvertPricingErrorsIntoIncomplete;
    /**
     * The ItemsToAdd
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfAddProductsToBasketRequestItem
     */
    public $ItemsToAdd;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The TransactionSnapshotType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TransactionSnapshotType;
    /**
     * Constructor method for AddProductsToBasketRequest
     * @uses AddProductsToBasketRequest::setCouponDefinitionId()
     * @uses AddProductsToBasketRequest::setIsConvertPricingErrorsIntoIncomplete()
     * @uses AddProductsToBasketRequest::setItemsToAdd()
     * @uses AddProductsToBasketRequest::setTransactionGuid()
     * @uses AddProductsToBasketRequest::setTransactionSnapshotType()
     * @param string $couponDefinitionId
     * @param bool $isConvertPricingErrorsIntoIncomplete
     * @param \patest\ArrayType\ArrayOfAddProductsToBasketRequestItem $itemsToAdd
     * @param string $transactionGuid
     * @param string $transactionSnapshotType
     */
    public function __construct($couponDefinitionId = null, $isConvertPricingErrorsIntoIncomplete = null, \patest\ArrayType\ArrayOfAddProductsToBasketRequestItem $itemsToAdd = null, $transactionGuid = null, $transactionSnapshotType = null)
    {
        $this
            ->setCouponDefinitionId($couponDefinitionId)
            ->setIsConvertPricingErrorsIntoIncomplete($isConvertPricingErrorsIntoIncomplete)
            ->setItemsToAdd($itemsToAdd)
            ->setTransactionGuid($transactionGuid)
            ->setTransactionSnapshotType($transactionSnapshotType);
    }
    /**
     * Get CouponDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCouponDefinitionId()
    {
        return isset($this->CouponDefinitionId) ? $this->CouponDefinitionId : null;
    }
    /**
     * Set CouponDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $couponDefinitionId
     * @return \patest\StructType\AddProductsToBasketRequest
     */
    public function setCouponDefinitionId($couponDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($couponDefinitionId) && !is_string($couponDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($couponDefinitionId, true), gettype($couponDefinitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($couponDefinitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $couponDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($couponDefinitionId, true)), __LINE__);
        }
        if (is_null($couponDefinitionId) || (is_array($couponDefinitionId) && empty($couponDefinitionId))) {
            unset($this->CouponDefinitionId);
        } else {
            $this->CouponDefinitionId = $couponDefinitionId;
        }
        return $this;
    }
    /**
     * Get IsConvertPricingErrorsIntoIncomplete value
     * @return bool|null
     */
    public function getIsConvertPricingErrorsIntoIncomplete()
    {
        return $this->IsConvertPricingErrorsIntoIncomplete;
    }
    /**
     * Set IsConvertPricingErrorsIntoIncomplete value
     * @param bool $isConvertPricingErrorsIntoIncomplete
     * @return \patest\StructType\AddProductsToBasketRequest
     */
    public function setIsConvertPricingErrorsIntoIncomplete($isConvertPricingErrorsIntoIncomplete = null)
    {
        // validation for constraint: boolean
        if (!is_null($isConvertPricingErrorsIntoIncomplete) && !is_bool($isConvertPricingErrorsIntoIncomplete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isConvertPricingErrorsIntoIncomplete, true), gettype($isConvertPricingErrorsIntoIncomplete)), __LINE__);
        }
        $this->IsConvertPricingErrorsIntoIncomplete = $isConvertPricingErrorsIntoIncomplete;
        return $this;
    }
    /**
     * Get ItemsToAdd value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfAddProductsToBasketRequestItem|null
     */
    public function getItemsToAdd()
    {
        return isset($this->ItemsToAdd) ? $this->ItemsToAdd : null;
    }
    /**
     * Set ItemsToAdd value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfAddProductsToBasketRequestItem $itemsToAdd
     * @return \patest\StructType\AddProductsToBasketRequest
     */
    public function setItemsToAdd(\patest\ArrayType\ArrayOfAddProductsToBasketRequestItem $itemsToAdd = null)
    {
        if (is_null($itemsToAdd) || (is_array($itemsToAdd) && empty($itemsToAdd))) {
            unset($this->ItemsToAdd);
        } else {
            $this->ItemsToAdd = $itemsToAdd;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return $this->TransactionGuid;
    }
    /**
     * Set TransactionGuid value
     * @param string $transactionGuid
     * @return \patest\StructType\AddProductsToBasketRequest
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        $this->TransactionGuid = $transactionGuid;
        return $this;
    }
    /**
     * Get TransactionSnapshotType value
     * @return string|null
     */
    public function getTransactionSnapshotType()
    {
        return $this->TransactionSnapshotType;
    }
    /**
     * Set TransactionSnapshotType value
     * @uses \patest\EnumType\TransactionSnapshotType::valueIsValid()
     * @uses \patest\EnumType\TransactionSnapshotType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionSnapshotType
     * @return \patest\StructType\AddProductsToBasketRequest
     */
    public function setTransactionSnapshotType($transactionSnapshotType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionSnapshotType::valueIsValid($transactionSnapshotType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionSnapshotType', is_array($transactionSnapshotType) ? implode(', ', $transactionSnapshotType) : var_export($transactionSnapshotType, true), implode(', ', \patest\EnumType\TransactionSnapshotType::getValidValues())), __LINE__);
        }
        $this->TransactionSnapshotType = $transactionSnapshotType;
        return $this;
    }
}
