<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddPaymentToBasket-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AddPaymentToBasket-Request
 * @subpackage Structs
 */
class AddPaymentToBasket_Request extends ExtensibleDataContract
{
    /**
     * The AmountsReferenceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AmountsReferenceId;
    /**
     * The ExpectedTotalPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $ExpectedTotalPrice;
    /**
     * The PaymentDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AbstractPaymentDescription
     */
    public $PaymentDescription;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The TransactionSnapshotType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TransactionSnapshotType;
    /**
     * The IsUserInteractionSupported
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsUserInteractionSupported;
    /**
     * Constructor method for AddPaymentToBasket-Request
     * @uses AddPaymentToBasket_Request::setAmountsReferenceId()
     * @uses AddPaymentToBasket_Request::setExpectedTotalPrice()
     * @uses AddPaymentToBasket_Request::setPaymentDescription()
     * @uses AddPaymentToBasket_Request::setTransactionGuid()
     * @uses AddPaymentToBasket_Request::setTransactionSnapshotType()
     * @uses AddPaymentToBasket_Request::setIsUserInteractionSupported()
     * @param string $amountsReferenceId
     * @param \patest\StructType\Money $expectedTotalPrice
     * @param \patest\StructType\AbstractPaymentDescription $paymentDescription
     * @param string $transactionGuid
     * @param string $transactionSnapshotType
     * @param bool $isUserInteractionSupported
     */
    public function __construct($amountsReferenceId = null, \patest\StructType\Money $expectedTotalPrice = null, \patest\StructType\AbstractPaymentDescription $paymentDescription = null, $transactionGuid = null, $transactionSnapshotType = null, $isUserInteractionSupported = null)
    {
        $this
            ->setAmountsReferenceId($amountsReferenceId)
            ->setExpectedTotalPrice($expectedTotalPrice)
            ->setPaymentDescription($paymentDescription)
            ->setTransactionGuid($transactionGuid)
            ->setTransactionSnapshotType($transactionSnapshotType)
            ->setIsUserInteractionSupported($isUserInteractionSupported);
    }
    /**
     * Get AmountsReferenceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAmountsReferenceId()
    {
        return isset($this->AmountsReferenceId) ? $this->AmountsReferenceId : null;
    }
    /**
     * Set AmountsReferenceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $amountsReferenceId
     * @return \patest\StructType\AddPaymentToBasket_Request
     */
    public function setAmountsReferenceId($amountsReferenceId = null)
    {
        // validation for constraint: string
        if (!is_null($amountsReferenceId) && !is_string($amountsReferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amountsReferenceId, true), gettype($amountsReferenceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($amountsReferenceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $amountsReferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($amountsReferenceId, true)), __LINE__);
        }
        if (is_null($amountsReferenceId) || (is_array($amountsReferenceId) && empty($amountsReferenceId))) {
            unset($this->AmountsReferenceId);
        } else {
            $this->AmountsReferenceId = $amountsReferenceId;
        }
        return $this;
    }
    /**
     * Get ExpectedTotalPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getExpectedTotalPrice()
    {
        return isset($this->ExpectedTotalPrice) ? $this->ExpectedTotalPrice : null;
    }
    /**
     * Set ExpectedTotalPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $expectedTotalPrice
     * @return \patest\StructType\AddPaymentToBasket_Request
     */
    public function setExpectedTotalPrice(\patest\StructType\Money $expectedTotalPrice = null)
    {
        if (is_null($expectedTotalPrice) || (is_array($expectedTotalPrice) && empty($expectedTotalPrice))) {
            unset($this->ExpectedTotalPrice);
        } else {
            $this->ExpectedTotalPrice = $expectedTotalPrice;
        }
        return $this;
    }
    /**
     * Get PaymentDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AbstractPaymentDescription|null
     */
    public function getPaymentDescription()
    {
        return isset($this->PaymentDescription) ? $this->PaymentDescription : null;
    }
    /**
     * Set PaymentDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AbstractPaymentDescription $paymentDescription
     * @return \patest\StructType\AddPaymentToBasket_Request
     */
    public function setPaymentDescription(\patest\StructType\AbstractPaymentDescription $paymentDescription = null)
    {
        if (is_null($paymentDescription) || (is_array($paymentDescription) && empty($paymentDescription))) {
            unset($this->PaymentDescription);
        } else {
            $this->PaymentDescription = $paymentDescription;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return $this->TransactionGuid;
    }
    /**
     * Set TransactionGuid value
     * @param string $transactionGuid
     * @return \patest\StructType\AddPaymentToBasket_Request
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        $this->TransactionGuid = $transactionGuid;
        return $this;
    }
    /**
     * Get TransactionSnapshotType value
     * @return string|null
     */
    public function getTransactionSnapshotType()
    {
        return $this->TransactionSnapshotType;
    }
    /**
     * Set TransactionSnapshotType value
     * @uses \patest\EnumType\TransactionSnapshotType::valueIsValid()
     * @uses \patest\EnumType\TransactionSnapshotType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionSnapshotType
     * @return \patest\StructType\AddPaymentToBasket_Request
     */
    public function setTransactionSnapshotType($transactionSnapshotType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionSnapshotType::valueIsValid($transactionSnapshotType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionSnapshotType', is_array($transactionSnapshotType) ? implode(', ', $transactionSnapshotType) : var_export($transactionSnapshotType, true), implode(', ', \patest\EnumType\TransactionSnapshotType::getValidValues())), __LINE__);
        }
        $this->TransactionSnapshotType = $transactionSnapshotType;
        return $this;
    }
    /**
     * Get IsUserInteractionSupported value
     * @return bool|null
     */
    public function getIsUserInteractionSupported()
    {
        return $this->IsUserInteractionSupported;
    }
    /**
     * Set IsUserInteractionSupported value
     * @param bool $isUserInteractionSupported
     * @return \patest\StructType\AddPaymentToBasket_Request
     */
    public function setIsUserInteractionSupported($isUserInteractionSupported = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUserInteractionSupported) && !is_bool($isUserInteractionSupported)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUserInteractionSupported, true), gettype($isUserInteractionSupported)), __LINE__);
        }
        $this->IsUserInteractionSupported = $isUserInteractionSupported;
        return $this;
    }
}
