<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddInvoiceContentToBasketRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AddInvoiceContentToBasketRequest
 * @subpackage Structs
 */
class AddInvoiceContentToBasketRequest extends AbstractStructBase
{
    /**
     * The InvoiceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $InvoiceId;
    /**
     * The InvoiceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $InvoiceNumber;
    /**
     * The PaymentTotalAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $PaymentTotalAmount;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The TransactionSnapshotType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TransactionSnapshotType;
    /**
     * Constructor method for AddInvoiceContentToBasketRequest
     * @uses AddInvoiceContentToBasketRequest::setInvoiceId()
     * @uses AddInvoiceContentToBasketRequest::setInvoiceNumber()
     * @uses AddInvoiceContentToBasketRequest::setPaymentTotalAmount()
     * @uses AddInvoiceContentToBasketRequest::setTransactionGuid()
     * @uses AddInvoiceContentToBasketRequest::setTransactionSnapshotType()
     * @param string $invoiceId
     * @param int $invoiceNumber
     * @param \patest\StructType\Money $paymentTotalAmount
     * @param string $transactionGuid
     * @param string $transactionSnapshotType
     */
    public function __construct($invoiceId = null, $invoiceNumber = null, \patest\StructType\Money $paymentTotalAmount = null, $transactionGuid = null, $transactionSnapshotType = null)
    {
        $this
            ->setInvoiceId($invoiceId)
            ->setInvoiceNumber($invoiceNumber)
            ->setPaymentTotalAmount($paymentTotalAmount)
            ->setTransactionGuid($transactionGuid)
            ->setTransactionSnapshotType($transactionSnapshotType);
    }
    /**
     * Get InvoiceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInvoiceId()
    {
        return isset($this->InvoiceId) ? $this->InvoiceId : null;
    }
    /**
     * Set InvoiceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $invoiceId
     * @return \patest\StructType\AddInvoiceContentToBasketRequest
     */
    public function setInvoiceId($invoiceId = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceId) && !is_string($invoiceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceId, true), gettype($invoiceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($invoiceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $invoiceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($invoiceId, true)), __LINE__);
        }
        if (is_null($invoiceId) || (is_array($invoiceId) && empty($invoiceId))) {
            unset($this->InvoiceId);
        } else {
            $this->InvoiceId = $invoiceId;
        }
        return $this;
    }
    /**
     * Get InvoiceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getInvoiceNumber()
    {
        return isset($this->InvoiceNumber) ? $this->InvoiceNumber : null;
    }
    /**
     * Set InvoiceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $invoiceNumber
     * @return \patest\StructType\AddInvoiceContentToBasketRequest
     */
    public function setInvoiceNumber($invoiceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($invoiceNumber) && !(is_int($invoiceNumber) || ctype_digit($invoiceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($invoiceNumber, true), gettype($invoiceNumber)), __LINE__);
        }
        if (is_null($invoiceNumber) || (is_array($invoiceNumber) && empty($invoiceNumber))) {
            unset($this->InvoiceNumber);
        } else {
            $this->InvoiceNumber = $invoiceNumber;
        }
        return $this;
    }
    /**
     * Get PaymentTotalAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getPaymentTotalAmount()
    {
        return isset($this->PaymentTotalAmount) ? $this->PaymentTotalAmount : null;
    }
    /**
     * Set PaymentTotalAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $paymentTotalAmount
     * @return \patest\StructType\AddInvoiceContentToBasketRequest
     */
    public function setPaymentTotalAmount(\patest\StructType\Money $paymentTotalAmount = null)
    {
        if (is_null($paymentTotalAmount) || (is_array($paymentTotalAmount) && empty($paymentTotalAmount))) {
            unset($this->PaymentTotalAmount);
        } else {
            $this->PaymentTotalAmount = $paymentTotalAmount;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return $this->TransactionGuid;
    }
    /**
     * Set TransactionGuid value
     * @param string $transactionGuid
     * @return \patest\StructType\AddInvoiceContentToBasketRequest
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        $this->TransactionGuid = $transactionGuid;
        return $this;
    }
    /**
     * Get TransactionSnapshotType value
     * @return string|null
     */
    public function getTransactionSnapshotType()
    {
        return $this->TransactionSnapshotType;
    }
    /**
     * Set TransactionSnapshotType value
     * @uses \patest\EnumType\TransactionSnapshotType::valueIsValid()
     * @uses \patest\EnumType\TransactionSnapshotType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionSnapshotType
     * @return \patest\StructType\AddInvoiceContentToBasketRequest
     */
    public function setTransactionSnapshotType($transactionSnapshotType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionSnapshotType::valueIsValid($transactionSnapshotType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionSnapshotType', is_array($transactionSnapshotType) ? implode(', ', $transactionSnapshotType) : var_export($transactionSnapshotType, true), implode(', ', \patest\EnumType\TransactionSnapshotType::getValidValues())), __LINE__);
        }
        $this->TransactionSnapshotType = $transactionSnapshotType;
        return $this;
    }
}
