<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddFullStackExchangeItemsToBasket-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AddFullStackExchangeItemsToBasket-Request
 * @subpackage Structs
 */
class AddFullStackExchangeItemsToBasket_Request extends AbstractStructBase
{
    /**
     * The ExchangeDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfguidFullStackExchangeSeatDetailsWA71RVNU
     */
    public $ExchangeDetails;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The TransactionSnapshotType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TransactionSnapshotType;
    /**
     * The ShouldTicketsReturnedToDefaultAllocation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ShouldTicketsReturnedToDefaultAllocation;
    /**
     * Constructor method for AddFullStackExchangeItemsToBasket-Request
     * @uses AddFullStackExchangeItemsToBasket_Request::setExchangeDetails()
     * @uses AddFullStackExchangeItemsToBasket_Request::setTransactionGuid()
     * @uses AddFullStackExchangeItemsToBasket_Request::setTransactionSnapshotType()
     * @uses AddFullStackExchangeItemsToBasket_Request::setShouldTicketsReturnedToDefaultAllocation()
     * @param \patest\ArrayType\ArrayOfKeyValueOfguidFullStackExchangeSeatDetailsWA71RVNU $exchangeDetails
     * @param string $transactionGuid
     * @param string $transactionSnapshotType
     * @param bool $shouldTicketsReturnedToDefaultAllocation
     */
    public function __construct(\patest\ArrayType\ArrayOfKeyValueOfguidFullStackExchangeSeatDetailsWA71RVNU $exchangeDetails = null, $transactionGuid = null, $transactionSnapshotType = null, $shouldTicketsReturnedToDefaultAllocation = null)
    {
        $this
            ->setExchangeDetails($exchangeDetails)
            ->setTransactionGuid($transactionGuid)
            ->setTransactionSnapshotType($transactionSnapshotType)
            ->setShouldTicketsReturnedToDefaultAllocation($shouldTicketsReturnedToDefaultAllocation);
    }
    /**
     * Get ExchangeDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfguidFullStackExchangeSeatDetailsWA71RVNU|null
     */
    public function getExchangeDetails()
    {
        return isset($this->ExchangeDetails) ? $this->ExchangeDetails : null;
    }
    /**
     * Set ExchangeDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfguidFullStackExchangeSeatDetailsWA71RVNU $exchangeDetails
     * @return \patest\StructType\AddFullStackExchangeItemsToBasket_Request
     */
    public function setExchangeDetails(\patest\ArrayType\ArrayOfKeyValueOfguidFullStackExchangeSeatDetailsWA71RVNU $exchangeDetails = null)
    {
        if (is_null($exchangeDetails) || (is_array($exchangeDetails) && empty($exchangeDetails))) {
            unset($this->ExchangeDetails);
        } else {
            $this->ExchangeDetails = $exchangeDetails;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return $this->TransactionGuid;
    }
    /**
     * Set TransactionGuid value
     * @param string $transactionGuid
     * @return \patest\StructType\AddFullStackExchangeItemsToBasket_Request
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        $this->TransactionGuid = $transactionGuid;
        return $this;
    }
    /**
     * Get TransactionSnapshotType value
     * @return string|null
     */
    public function getTransactionSnapshotType()
    {
        return $this->TransactionSnapshotType;
    }
    /**
     * Set TransactionSnapshotType value
     * @uses \patest\EnumType\TransactionSnapshotType::valueIsValid()
     * @uses \patest\EnumType\TransactionSnapshotType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionSnapshotType
     * @return \patest\StructType\AddFullStackExchangeItemsToBasket_Request
     */
    public function setTransactionSnapshotType($transactionSnapshotType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionSnapshotType::valueIsValid($transactionSnapshotType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionSnapshotType', is_array($transactionSnapshotType) ? implode(', ', $transactionSnapshotType) : var_export($transactionSnapshotType, true), implode(', ', \patest\EnumType\TransactionSnapshotType::getValidValues())), __LINE__);
        }
        $this->TransactionSnapshotType = $transactionSnapshotType;
        return $this;
    }
    /**
     * Get ShouldTicketsReturnedToDefaultAllocation value
     * @return bool|null
     */
    public function getShouldTicketsReturnedToDefaultAllocation()
    {
        return $this->ShouldTicketsReturnedToDefaultAllocation;
    }
    /**
     * Set ShouldTicketsReturnedToDefaultAllocation value
     * @param bool $shouldTicketsReturnedToDefaultAllocation
     * @return \patest\StructType\AddFullStackExchangeItemsToBasket_Request
     */
    public function setShouldTicketsReturnedToDefaultAllocation($shouldTicketsReturnedToDefaultAllocation = null)
    {
        // validation for constraint: boolean
        if (!is_null($shouldTicketsReturnedToDefaultAllocation) && !is_bool($shouldTicketsReturnedToDefaultAllocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($shouldTicketsReturnedToDefaultAllocation, true), gettype($shouldTicketsReturnedToDefaultAllocation)), __LINE__);
        }
        $this->ShouldTicketsReturnedToDefaultAllocation = $shouldTicketsReturnedToDefaultAllocation;
        return $this;
    }
}
