<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddDraftInvoiceContentToBasketRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AddDraftInvoiceContentToBasketRequest
 * @subpackage Structs
 */
class AddDraftInvoiceContentToBasketRequest extends AbstractStructBase
{
    /**
     * The DraftInvoiceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DraftInvoiceId;
    /**
     * The DraftInvoiceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DraftInvoiceNumber;
    /**
     * The PaymentTotalAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $PaymentTotalAmount;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The TransactionSnapshotType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TransactionSnapshotType;
    /**
     * Constructor method for AddDraftInvoiceContentToBasketRequest
     * @uses AddDraftInvoiceContentToBasketRequest::setDraftInvoiceId()
     * @uses AddDraftInvoiceContentToBasketRequest::setDraftInvoiceNumber()
     * @uses AddDraftInvoiceContentToBasketRequest::setPaymentTotalAmount()
     * @uses AddDraftInvoiceContentToBasketRequest::setTransactionGuid()
     * @uses AddDraftInvoiceContentToBasketRequest::setTransactionSnapshotType()
     * @param string $draftInvoiceId
     * @param int $draftInvoiceNumber
     * @param \patest\StructType\Money $paymentTotalAmount
     * @param string $transactionGuid
     * @param string $transactionSnapshotType
     */
    public function __construct($draftInvoiceId = null, $draftInvoiceNumber = null, \patest\StructType\Money $paymentTotalAmount = null, $transactionGuid = null, $transactionSnapshotType = null)
    {
        $this
            ->setDraftInvoiceId($draftInvoiceId)
            ->setDraftInvoiceNumber($draftInvoiceNumber)
            ->setPaymentTotalAmount($paymentTotalAmount)
            ->setTransactionGuid($transactionGuid)
            ->setTransactionSnapshotType($transactionSnapshotType);
    }
    /**
     * Get DraftInvoiceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDraftInvoiceId()
    {
        return isset($this->DraftInvoiceId) ? $this->DraftInvoiceId : null;
    }
    /**
     * Set DraftInvoiceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $draftInvoiceId
     * @return \patest\StructType\AddDraftInvoiceContentToBasketRequest
     */
    public function setDraftInvoiceId($draftInvoiceId = null)
    {
        // validation for constraint: string
        if (!is_null($draftInvoiceId) && !is_string($draftInvoiceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($draftInvoiceId, true), gettype($draftInvoiceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($draftInvoiceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $draftInvoiceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($draftInvoiceId, true)), __LINE__);
        }
        if (is_null($draftInvoiceId) || (is_array($draftInvoiceId) && empty($draftInvoiceId))) {
            unset($this->DraftInvoiceId);
        } else {
            $this->DraftInvoiceId = $draftInvoiceId;
        }
        return $this;
    }
    /**
     * Get DraftInvoiceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDraftInvoiceNumber()
    {
        return isset($this->DraftInvoiceNumber) ? $this->DraftInvoiceNumber : null;
    }
    /**
     * Set DraftInvoiceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $draftInvoiceNumber
     * @return \patest\StructType\AddDraftInvoiceContentToBasketRequest
     */
    public function setDraftInvoiceNumber($draftInvoiceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($draftInvoiceNumber) && !(is_int($draftInvoiceNumber) || ctype_digit($draftInvoiceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($draftInvoiceNumber, true), gettype($draftInvoiceNumber)), __LINE__);
        }
        if (is_null($draftInvoiceNumber) || (is_array($draftInvoiceNumber) && empty($draftInvoiceNumber))) {
            unset($this->DraftInvoiceNumber);
        } else {
            $this->DraftInvoiceNumber = $draftInvoiceNumber;
        }
        return $this;
    }
    /**
     * Get PaymentTotalAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getPaymentTotalAmount()
    {
        return isset($this->PaymentTotalAmount) ? $this->PaymentTotalAmount : null;
    }
    /**
     * Set PaymentTotalAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $paymentTotalAmount
     * @return \patest\StructType\AddDraftInvoiceContentToBasketRequest
     */
    public function setPaymentTotalAmount(\patest\StructType\Money $paymentTotalAmount = null)
    {
        if (is_null($paymentTotalAmount) || (is_array($paymentTotalAmount) && empty($paymentTotalAmount))) {
            unset($this->PaymentTotalAmount);
        } else {
            $this->PaymentTotalAmount = $paymentTotalAmount;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return $this->TransactionGuid;
    }
    /**
     * Set TransactionGuid value
     * @param string $transactionGuid
     * @return \patest\StructType\AddDraftInvoiceContentToBasketRequest
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        $this->TransactionGuid = $transactionGuid;
        return $this;
    }
    /**
     * Get TransactionSnapshotType value
     * @return string|null
     */
    public function getTransactionSnapshotType()
    {
        return $this->TransactionSnapshotType;
    }
    /**
     * Set TransactionSnapshotType value
     * @uses \patest\EnumType\TransactionSnapshotType::valueIsValid()
     * @uses \patest\EnumType\TransactionSnapshotType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionSnapshotType
     * @return \patest\StructType\AddDraftInvoiceContentToBasketRequest
     */
    public function setTransactionSnapshotType($transactionSnapshotType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionSnapshotType::valueIsValid($transactionSnapshotType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionSnapshotType', is_array($transactionSnapshotType) ? implode(', ', $transactionSnapshotType) : var_export($transactionSnapshotType, true), implode(', ', \patest\EnumType\TransactionSnapshotType::getValidValues())), __LINE__);
        }
        $this->TransactionSnapshotType = $transactionSnapshotType;
        return $this;
    }
}
