<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddDonationToBasket-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AddDonationToBasket-Request
 * @subpackage Structs
 */
class AddDonationToBasket_Request extends ExtensibleDataContract
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Amount;
    /**
     * The AppealId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AppealId;
    /**
     * The CampaignId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CampaignId;
    /**
     * The ChannelId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ChannelId;
    /**
     * The DeliveredByItemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DeliveredByItemId;
    /**
     * The DonationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DonationId;
    /**
     * The InstallmentNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $InstallmentNumber;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Message;
    /**
     * The Notification
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Notification;
    /**
     * The PersonToTribute
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PersonToTribute;
    /**
     * The PledgeFundName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $PledgeFundName;
    /**
     * The PledgeInstallmentId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PledgeInstallmentId;
    /**
     * The SolicitorId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SolicitorId;
    /**
     * The TotalNumberOfInstallments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TotalNumberOfInstallments;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The TransactionSnapshotType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TransactionSnapshotType;
    /**
     * The TributeType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TributeType;
    /**
     * The DonationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DonationDate;
    /**
     * The FundId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $FundId;
    /**
     * The GenerateTaxStatement
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $GenerateTaxStatement;
    /**
     * The GenerateThankYouLetter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $GenerateThankYouLetter;
    /**
     * The IsAnonymous
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsAnonymous;
    /**
     * The NameOnDonation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $NameOnDonation;
    /**
     * The ThankYouLetterSpecialMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ThankYouLetterSpecialMessage;
    /**
     * The GiftDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GiftDescription;
    /**
     * The ApplyProvidedSoftCredit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ApplyProvidedSoftCredit;
    /**
     * The SoftCreditDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfSoftCreditDetail
     */
    public $SoftCreditDetails;
    /**
     * The IsPrintSpecialClientName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsPrintSpecialClientName;
    /**
     * Constructor method for AddDonationToBasket-Request
     * @uses AddDonationToBasket_Request::setAmount()
     * @uses AddDonationToBasket_Request::setAppealId()
     * @uses AddDonationToBasket_Request::setCampaignId()
     * @uses AddDonationToBasket_Request::setChannelId()
     * @uses AddDonationToBasket_Request::setDeliveredByItemId()
     * @uses AddDonationToBasket_Request::setDonationId()
     * @uses AddDonationToBasket_Request::setInstallmentNumber()
     * @uses AddDonationToBasket_Request::setMessage()
     * @uses AddDonationToBasket_Request::setNotification()
     * @uses AddDonationToBasket_Request::setPersonToTribute()
     * @uses AddDonationToBasket_Request::setPledgeFundName()
     * @uses AddDonationToBasket_Request::setPledgeInstallmentId()
     * @uses AddDonationToBasket_Request::setSolicitorId()
     * @uses AddDonationToBasket_Request::setTotalNumberOfInstallments()
     * @uses AddDonationToBasket_Request::setTransactionGuid()
     * @uses AddDonationToBasket_Request::setTransactionSnapshotType()
     * @uses AddDonationToBasket_Request::setTributeType()
     * @uses AddDonationToBasket_Request::setDonationDate()
     * @uses AddDonationToBasket_Request::setFundId()
     * @uses AddDonationToBasket_Request::setGenerateTaxStatement()
     * @uses AddDonationToBasket_Request::setGenerateThankYouLetter()
     * @uses AddDonationToBasket_Request::setIsAnonymous()
     * @uses AddDonationToBasket_Request::setNameOnDonation()
     * @uses AddDonationToBasket_Request::setThankYouLetterSpecialMessage()
     * @uses AddDonationToBasket_Request::setGiftDescription()
     * @uses AddDonationToBasket_Request::setApplyProvidedSoftCredit()
     * @uses AddDonationToBasket_Request::setSoftCreditDetails()
     * @uses AddDonationToBasket_Request::setIsPrintSpecialClientName()
     * @param float $amount
     * @param string $appealId
     * @param string $campaignId
     * @param string $channelId
     * @param int $deliveredByItemId
     * @param string $donationId
     * @param int $installmentNumber
     * @param string $message
     * @param string $notification
     * @param string $personToTribute
     * @param \patest\StructType\GlobalString $pledgeFundName
     * @param string $pledgeInstallmentId
     * @param string $solicitorId
     * @param int $totalNumberOfInstallments
     * @param string $transactionGuid
     * @param string $transactionSnapshotType
     * @param string $tributeType
     * @param string $donationDate
     * @param string $fundId
     * @param bool $generateTaxStatement
     * @param bool $generateThankYouLetter
     * @param bool $isAnonymous
     * @param \patest\StructType\GlobalString $nameOnDonation
     * @param string $thankYouLetterSpecialMessage
     * @param string $giftDescription
     * @param bool $applyProvidedSoftCredit
     * @param \patest\ArrayType\ArrayOfSoftCreditDetail $softCreditDetails
     * @param bool $isPrintSpecialClientName
     */
    public function __construct($amount = null, $appealId = null, $campaignId = null, $channelId = null, $deliveredByItemId = null, $donationId = null, $installmentNumber = null, $message = null, $notification = null, $personToTribute = null, \patest\StructType\GlobalString $pledgeFundName = null, $pledgeInstallmentId = null, $solicitorId = null, $totalNumberOfInstallments = null, $transactionGuid = null, $transactionSnapshotType = null, $tributeType = null, $donationDate = null, $fundId = null, $generateTaxStatement = null, $generateThankYouLetter = null, $isAnonymous = null, \patest\StructType\GlobalString $nameOnDonation = null, $thankYouLetterSpecialMessage = null, $giftDescription = null, $applyProvidedSoftCredit = null, \patest\ArrayType\ArrayOfSoftCreditDetail $softCreditDetails = null, $isPrintSpecialClientName = null)
    {
        $this
            ->setAmount($amount)
            ->setAppealId($appealId)
            ->setCampaignId($campaignId)
            ->setChannelId($channelId)
            ->setDeliveredByItemId($deliveredByItemId)
            ->setDonationId($donationId)
            ->setInstallmentNumber($installmentNumber)
            ->setMessage($message)
            ->setNotification($notification)
            ->setPersonToTribute($personToTribute)
            ->setPledgeFundName($pledgeFundName)
            ->setPledgeInstallmentId($pledgeInstallmentId)
            ->setSolicitorId($solicitorId)
            ->setTotalNumberOfInstallments($totalNumberOfInstallments)
            ->setTransactionGuid($transactionGuid)
            ->setTransactionSnapshotType($transactionSnapshotType)
            ->setTributeType($tributeType)
            ->setDonationDate($donationDate)
            ->setFundId($fundId)
            ->setGenerateTaxStatement($generateTaxStatement)
            ->setGenerateThankYouLetter($generateThankYouLetter)
            ->setIsAnonymous($isAnonymous)
            ->setNameOnDonation($nameOnDonation)
            ->setThankYouLetterSpecialMessage($thankYouLetterSpecialMessage)
            ->setGiftDescription($giftDescription)
            ->setApplyProvidedSoftCredit($applyProvidedSoftCredit)
            ->setSoftCreditDetails($softCreditDetails)
            ->setIsPrintSpecialClientName($isPrintSpecialClientName);
    }
    /**
     * Get Amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAmount()
    {
        return isset($this->Amount) ? $this->Amount : null;
    }
    /**
     * Set Amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $amount
     * @return \patest\StructType\AddDonationToBasket_Request
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        if (is_null($amount) || (is_array($amount) && empty($amount))) {
            unset($this->Amount);
        } else {
            $this->Amount = $amount;
        }
        return $this;
    }
    /**
     * Get AppealId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAppealId()
    {
        return isset($this->AppealId) ? $this->AppealId : null;
    }
    /**
     * Set AppealId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $appealId
     * @return \patest\StructType\AddDonationToBasket_Request
     */
    public function setAppealId($appealId = null)
    {
        // validation for constraint: string
        if (!is_null($appealId) && !is_string($appealId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appealId, true), gettype($appealId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($appealId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $appealId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($appealId, true)), __LINE__);
        }
        if (is_null($appealId) || (is_array($appealId) && empty($appealId))) {
            unset($this->AppealId);
        } else {
            $this->AppealId = $appealId;
        }
        return $this;
    }
    /**
     * Get CampaignId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCampaignId()
    {
        return isset($this->CampaignId) ? $this->CampaignId : null;
    }
    /**
     * Set CampaignId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $campaignId
     * @return \patest\StructType\AddDonationToBasket_Request
     */
    public function setCampaignId($campaignId = null)
    {
        // validation for constraint: string
        if (!is_null($campaignId) && !is_string($campaignId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($campaignId, true), gettype($campaignId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($campaignId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $campaignId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($campaignId, true)), __LINE__);
        }
        if (is_null($campaignId) || (is_array($campaignId) && empty($campaignId))) {
            unset($this->CampaignId);
        } else {
            $this->CampaignId = $campaignId;
        }
        return $this;
    }
    /**
     * Get ChannelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChannelId()
    {
        return isset($this->ChannelId) ? $this->ChannelId : null;
    }
    /**
     * Set ChannelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $channelId
     * @return \patest\StructType\AddDonationToBasket_Request
     */
    public function setChannelId($channelId = null)
    {
        // validation for constraint: string
        if (!is_null($channelId) && !is_string($channelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($channelId, true), gettype($channelId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($channelId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $channelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($channelId, true)), __LINE__);
        }
        if (is_null($channelId) || (is_array($channelId) && empty($channelId))) {
            unset($this->ChannelId);
        } else {
            $this->ChannelId = $channelId;
        }
        return $this;
    }
    /**
     * Get DeliveredByItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDeliveredByItemId()
    {
        return isset($this->DeliveredByItemId) ? $this->DeliveredByItemId : null;
    }
    /**
     * Set DeliveredByItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $deliveredByItemId
     * @return \patest\StructType\AddDonationToBasket_Request
     */
    public function setDeliveredByItemId($deliveredByItemId = null)
    {
        // validation for constraint: int
        if (!is_null($deliveredByItemId) && !(is_int($deliveredByItemId) || ctype_digit($deliveredByItemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deliveredByItemId, true), gettype($deliveredByItemId)), __LINE__);
        }
        if (is_null($deliveredByItemId) || (is_array($deliveredByItemId) && empty($deliveredByItemId))) {
            unset($this->DeliveredByItemId);
        } else {
            $this->DeliveredByItemId = $deliveredByItemId;
        }
        return $this;
    }
    /**
     * Get DonationId value
     * @return string|null
     */
    public function getDonationId()
    {
        return $this->DonationId;
    }
    /**
     * Set DonationId value
     * @param string $donationId
     * @return \patest\StructType\AddDonationToBasket_Request
     */
    public function setDonationId($donationId = null)
    {
        // validation for constraint: string
        if (!is_null($donationId) && !is_string($donationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($donationId, true), gettype($donationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($donationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $donationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($donationId, true)), __LINE__);
        }
        $this->DonationId = $donationId;
        return $this;
    }
    /**
     * Get InstallmentNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getInstallmentNumber()
    {
        return isset($this->InstallmentNumber) ? $this->InstallmentNumber : null;
    }
    /**
     * Set InstallmentNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $installmentNumber
     * @return \patest\StructType\AddDonationToBasket_Request
     */
    public function setInstallmentNumber($installmentNumber = null)
    {
        // validation for constraint: int
        if (!is_null($installmentNumber) && !(is_int($installmentNumber) || ctype_digit($installmentNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($installmentNumber, true), gettype($installmentNumber)), __LINE__);
        }
        if (is_null($installmentNumber) || (is_array($installmentNumber) && empty($installmentNumber))) {
            unset($this->InstallmentNumber);
        } else {
            $this->InstallmentNumber = $installmentNumber;
        }
        return $this;
    }
    /**
     * Get Message value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMessage()
    {
        return isset($this->Message) ? $this->Message : null;
    }
    /**
     * Set Message value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $message
     * @return \patest\StructType\AddDonationToBasket_Request
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        if (is_null($message) || (is_array($message) && empty($message))) {
            unset($this->Message);
        } else {
            $this->Message = $message;
        }
        return $this;
    }
    /**
     * Get Notification value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotification()
    {
        return isset($this->Notification) ? $this->Notification : null;
    }
    /**
     * Set Notification value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notification
     * @return \patest\StructType\AddDonationToBasket_Request
     */
    public function setNotification($notification = null)
    {
        // validation for constraint: string
        if (!is_null($notification) && !is_string($notification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notification, true), gettype($notification)), __LINE__);
        }
        if (is_null($notification) || (is_array($notification) && empty($notification))) {
            unset($this->Notification);
        } else {
            $this->Notification = $notification;
        }
        return $this;
    }
    /**
     * Get PersonToTribute value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPersonToTribute()
    {
        return isset($this->PersonToTribute) ? $this->PersonToTribute : null;
    }
    /**
     * Set PersonToTribute value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $personToTribute
     * @return \patest\StructType\AddDonationToBasket_Request
     */
    public function setPersonToTribute($personToTribute = null)
    {
        // validation for constraint: string
        if (!is_null($personToTribute) && !is_string($personToTribute)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($personToTribute, true), gettype($personToTribute)), __LINE__);
        }
        if (is_null($personToTribute) || (is_array($personToTribute) && empty($personToTribute))) {
            unset($this->PersonToTribute);
        } else {
            $this->PersonToTribute = $personToTribute;
        }
        return $this;
    }
    /**
     * Get PledgeFundName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getPledgeFundName()
    {
        return isset($this->PledgeFundName) ? $this->PledgeFundName : null;
    }
    /**
     * Set PledgeFundName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $pledgeFundName
     * @return \patest\StructType\AddDonationToBasket_Request
     */
    public function setPledgeFundName(\patest\StructType\GlobalString $pledgeFundName = null)
    {
        if (is_null($pledgeFundName) || (is_array($pledgeFundName) && empty($pledgeFundName))) {
            unset($this->PledgeFundName);
        } else {
            $this->PledgeFundName = $pledgeFundName;
        }
        return $this;
    }
    /**
     * Get PledgeInstallmentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPledgeInstallmentId()
    {
        return isset($this->PledgeInstallmentId) ? $this->PledgeInstallmentId : null;
    }
    /**
     * Set PledgeInstallmentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pledgeInstallmentId
     * @return \patest\StructType\AddDonationToBasket_Request
     */
    public function setPledgeInstallmentId($pledgeInstallmentId = null)
    {
        // validation for constraint: string
        if (!is_null($pledgeInstallmentId) && !is_string($pledgeInstallmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pledgeInstallmentId, true), gettype($pledgeInstallmentId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($pledgeInstallmentId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $pledgeInstallmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($pledgeInstallmentId, true)), __LINE__);
        }
        if (is_null($pledgeInstallmentId) || (is_array($pledgeInstallmentId) && empty($pledgeInstallmentId))) {
            unset($this->PledgeInstallmentId);
        } else {
            $this->PledgeInstallmentId = $pledgeInstallmentId;
        }
        return $this;
    }
    /**
     * Get SolicitorId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSolicitorId()
    {
        return isset($this->SolicitorId) ? $this->SolicitorId : null;
    }
    /**
     * Set SolicitorId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $solicitorId
     * @return \patest\StructType\AddDonationToBasket_Request
     */
    public function setSolicitorId($solicitorId = null)
    {
        // validation for constraint: string
        if (!is_null($solicitorId) && !is_string($solicitorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($solicitorId, true), gettype($solicitorId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($solicitorId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $solicitorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($solicitorId, true)), __LINE__);
        }
        if (is_null($solicitorId) || (is_array($solicitorId) && empty($solicitorId))) {
            unset($this->SolicitorId);
        } else {
            $this->SolicitorId = $solicitorId;
        }
        return $this;
    }
    /**
     * Get TotalNumberOfInstallments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTotalNumberOfInstallments()
    {
        return isset($this->TotalNumberOfInstallments) ? $this->TotalNumberOfInstallments : null;
    }
    /**
     * Set TotalNumberOfInstallments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $totalNumberOfInstallments
     * @return \patest\StructType\AddDonationToBasket_Request
     */
    public function setTotalNumberOfInstallments($totalNumberOfInstallments = null)
    {
        // validation for constraint: int
        if (!is_null($totalNumberOfInstallments) && !(is_int($totalNumberOfInstallments) || ctype_digit($totalNumberOfInstallments))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalNumberOfInstallments, true), gettype($totalNumberOfInstallments)), __LINE__);
        }
        if (is_null($totalNumberOfInstallments) || (is_array($totalNumberOfInstallments) && empty($totalNumberOfInstallments))) {
            unset($this->TotalNumberOfInstallments);
        } else {
            $this->TotalNumberOfInstallments = $totalNumberOfInstallments;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return $this->TransactionGuid;
    }
    /**
     * Set TransactionGuid value
     * @param string $transactionGuid
     * @return \patest\StructType\AddDonationToBasket_Request
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        $this->TransactionGuid = $transactionGuid;
        return $this;
    }
    /**
     * Get TransactionSnapshotType value
     * @return string|null
     */
    public function getTransactionSnapshotType()
    {
        return $this->TransactionSnapshotType;
    }
    /**
     * Set TransactionSnapshotType value
     * @uses \patest\EnumType\TransactionSnapshotType::valueIsValid()
     * @uses \patest\EnumType\TransactionSnapshotType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionSnapshotType
     * @return \patest\StructType\AddDonationToBasket_Request
     */
    public function setTransactionSnapshotType($transactionSnapshotType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionSnapshotType::valueIsValid($transactionSnapshotType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionSnapshotType', is_array($transactionSnapshotType) ? implode(', ', $transactionSnapshotType) : var_export($transactionSnapshotType, true), implode(', ', \patest\EnumType\TransactionSnapshotType::getValidValues())), __LINE__);
        }
        $this->TransactionSnapshotType = $transactionSnapshotType;
        return $this;
    }
    /**
     * Get TributeType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTributeType()
    {
        return isset($this->TributeType) ? $this->TributeType : null;
    }
    /**
     * Set TributeType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TributeType::valueIsValid()
     * @uses \patest\EnumType\TributeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tributeType
     * @return \patest\StructType\AddDonationToBasket_Request
     */
    public function setTributeType($tributeType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TributeType::valueIsValid($tributeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TributeType', is_array($tributeType) ? implode(', ', $tributeType) : var_export($tributeType, true), implode(', ', \patest\EnumType\TributeType::getValidValues())), __LINE__);
        }
        if (is_null($tributeType) || (is_array($tributeType) && empty($tributeType))) {
            unset($this->TributeType);
        } else {
            $this->TributeType = $tributeType;
        }
        return $this;
    }
    /**
     * Get DonationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDonationDate()
    {
        return isset($this->DonationDate) ? $this->DonationDate : null;
    }
    /**
     * Set DonationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $donationDate
     * @return \patest\StructType\AddDonationToBasket_Request
     */
    public function setDonationDate($donationDate = null)
    {
        // validation for constraint: string
        if (!is_null($donationDate) && !is_string($donationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($donationDate, true), gettype($donationDate)), __LINE__);
        }
        if (is_null($donationDate) || (is_array($donationDate) && empty($donationDate))) {
            unset($this->DonationDate);
        } else {
            $this->DonationDate = $donationDate;
        }
        return $this;
    }
    /**
     * Get FundId value
     * @return string|null
     */
    public function getFundId()
    {
        return $this->FundId;
    }
    /**
     * Set FundId value
     * @param string $fundId
     * @return \patest\StructType\AddDonationToBasket_Request
     */
    public function setFundId($fundId = null)
    {
        // validation for constraint: string
        if (!is_null($fundId) && !is_string($fundId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fundId, true), gettype($fundId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($fundId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $fundId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($fundId, true)), __LINE__);
        }
        $this->FundId = $fundId;
        return $this;
    }
    /**
     * Get GenerateTaxStatement value
     * @return bool|null
     */
    public function getGenerateTaxStatement()
    {
        return $this->GenerateTaxStatement;
    }
    /**
     * Set GenerateTaxStatement value
     * @param bool $generateTaxStatement
     * @return \patest\StructType\AddDonationToBasket_Request
     */
    public function setGenerateTaxStatement($generateTaxStatement = null)
    {
        // validation for constraint: boolean
        if (!is_null($generateTaxStatement) && !is_bool($generateTaxStatement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($generateTaxStatement, true), gettype($generateTaxStatement)), __LINE__);
        }
        $this->GenerateTaxStatement = $generateTaxStatement;
        return $this;
    }
    /**
     * Get GenerateThankYouLetter value
     * @return bool|null
     */
    public function getGenerateThankYouLetter()
    {
        return $this->GenerateThankYouLetter;
    }
    /**
     * Set GenerateThankYouLetter value
     * @param bool $generateThankYouLetter
     * @return \patest\StructType\AddDonationToBasket_Request
     */
    public function setGenerateThankYouLetter($generateThankYouLetter = null)
    {
        // validation for constraint: boolean
        if (!is_null($generateThankYouLetter) && !is_bool($generateThankYouLetter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($generateThankYouLetter, true), gettype($generateThankYouLetter)), __LINE__);
        }
        $this->GenerateThankYouLetter = $generateThankYouLetter;
        return $this;
    }
    /**
     * Get IsAnonymous value
     * @return bool|null
     */
    public function getIsAnonymous()
    {
        return $this->IsAnonymous;
    }
    /**
     * Set IsAnonymous value
     * @param bool $isAnonymous
     * @return \patest\StructType\AddDonationToBasket_Request
     */
    public function setIsAnonymous($isAnonymous = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAnonymous) && !is_bool($isAnonymous)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAnonymous, true), gettype($isAnonymous)), __LINE__);
        }
        $this->IsAnonymous = $isAnonymous;
        return $this;
    }
    /**
     * Get NameOnDonation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getNameOnDonation()
    {
        return isset($this->NameOnDonation) ? $this->NameOnDonation : null;
    }
    /**
     * Set NameOnDonation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $nameOnDonation
     * @return \patest\StructType\AddDonationToBasket_Request
     */
    public function setNameOnDonation(\patest\StructType\GlobalString $nameOnDonation = null)
    {
        if (is_null($nameOnDonation) || (is_array($nameOnDonation) && empty($nameOnDonation))) {
            unset($this->NameOnDonation);
        } else {
            $this->NameOnDonation = $nameOnDonation;
        }
        return $this;
    }
    /**
     * Get ThankYouLetterSpecialMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getThankYouLetterSpecialMessage()
    {
        return isset($this->ThankYouLetterSpecialMessage) ? $this->ThankYouLetterSpecialMessage : null;
    }
    /**
     * Set ThankYouLetterSpecialMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $thankYouLetterSpecialMessage
     * @return \patest\StructType\AddDonationToBasket_Request
     */
    public function setThankYouLetterSpecialMessage($thankYouLetterSpecialMessage = null)
    {
        // validation for constraint: string
        if (!is_null($thankYouLetterSpecialMessage) && !is_string($thankYouLetterSpecialMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($thankYouLetterSpecialMessage, true), gettype($thankYouLetterSpecialMessage)), __LINE__);
        }
        if (is_null($thankYouLetterSpecialMessage) || (is_array($thankYouLetterSpecialMessage) && empty($thankYouLetterSpecialMessage))) {
            unset($this->ThankYouLetterSpecialMessage);
        } else {
            $this->ThankYouLetterSpecialMessage = $thankYouLetterSpecialMessage;
        }
        return $this;
    }
    /**
     * Get GiftDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGiftDescription()
    {
        return isset($this->GiftDescription) ? $this->GiftDescription : null;
    }
    /**
     * Set GiftDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $giftDescription
     * @return \patest\StructType\AddDonationToBasket_Request
     */
    public function setGiftDescription($giftDescription = null)
    {
        // validation for constraint: string
        if (!is_null($giftDescription) && !is_string($giftDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftDescription, true), gettype($giftDescription)), __LINE__);
        }
        if (is_null($giftDescription) || (is_array($giftDescription) && empty($giftDescription))) {
            unset($this->GiftDescription);
        } else {
            $this->GiftDescription = $giftDescription;
        }
        return $this;
    }
    /**
     * Get ApplyProvidedSoftCredit value
     * @return bool|null
     */
    public function getApplyProvidedSoftCredit()
    {
        return $this->ApplyProvidedSoftCredit;
    }
    /**
     * Set ApplyProvidedSoftCredit value
     * @param bool $applyProvidedSoftCredit
     * @return \patest\StructType\AddDonationToBasket_Request
     */
    public function setApplyProvidedSoftCredit($applyProvidedSoftCredit = null)
    {
        // validation for constraint: boolean
        if (!is_null($applyProvidedSoftCredit) && !is_bool($applyProvidedSoftCredit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($applyProvidedSoftCredit, true), gettype($applyProvidedSoftCredit)), __LINE__);
        }
        $this->ApplyProvidedSoftCredit = $applyProvidedSoftCredit;
        return $this;
    }
    /**
     * Get SoftCreditDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfSoftCreditDetail|null
     */
    public function getSoftCreditDetails()
    {
        return isset($this->SoftCreditDetails) ? $this->SoftCreditDetails : null;
    }
    /**
     * Set SoftCreditDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfSoftCreditDetail $softCreditDetails
     * @return \patest\StructType\AddDonationToBasket_Request
     */
    public function setSoftCreditDetails(\patest\ArrayType\ArrayOfSoftCreditDetail $softCreditDetails = null)
    {
        if (is_null($softCreditDetails) || (is_array($softCreditDetails) && empty($softCreditDetails))) {
            unset($this->SoftCreditDetails);
        } else {
            $this->SoftCreditDetails = $softCreditDetails;
        }
        return $this;
    }
    /**
     * Get IsPrintSpecialClientName value
     * @return bool|null
     */
    public function getIsPrintSpecialClientName()
    {
        return $this->IsPrintSpecialClientName;
    }
    /**
     * Set IsPrintSpecialClientName value
     * @param bool $isPrintSpecialClientName
     * @return \patest\StructType\AddDonationToBasket_Request
     */
    public function setIsPrintSpecialClientName($isPrintSpecialClientName = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrintSpecialClientName) && !is_bool($isPrintSpecialClientName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrintSpecialClientName, true), gettype($isPrintSpecialClientName)), __LINE__);
        }
        $this->IsPrintSpecialClientName = $isPrintSpecialClientName;
        return $this;
    }
}
