<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddClientLinkRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AddClientLinkRequest
 * @subpackage Structs
 */
class AddClientLinkRequest extends AbstractStructBase
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The LinkType
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LinkType;
    /**
     * The LinkeeClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LinkeeClientId;
    /**
     * The LinkeeClientRole
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LinkeeClientRole;
    /**
     * The LinkerClientRole
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LinkerClientRole;
    /**
     * The Passphrase
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Passphrase;
    /**
     * Constructor method for AddClientLinkRequest
     * @uses AddClientLinkRequest::setClientId()
     * @uses AddClientLinkRequest::setLinkType()
     * @uses AddClientLinkRequest::setLinkeeClientId()
     * @uses AddClientLinkRequest::setLinkeeClientRole()
     * @uses AddClientLinkRequest::setLinkerClientRole()
     * @uses AddClientLinkRequest::setPassphrase()
     * @param string $clientId
     * @param string $linkType
     * @param string $linkeeClientId
     * @param string $linkeeClientRole
     * @param string $linkerClientRole
     * @param string $passphrase
     */
    public function __construct($clientId = null, $linkType = null, $linkeeClientId = null, $linkeeClientRole = null, $linkerClientRole = null, $passphrase = null)
    {
        $this
            ->setClientId($clientId)
            ->setLinkType($linkType)
            ->setLinkeeClientId($linkeeClientId)
            ->setLinkeeClientRole($linkeeClientRole)
            ->setLinkerClientRole($linkerClientRole)
            ->setPassphrase($passphrase);
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\AddClientLinkRequest
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get LinkType value
     * @return string|null
     */
    public function getLinkType()
    {
        return $this->LinkType;
    }
    /**
     * Set LinkType value
     * @param string $linkType
     * @return \patest\StructType\AddClientLinkRequest
     */
    public function setLinkType($linkType = null)
    {
        // validation for constraint: string
        if (!is_null($linkType) && !is_string($linkType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linkType, true), gettype($linkType)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($linkType) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $linkType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($linkType, true)), __LINE__);
        }
        $this->LinkType = $linkType;
        return $this;
    }
    /**
     * Get LinkeeClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLinkeeClientId()
    {
        return isset($this->LinkeeClientId) ? $this->LinkeeClientId : null;
    }
    /**
     * Set LinkeeClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $linkeeClientId
     * @return \patest\StructType\AddClientLinkRequest
     */
    public function setLinkeeClientId($linkeeClientId = null)
    {
        // validation for constraint: string
        if (!is_null($linkeeClientId) && !is_string($linkeeClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linkeeClientId, true), gettype($linkeeClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($linkeeClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $linkeeClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($linkeeClientId, true)), __LINE__);
        }
        if (is_null($linkeeClientId) || (is_array($linkeeClientId) && empty($linkeeClientId))) {
            unset($this->LinkeeClientId);
        } else {
            $this->LinkeeClientId = $linkeeClientId;
        }
        return $this;
    }
    /**
     * Get LinkeeClientRole value
     * @return string|null
     */
    public function getLinkeeClientRole()
    {
        return $this->LinkeeClientRole;
    }
    /**
     * Set LinkeeClientRole value
     * @param string $linkeeClientRole
     * @return \patest\StructType\AddClientLinkRequest
     */
    public function setLinkeeClientRole($linkeeClientRole = null)
    {
        // validation for constraint: string
        if (!is_null($linkeeClientRole) && !is_string($linkeeClientRole)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linkeeClientRole, true), gettype($linkeeClientRole)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($linkeeClientRole) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $linkeeClientRole)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($linkeeClientRole, true)), __LINE__);
        }
        $this->LinkeeClientRole = $linkeeClientRole;
        return $this;
    }
    /**
     * Get LinkerClientRole value
     * @return string|null
     */
    public function getLinkerClientRole()
    {
        return $this->LinkerClientRole;
    }
    /**
     * Set LinkerClientRole value
     * @param string $linkerClientRole
     * @return \patest\StructType\AddClientLinkRequest
     */
    public function setLinkerClientRole($linkerClientRole = null)
    {
        // validation for constraint: string
        if (!is_null($linkerClientRole) && !is_string($linkerClientRole)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linkerClientRole, true), gettype($linkerClientRole)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($linkerClientRole) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $linkerClientRole)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($linkerClientRole, true)), __LINE__);
        }
        $this->LinkerClientRole = $linkerClientRole;
        return $this;
    }
    /**
     * Get Passphrase value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPassphrase()
    {
        return isset($this->Passphrase) ? $this->Passphrase : null;
    }
    /**
     * Set Passphrase value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $passphrase
     * @return \patest\StructType\AddClientLinkRequest
     */
    public function setPassphrase($passphrase = null)
    {
        // validation for constraint: string
        if (!is_null($passphrase) && !is_string($passphrase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($passphrase, true), gettype($passphrase)), __LINE__);
        }
        if (is_null($passphrase) || (is_array($passphrase) && empty($passphrase))) {
            unset($this->Passphrase);
        } else {
            $this->Passphrase = $passphrase;
        }
        return $this;
    }
}
