<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdHocRefundProductItem StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AdHocRefundProductItem
 * @subpackage Structs
 */
class AdHocRefundProductItem extends AbstractProductItem
{
    /**
     * The CompanyAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $CompanyAmount;
    /**
     * The ReasonId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ReasonId;
    /**
     * The RelatedTransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RelatedTransactionGuid;
    /**
     * The RelatedTransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RelatedTransactionNumber;
    /**
     * The SiteAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $SiteAmount;
    /**
     * Constructor method for AdHocRefundProductItem
     * @uses AdHocRefundProductItem::setCompanyAmount()
     * @uses AdHocRefundProductItem::setReasonId()
     * @uses AdHocRefundProductItem::setRelatedTransactionGuid()
     * @uses AdHocRefundProductItem::setRelatedTransactionNumber()
     * @uses AdHocRefundProductItem::setSiteAmount()
     * @param \patest\StructType\Money $companyAmount
     * @param string $reasonId
     * @param string $relatedTransactionGuid
     * @param int $relatedTransactionNumber
     * @param \patest\StructType\Money $siteAmount
     */
    public function __construct(\patest\StructType\Money $companyAmount = null, $reasonId = null, $relatedTransactionGuid = null, $relatedTransactionNumber = null, \patest\StructType\Money $siteAmount = null)
    {
        $this
            ->setCompanyAmount($companyAmount)
            ->setReasonId($reasonId)
            ->setRelatedTransactionGuid($relatedTransactionGuid)
            ->setRelatedTransactionNumber($relatedTransactionNumber)
            ->setSiteAmount($siteAmount);
    }
    /**
     * Get CompanyAmount value
     * @return \patest\StructType\Money|null
     */
    public function getCompanyAmount()
    {
        return $this->CompanyAmount;
    }
    /**
     * Set CompanyAmount value
     * @param \patest\StructType\Money $companyAmount
     * @return \patest\StructType\AdHocRefundProductItem
     */
    public function setCompanyAmount(\patest\StructType\Money $companyAmount = null)
    {
        $this->CompanyAmount = $companyAmount;
        return $this;
    }
    /**
     * Get ReasonId value
     * @return string|null
     */
    public function getReasonId()
    {
        return $this->ReasonId;
    }
    /**
     * Set ReasonId value
     * @param string $reasonId
     * @return \patest\StructType\AdHocRefundProductItem
     */
    public function setReasonId($reasonId = null)
    {
        // validation for constraint: string
        if (!is_null($reasonId) && !is_string($reasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reasonId, true), gettype($reasonId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($reasonId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $reasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($reasonId, true)), __LINE__);
        }
        $this->ReasonId = $reasonId;
        return $this;
    }
    /**
     * Get RelatedTransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedTransactionGuid()
    {
        return isset($this->RelatedTransactionGuid) ? $this->RelatedTransactionGuid : null;
    }
    /**
     * Set RelatedTransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedTransactionGuid
     * @return \patest\StructType\AdHocRefundProductItem
     */
    public function setRelatedTransactionGuid($relatedTransactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($relatedTransactionGuid) && !is_string($relatedTransactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedTransactionGuid, true), gettype($relatedTransactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($relatedTransactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $relatedTransactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($relatedTransactionGuid, true)), __LINE__);
        }
        if (is_null($relatedTransactionGuid) || (is_array($relatedTransactionGuid) && empty($relatedTransactionGuid))) {
            unset($this->RelatedTransactionGuid);
        } else {
            $this->RelatedTransactionGuid = $relatedTransactionGuid;
        }
        return $this;
    }
    /**
     * Get RelatedTransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelatedTransactionNumber()
    {
        return isset($this->RelatedTransactionNumber) ? $this->RelatedTransactionNumber : null;
    }
    /**
     * Set RelatedTransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relatedTransactionNumber
     * @return \patest\StructType\AdHocRefundProductItem
     */
    public function setRelatedTransactionNumber($relatedTransactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($relatedTransactionNumber) && !(is_int($relatedTransactionNumber) || ctype_digit($relatedTransactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relatedTransactionNumber, true), gettype($relatedTransactionNumber)), __LINE__);
        }
        if (is_null($relatedTransactionNumber) || (is_array($relatedTransactionNumber) && empty($relatedTransactionNumber))) {
            unset($this->RelatedTransactionNumber);
        } else {
            $this->RelatedTransactionNumber = $relatedTransactionNumber;
        }
        return $this;
    }
    /**
     * Get SiteAmount value
     * @return \patest\StructType\Money|null
     */
    public function getSiteAmount()
    {
        return $this->SiteAmount;
    }
    /**
     * Set SiteAmount value
     * @param \patest\StructType\Money $siteAmount
     * @return \patest\StructType\AdHocRefundProductItem
     */
    public function setSiteAmount(\patest\StructType\Money $siteAmount = null)
    {
        $this->SiteAmount = $siteAmount;
        return $this;
    }
}
